/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.controller;

import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.model.StatisticQuery;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.dao.model.StatisticData;
import com.huawei.csr.framework.service.PlanService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.StatisticService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseController;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.OperationLog;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.CommonUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.PagePara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.AlarmPage;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.AlarmVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.ClearAlarmEntity;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.ClearAlarmPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.InstanceStatisticVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.PlanStatisticVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.PlanSummarizeStatisticVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.PlansRTO;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.PlansRTOVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.PreplanStatisticVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.ServiceInstanceStatistic;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.statistic.SitePlanStatisticVo;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.om.alarm.service.OmAlarmService;
import com.huawei.om.alarm.service.model.AlarmInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.web.bind.annotation.RequestBody;

public class StatisticController
extends BaseController {
    @GET
    @Path(value="/v1/{project_id}/summary/plan-statistic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public PlanSummarizeStatisticVo queryPlanStatistic(@PathParam(value="project_id") String projectId) {
        PlanSummarizeStatisticVo summarizeStatisticVo = new PlanSummarizeStatisticVo();
        PlanStatisticVo planStatisticVo = this.buildPlanStatistics(projectId);
        PreplanStatisticVo preplanStatisticVo = this.buildPreplanStatistics(projectId);
        SitePlanStatisticVo sitePlanStatisticVo = this.buildSitePlanStatistics(projectId);
        summarizeStatisticVo.setPlanStatistics(planStatisticVo);
        summarizeStatisticVo.setPreplanStatistics(preplanStatisticVo);
        summarizeStatisticVo.setSitePlanStatistics(sitePlanStatisticVo);
        return summarizeStatisticVo;
    }

    private PlanStatisticVo buildPlanStatistics(String projectId) {
        PlanStatisticVo planStatisticVo = new PlanStatisticVo();
        StatisticQuery query = new StatisticQuery();
        query.setProjectId(projectId);
        query.setResourceType(RecoverResourceType.RECOVER_PREPLAN.getValue());
        Map<String, Map<String, Integer>> dataMap = this.buildStatisticDataMap(query);
        planStatisticVo.setPlannedMigrationSuccessCount(this.getCount(dataMap, RecoverOperateType.PLANNED_MIGRATION.getValue(), RecoverLogStatus.SUCCESS.getValue()));
        planStatisticVo.setPlannedMigrationFailCount(this.getCount(dataMap, RecoverOperateType.PLANNED_MIGRATION.getValue(), RecoverLogStatus.FAILED.getValue()));
        planStatisticVo.setReprotectSuccessCount(this.getCount(dataMap, RecoverOperateType.REPROTECT.getValue(), RecoverLogStatus.SUCCESS.getValue()));
        planStatisticVo.setReprotectFailCount(this.getCount(dataMap, RecoverOperateType.REPROTECT.getValue(), RecoverLogStatus.FAILED.getValue()));
        planStatisticVo.setDisasterRecoverySuccessCount(this.getCount(dataMap, RecoverOperateType.DISASTER_RECOVERY.getValue(), RecoverLogStatus.SUCCESS.getValue()));
        planStatisticVo.setDisasterRecoveryFailCount(this.getCount(dataMap, RecoverOperateType.DISASTER_RECOVERY.getValue(), RecoverLogStatus.FAILED.getValue()));
        planStatisticVo.setSwitchbackSuccessCount(this.getCount(dataMap, RecoverOperateType.SWITCHBACK.getValue(), RecoverLogStatus.SUCCESS.getValue()));
        planStatisticVo.setSwitchbackFailCount(this.getCount(dataMap, RecoverOperateType.SWITCHBACK.getValue(), RecoverLogStatus.FAILED.getValue()));
        int planSuccessCount = planStatisticVo.getPlannedMigrationSuccessCount() + planStatisticVo.getReprotectSuccessCount() + planStatisticVo.getDisasterRecoverySuccessCount() + planStatisticVo.getSwitchbackSuccessCount();
        planStatisticVo.setPlanSuccessCount(planSuccessCount);
        int planFailCount = planStatisticVo.getPlannedMigrationFailCount() + planStatisticVo.getReprotectFailCount() + planStatisticVo.getDisasterRecoveryFailCount() + planStatisticVo.getSwitchbackFailCount();
        planStatisticVo.setPlanFailCount(planFailCount);
        int planTotalCount = planSuccessCount + planFailCount;
        planStatisticVo.setPlanCount(planTotalCount);
        return planStatisticVo;
    }

    private Map<String, Map<String, Integer>> buildStatisticDataMap(StatisticQuery query) {
        StatisticService statisticService = CommonUtil.getCsrService(StatisticService.class);
        List statisticDataList = statisticService.queryStatistics(query);
        HashMap<String, Map<String, Integer>> dataMap = new HashMap<String, Map<String, Integer>>();
        for (StatisticData data : statisticDataList) {
            Map countMap = dataMap.computeIfAbsent(data.getActivityType(), key -> new HashMap());
            int oldCount = countMap.getOrDefault(data.getResultType(), 0);
            countMap.put(data.getResultType(), oldCount + data.getCount());
        }
        return dataMap;
    }

    private int getCount(Map<String, Map<String, Integer>> dataMap, String activityType, String resultType) {
        Map countMap = dataMap.getOrDefault(activityType, new HashMap());
        return countMap.getOrDefault(resultType, 0);
    }

    private PreplanStatisticVo buildPreplanStatistics(String projectId) {
        RecoverPreplanService preplanService = CommonUtil.getCsrService(RecoverPreplanService.class);
        RecoverPreplanQuery query = new RecoverPreplanQuery();
        query.setProjectId(projectId);
        query.setPreplanType(RecoverOperateType.PLANNED_MIGRATION.getValue());
        int planedCount = preplanService.queryPreplansCount(query);
        query.setPreplanType(RecoverOperateType.DISASTER_RECOVERY.getValue());
        int disasterCount = preplanService.queryPreplansCount(query);
        query.setPreplanType(RecoverOperateType.SWITCHBACK.getValue());
        int switchbackCount = preplanService.queryPreplansCount(query);
        query.setPreplanType(RecoverOperateType.REPROTECT.getValue());
        int reprotectCount = preplanService.queryPreplansCount(query);
        int totalCount = planedCount + disasterCount + switchbackCount + reprotectCount;
        PreplanStatisticVo preplanStatisticVo = new PreplanStatisticVo();
        preplanStatisticVo.setPlannedMigPreplanCount(planedCount);
        preplanStatisticVo.setDisasterRecoveryPreplanCount(disasterCount);
        preplanStatisticVo.setSwitchbackPreplanCount(switchbackCount);
        preplanStatisticVo.setReprotectPreplanCount(reprotectCount);
        preplanStatisticVo.setPreplanCount(totalCount);
        return preplanStatisticVo;
    }

    private SitePlanStatisticVo buildSitePlanStatistics(String projectId) {
        SitePlanStatisticVo sitePlanStatisticVo = new SitePlanStatisticVo();
        long count = CommonUtil.getCsrService(PlanService.class).getRecoverPlanCountBySitePlanId(projectId);
        sitePlanStatisticVo.setSitePlanCount((int)count);
        return sitePlanStatisticVo;
    }

    @GET
    @Path(value="/v1/{project_id}/summary/instance-statistic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public InstanceStatisticVo queryInstanceStatistic(@PathParam(value="project_id") String projectId) {
        InstanceStatisticVo instanceStatisticVo = new InstanceStatisticVo();
        StatisticQuery query = new StatisticQuery();
        query.setProjectId(projectId);
        query.setResourceType(RecoverResourceType.RECOVER_STEP.getValue());
        Map<String, Map<String, Integer>> dataMap = this.buildStatisticDataMap(query);
        ArrayList<ServiceInstanceStatistic> serviceInstanceStatistics = new ArrayList<ServiceInstanceStatistic>();
        int instanceSuccess = 0;
        int instanceFailed = 0;
        for (Map.Entry<String, Map<String, Integer>> entry : dataMap.entrySet()) {
            String instanceType = entry.getKey();
            Map<String, Integer> countMap = entry.getValue();
            ServiceInstanceStatistic statisticVo = new ServiceInstanceStatistic();
            statisticVo.setServiceType(instanceType);
            int successCount = countMap.getOrDefault(RecoverLogStatus.SUCCESS.getValue(), 0);
            instanceSuccess += successCount;
            statisticVo.setSuccessCount(successCount);
            int failCount = countMap.getOrDefault(RecoverLogStatus.FAILED.getValue(), 0);
            instanceFailed += failCount;
            statisticVo.setFailCount(failCount);
            serviceInstanceStatistics.add(statisticVo);
        }
        instanceStatisticVo.setInstanceStatistics(serviceInstanceStatistics);
        instanceStatisticVo.setInstanceSuccessCount(instanceSuccess);
        instanceStatisticVo.setInstanceFailCount(instanceFailed);
        instanceStatisticVo.setInstanceCount(instanceSuccess + instanceFailed);
        return instanceStatisticVo;
    }

    @GET
    @Path(value="/v1/{project_id}/summary/plan-rto")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public PlansRTOVo queryPlansRTO(@PathParam(value="project_id") String projectId, @QueryParam(value="plan_id") List<String> planIds) {
        StatisticService statisticService = CommonUtil.getCsrService(StatisticService.class);
        StatisticQuery query = new StatisticQuery();
        query.setProjectId(projectId);
        if (!VerifyUtil.isEmpty(planIds)) {
            query.setResourceIds(planIds);
        }
        query.setResourceType(RecoverResourceType.RECOVER_PREPLAN.getValue());
        query.setActivityType("rto");
        List statisticDataList = statisticService.queryStatistics(query);
        HashMap<String, Map> dataMap = new HashMap<String, Map>();
        for (Object data : statisticDataList) {
            Map map = dataMap.computeIfAbsent(data.getResourceId(), key -> new HashMap());
            map.put(data.getResultType(), data.getCount());
        }
        ArrayList<PlansRTO> rtoVoList = new ArrayList<PlansRTO>();
        for (Map.Entry entry : dataMap.entrySet()) {
            String eachPlanId = (String)entry.getKey();
            Map countMap = (Map)entry.getValue();
            PlansRTO rto = new PlansRTO();
            rto.setPlanId(eachPlanId);
            rto.setUnknownRTOCount(countMap.getOrDefault("unknown", 0));
            rto.setSatisfiedRTOCount(countMap.getOrDefault("satisfied", 0));
            rto.setUnsatisfiedRTOCount(countMap.getOrDefault("unsatisfied", 0));
            rtoVoList.add(rto);
        }
        PlansRTOVo rtoVo = new PlansRTOVo();
        rtoVo.setPlansRTO(rtoVoList);
        return rtoVo;
    }

    @GET
    @Path(value="/v1/{project_id}/summary/alarms")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public AlarmPage queryAlarms(@PathParam(value="project_id") String projectId, @BeanParam PagePara pagePara, @QueryParam(value="severity") Integer severity, @QueryParam(value="alarm_name") String alarmName) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("project_id", projectId);
        if (!VerifyUtil.isEmpty((String)alarmName)) {
            condition.put("alarm_name", alarmName);
        }
        if (!VerifyUtil.isEmpty((Object)severity)) {
            condition.put("severity", String.valueOf(severity));
        }
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(pagePara.getMarker());
        queryInfo.setTotalRow(pagePara.getLimit());
        queryInfo.setOrderByField("modTime");
        Paging paging = ((IAlarmService)this.getBundleService("fault", "alarmService", IAlarmService.class)).getAlarmsAndCount(FaultEnum.ClearState.UNCLEARED, condition, queryInfo, -1L);
        AlarmPage result = new AlarmPage();
        result.setAlarms(paging.getData().stream().map(data -> {
            if (!(data instanceof LegoAlarm)) {
                throw new LegoCheckedException(1073952404L);
            }
            return this.convertAlarm((LegoAlarm)data);
        }).collect(Collectors.toList()));
        result.setTotalCount(paging.getiCount());
        return result;
    }

    private AlarmVo convertAlarm(LegoAlarm legoAlarm) {
        AlarmVo alarmVo = new AlarmVo();
        alarmVo.setId(legoAlarm.getAlarmId());
        alarmVo.setAlarmName(legoAlarm.getAlarmName());
        alarmVo.setEntity(legoAlarm.getEntity());
        alarmVo.setSeverity(String.valueOf(legoAlarm.getAlarmLevel().getValue()));
        alarmVo.setConfirmStatus(String.valueOf(legoAlarm.getConfirmStatus().getValue()));
        alarmVo.setCount(legoAlarm.getAlarmCount());
        alarmVo.setAlarmSource(legoAlarm.getSourceId());
        alarmVo.setFirstTime(legoAlarm.getFirstTime());
        alarmVo.setAlarmParams(legoAlarm.getAlarmParam());
        alarmVo.setAlarmDesc(legoAlarm.getAlarmDesc());
        alarmVo.setAlarmAdvice(legoAlarm.getAdvice());
        alarmVo.setAlarmEffect(legoAlarm.getSysEffect());
        alarmVo.setLocation(legoAlarm.getLocation());
        return alarmVo;
    }

    @PUT
    @Path(value="/v1/{project_id}/summary/alarms/clearAlarmConfirm")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="clear_project_alarm_operationname", operationModule="protect", level=4)
    public void clearAlarm(@PathParam(value="project_id") String projectId, @Valid @RequestBody ClearAlarmPara clearAlarmPara) {
        OmAlarmService omAlarmService = (OmAlarmService)ServiceLocator.getBundleService((String)"om_alarm", (String)"omAlarmService", OmAlarmService.class);
        String alarmNames = clearAlarmPara.getAlarms().stream().map(ClearAlarmEntity::getAlarmName).collect(Collectors.joining(","));
        this.getOperLogAttrMap().put("operationLogTarget", alarmNames);
        for (ClearAlarmEntity alarm : clearAlarmPara.getAlarms()) {
            AlarmInfo alarmInfo = new AlarmInfo();
            alarmInfo.setProjectId(projectId);
            alarmInfo.setAlarmName(alarm.getAlarmName());
            alarmInfo.setEntity(alarm.getEntity());
            omAlarmService.restoreAlarm(alarmInfo);
        }
    }
}

