/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.csr.framework.common.constants.AppCreateType;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.CreateServiceInstancePara;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Length;

public class CreateApplicationPara {
    @NotNull(message="name is null")
    @Pattern(regexp="^[\\u4e00-\\u9fa50-9a-zA-Z_][\\u4e00-\\u9fa5a-zA-Z_0-9-]{3,31}$", message="AppName is incorrect")
    private @NotNull(message="name is null") @Pattern(regexp="^[\\u4e00-\\u9fa50-9a-zA-Z_][\\u4e00-\\u9fa5a-zA-Z_0-9-]{3,31}$", message="AppName is incorrect") String name;
    @NotBlank(message="description is null or empty")
    @Length(max=255, message="The length of description is limited to 0-255")
    private @NotBlank(message="description is null or empty") @Length(max=255, message="The length of description is limited to 0-255") String description;
    @NotNull(message="create_type is null")
    @JsonProperty(value="create_type")
    private @NotNull(message="create_type is null") AppCreateType createType;
    @Valid
    @Size(min=1, max=64, message="The length of service_instances is limited to 1-64")
    @JsonProperty(value="service_instances")
    private @Valid @Size(min=1, max=64, message="The length of service_instances is limited to 1-64") List<@NotNull(message="service_instance can not is null") CreateServiceInstancePara> serviceInstances;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<CreateServiceInstancePara> getServiceInstances() {
        return this.serviceInstances;
    }

    public void setServiceInstances(List<CreateServiceInstancePara> serviceInstances) {
        this.serviceInstances = serviceInstances;
    }

    public AppCreateType getCreateType() {
        return this.createType;
    }

    public void setCreateType(AppCreateType createType) {
        this.createType = createType;
    }
}

