/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.util;

import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class I18N {
    private static Log logger = LogFactory.getInstance(I18N.class);
    private Map<Locale, List<ResourceBundle>> resMap = new HashMap<Locale, List<ResourceBundle>>();

    public String translateAsZh(String errorCode, String[] args) {
        return this.translate(new Locale("zh", "CN"), errorCode, args);
    }

    public String translateAsEn(String errorCode, String[] args) {
        return this.translate(new Locale("en", "US"), errorCode, args);
    }

    public String translate(Locale locale, String errorCode, String[] args) {
        if (VerifyUtil.isEmpty(this.resMap)) {
            this.loadResources();
        }
        String value = errorCode;
        List<ResourceBundle> resourceBundles = this.resMap.get(locale);
        if (VerifyUtil.isEmpty(resourceBundles)) {
            return value;
        }
        for (ResourceBundle resourceBundle : resourceBundles) {
            try {
                if (!resourceBundle.containsKey(errorCode)) continue;
                value = resourceBundle.getString(errorCode.trim());
                if (!VerifyUtil.isEmpty((Object[])args)) {
                    value = MessageFormatUtil.format((String)value, (Object[])args);
                }
                return value;
            }
            catch (Exception e) {
                logger.debug((Object)("not value: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return value;
    }

    private void loadResources() {
        this.resMap = new HashMap<Locale, List<ResourceBundle>>();
        List enUrls = AdapterUtils.getAllClassPathEntries((String)"i18n/en/*_en.properties");
        List zhUrls = AdapterUtils.getAllClassPathEntries((String)"i18n/zh/*_zh_CN.properties");
        Locale zhLocal = new Locale("zh", "CN");
        Locale enLocal = new Locale("en", "US");
        this.loadResources(enUrls, enLocal);
        this.loadResources(zhUrls, zhLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResources(List<URL> urls, Locale local) {
        Iterator<URL> iterator = urls.iterator();
        BufferedInputStream inputStream = null;
        PropertyResourceBundle resourceBundle = null;
        while (iterator.hasNext()) {
            URL url = iterator.next();
            try {
                inputStream = new BufferedInputStream(url.openStream());
                resourceBundle = new PropertyResourceBundle(inputStream);
            }
            catch (IOException e) {
                try {
                    logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
                }
                catch (Throwable throwable) {
                    CommonUtil.close(inputStream);
                    throw throwable;
                }
                CommonUtil.close((Closeable)inputStream);
            }
            CommonUtil.close((Closeable)inputStream);
            List<ResourceBundle> bundleLst = this.resMap.get(local);
            if (null == bundleLst) {
                bundleLst = new ArrayList<ResourceBundle>();
                bundleLst.add(resourceBundle);
                this.resMap.put(local, bundleLst);
                continue;
            }
            bundleLst.add(resourceBundle);
            this.resMap.put(local, bundleLst);
        }
    }
}

