/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.web.exception;

import com.huawei.ism.drm.cloudservice.rest.cloudservice.util.I18N;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.cxf.validation.ResponseConstraintViolationException;

public class CloudServiceExceptionMapper
implements ExceptionMapper<Exception> {
    private static Log logger = LogFactory.getInstance(CloudServiceExceptionMapper.class);
    private Map<Locale, List<ResourceBundle>> resMap = new HashMap<Locale, List<ResourceBundle>>();
    private I18N i18n;
    @Context
    private HttpServletRequest request;

    public I18N getI18n() {
        return this.i18n;
    }

    public void setI18n(I18N i18n) {
        this.i18n = i18n;
    }

    protected HttpServletRequest getRequest() {
        return this.request;
    }

    protected void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    protected String getCurrentUser() {
        if (this.request == null) {
            return null;
        }
        String userName = this.request.getHeader("x-auth-token");
        if (null == userName || userName.isEmpty()) {
            userName = "--";
        }
        return userName;
    }

    public Response toResponse(Exception ex) {
        if (null == ex) {
            return Response.ok().build();
        }
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        JSONObject jsonObject = new JSONObject();
        if (ex instanceof LegoCheckedException) {
            Response.Status legoStatus = this.handleLegoCheckedException(ex, jsonObject);
            if (null != legoStatus) {
                status = legoStatus;
            }
        } else if (ex instanceof RestException) {
            RestException e = (RestException)ex;
            if (1073947691L == e.getErrorCode()) {
                status = Response.Status.UNAUTHORIZED;
            } else if (1073947400L == e.getErrorCode()) {
                status = Response.Status.FORBIDDEN;
            }
        } else if (this.isRequestConstraintViolationException(ex)) {
            status = Response.Status.BAD_REQUEST;
            jsonObject.put((Object)"error_code", (Object)String.valueOf(1073947393L));
            jsonObject.put((Object)"error_msg", (Object)this.getConstraintViolationMessage((ConstraintViolationException)ex));
        } else {
            jsonObject.put((Object)"error_code", (Object)String.valueOf(-1L));
        }
        String requestId = (String)this.request.getAttribute("REQUEST_LOG_ID");
        if (null == requestId) {
            requestId = "req-unknown";
        }
        logger.info((Object)(requestId + ":response is" + status.getStatusCode() + ", msg is " + jsonObject.toString() + ", exception is " + ExceptionUtil.getErrorMessage((Throwable)ex)));
        Response.ResponseBuilder rb = Response.status((Response.Status)status);
        rb.type("application/json;charset=UTF-8");
        rb.entity((Object)jsonObject.toString());
        rb.language(this.getLocale());
        return rb.build();
    }

    private String getConstraintViolationMessage(ConstraintViolationException ex) {
        return ex.getConstraintViolations() == null ? "" : ex.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(";"));
    }

    private boolean isRequestConstraintViolationException(Exception ex) {
        return ex instanceof ConstraintViolationException && !(ex instanceof ResponseConstraintViolationException);
    }

    private Response.Status handleLegoCheckedException(Exception ex, JSONObject jsonObject) {
        LegoCheckedException e = (LegoCheckedException)((Object)ex);
        this.updateErrorMsg(jsonObject, e);
        Response.Status status = null;
        if (1073947691L == e.getErrorCode()) {
            status = Response.Status.UNAUTHORIZED;
        } else if (1073947400L == e.getErrorCode()) {
            status = Response.Status.FORBIDDEN;
        } else if (201L == e.getErrorCode() || 1073947394L == e.getErrorCode() || 2117645L == e.getErrorCode()) {
            status = Response.Status.NOT_FOUND;
        } else if (1073948693L == e.getErrorCode()) {
            status = Response.Status.CONFLICT;
        } else if (1073947393L == e.getErrorCode()) {
            status = Response.Status.BAD_REQUEST;
        }
        return status;
    }

    private void updateErrorMsg(JSONObject jsonObject, LegoCheckedException e) {
        jsonObject.put((Object)"error_msg", (Object)this.translate(e));
        jsonObject.put((Object)"error_code", (Object)String.valueOf(e.getErrorCode()));
        if (null == e.getParameters()) {
            return;
        }
        JSONArray array = JSONArray.fromObject((Object)e.getParameters());
        jsonObject.put((Object)"error_param", (Object)array);
    }

    private String translate(LegoCheckedException ex) {
        String language = this.request.getHeader("X-language");
        if (VerifyUtil.isEmpty((String)language)) {
            language = this.request.getHeader("Accept-Language");
        }
        if (VerifyUtil.isEmpty((String)language)) {
            language = "en_us";
        }
        if (Arrays.asList("zh-cn", "zh_cn").contains(language.toLowerCase(Locale.US))) {
            return this.i18n.translateAsZh(ex.getErrorCode() + "", ex.getParameters());
        }
        return this.i18n.translateAsEn(ex.getErrorCode() + "", ex.getParameters());
    }

    private Locale getLocale() {
        return Locale.ENGLISH;
    }
}

