/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloud.sdk.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.ism.drm.cloud.sdk.api.CloudBackupApis;
import com.huawei.ism.drm.cloud.sdk.api.service.ServerBackupService;
import com.huawei.ism.drm.cloud.sdk.client.CloudBackupOSClient;

public class CloudBackupClientSession
implements CloudBackupOSClient {
    private static final ThreadLocal<CloudBackupClientSession> SESSIONS = new ThreadLocal();
    private String reqId;

    public String getReqId() {
        return this.reqId;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public static CloudBackupClientSession getCurrent() {
        return SESSIONS.get();
    }

    @Override
    public ServerBackupService serverBackup() {
        return CloudBackupApis.get(ServerBackupService.class);
    }

    public static class CloudBackupClientSessionAKSK
    implements CloudBackupOSClient.CloudBackupOSClientAKSK {
        private static final ThreadLocal<CloudBackupClientSessionAKSK> SESSIONS = new ThreadLocal();
        private String accessKey;
        private String secretKey;
        private String serviceDomain;
        private String projectId;

        @Override
        public CloudBackupOSClient.CloudBackupOSClientAKSK credentials(String pAccessKey, String pSecretKey, String pRegion, String pProjectId, String pServiceDomain) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pAccessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pSecretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pRegion) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pProjectId) ? 1 : 0) != 0, (Object)"parameter `projectId` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pServiceDomain) ? 1 : 0) != 0, (Object)"parameter `domain` should not be empty");
            this.accessKey = pAccessKey;
            this.secretKey = pSecretKey;
            this.serviceDomain = pServiceDomain;
            this.projectId = pProjectId;
            SESSIONS.set(this);
            return this;
        }

        public static CloudBackupClientSessionAKSK getCurrent() {
            return SESSIONS.get();
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getServiceDomain() {
            return this.serviceDomain;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getRegion() {
            return null;
        }

        @Override
        public ServerBackupService serverBackup() {
            return CloudBackupApis.get(ServerBackupService.class);
        }
    }
}

