/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.replica.sdk.model;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ProtectGroupReplica
implements Serializable,
Cloneable,
Comparable<ProtectGroupReplica> {
    private static final long serialVersionUID = -6860699187430523171L;
    private String id;
    private String name;
    private String timeStamp;
    private int type;
    private int status;
    private int index;
    private ProtectGroup pg;
    private Set<ProtectObjectReplica> replicas = new HashSet<ProtectObjectReplica>();
    private String recoverySite;
    private String productArray;
    private String recoveryArray;
    private int protectLocation;
    private Map<String, String> props = new HashMap<String, String>();
    private String poReplicaMateData;
    private String mountedHost;
    private Integer mountStatus;
    private Integer accessLevel;
    private String label;
    private String sourceReplicaId;
    private Integer consistentType;
    private Integer generation = 1;
    private String scheduleId;
    private DeleteMode deleteMode;

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public String getUtcTimeStamp() {
        return CommUtil.formatDate(null == this.timeStamp ? null : new Date(NumberUtil.convertToLong((Object)this.timeStamp)));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ProtectGroup getPg() {
        return this.pg;
    }

    public void setPg(ProtectGroup pg) {
        this.pg = pg;
        this.props.putAll(pg.getProps());
    }

    public String getRecoverySite() {
        return this.recoverySite;
    }

    public void setRecoverySite(String recoverySite) {
        this.recoverySite = recoverySite;
    }

    public String getProductArray() {
        return this.productArray;
    }

    public void setProductArray(String productArray) {
        this.productArray = productArray;
    }

    public String getRecoveryArray() {
        return this.recoveryArray;
    }

    public void setRecoveryArray(String recoveryArray) {
        this.recoveryArray = recoveryArray;
    }

    public int getProtectLocation() {
        return this.protectLocation;
    }

    public void setProtectLocation(int protectLocation) {
        this.protectLocation = protectLocation;
    }

    public String getMountedHost() {
        return this.mountedHost;
    }

    public void setMountedHost(String mountedHost) {
        this.mountedHost = mountedHost;
    }

    public Integer getMountStatus() {
        return this.mountStatus;
    }

    public void setMountStatus(Integer mountStatus) {
        this.mountStatus = mountStatus;
    }

    public Integer getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(Integer accessLevel) {
        this.accessLevel = accessLevel;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getSourceReplicaId() {
        return this.sourceReplicaId;
    }

    public void setSourceReplicaId(String sourceReplicaId) {
        this.sourceReplicaId = sourceReplicaId;
    }

    public Integer getConsistentType() {
        return this.consistentType;
    }

    public void setConsistentType(Integer consistentType) {
        this.consistentType = consistentType;
    }

    public Integer getGeneration() {
        return this.generation;
    }

    public void setGeneration(Integer generation) {
        this.generation = generation;
    }

    public DeleteMode getDeleteMode() {
        return this.deleteMode;
    }

    public void setDeleteMode(DeleteMode deleteMode) {
        this.deleteMode = deleteMode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtectGroupReplica other = (ProtectGroupReplica)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public int compareTo(ProtectGroupReplica o) {
        if (null == o) {
            return -1;
        }
        if (null == o.timeStamp) {
            return 1;
        }
        if (null == this.timeStamp) {
            return -1;
        }
        if (new Date(NumberUtil.convertToLong((Object)this.timeStamp)).before(new Date(NumberUtil.convertToLong((Object)o.timeStamp)))) {
            return -1;
        }
        if (new Date(NumberUtil.convertToLong((Object)this.timeStamp)).after(new Date(NumberUtil.convertToLong((Object)o.timeStamp)))) {
            return 1;
        }
        return 0;
    }

    public void addProtectObjectReplica(ProtectObjectReplica protectObjectReplica) {
        protectObjectReplica.setPgReplica(this);
        this.getReplicas().add(protectObjectReplica);
    }

    public Object clone() throws CloneNotSupportedException {
        ProtectGroupReplica result = (ProtectGroupReplica)super.clone();
        HashSet<ProtectObjectReplica> protectObjectReplicaList = new HashSet<ProtectObjectReplica>();
        for (ProtectObjectReplica protectObjectReplica : result.getReplicas()) {
            ProtectObjectReplica cloneProtectObjectReplica = (ProtectObjectReplica)protectObjectReplica.clone();
            cloneProtectObjectReplica.setPgReplica(result);
            protectObjectReplicaList.add(cloneProtectObjectReplica);
        }
        result.setReplicas(protectObjectReplicaList);
        HashMap<String, String> replicaProps = new HashMap<String, String>();
        replicaProps.putAll(result.getProps());
        result.setProps(replicaProps);
        return result;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public void addProperty(String key, String value) {
        if (null != this.props) {
            this.props.put(key, value);
        }
    }

    public String getProperty(String key) {
        if (null == this.props) {
            return null;
        }
        return this.props.get(key);
    }

    public Set<ProtectObjectReplica> getReplicas() {
        if (VerifyUtil.isEmpty(this.replicas) && !VerifyUtil.isEmpty((String)this.poReplicaMateData)) {
            JSONArray poReplicaJsonArray = JSONArray.fromObject((Object)this.poReplicaMateData);
            for (int i = 0; i < poReplicaJsonArray.size(); ++i) {
                JSONObject json = JSONObject.fromObject((Object)poReplicaJsonArray.get(i));
                ProtectObjectReplica poReplica = ProtectObjectReplica.toBean(json);
                poReplica.setPgReplica(this);
                this.replicas.add(poReplica);
            }
        }
        return this.replicas;
    }

    public void setReplicas(Set<ProtectObjectReplica> replicas) {
        this.replicas = replicas;
    }

    public String getPoReplicaMateData() {
        if (!VerifyUtil.isEmpty(this.replicas)) {
            JSONArray result = new JSONArray();
            for (ProtectObjectReplica replica : this.replicas) {
                result.add((Object)replica.toJson());
            }
            this.poReplicaMateData = result.toString();
        }
        return this.poReplicaMateData;
    }

    public void setPoReplicaMateData(String poReplicaMateData) {
        this.poReplicaMateData = poReplicaMateData;
    }

    public String getStorageDeviceId() {
        String storageDeviceId = null;
        Set<ProtectObjectReplica> protectObjectReplicaSet = this.getReplicas();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicaSet) {
            RelicaStorageInfo storageInfo;
            Set<RelicaStorageInfo> storageInfos = protectObjectReplica.getStorageInfos();
            Iterator<RelicaStorageInfo> iterator = storageInfos.iterator();
            while (iterator.hasNext() && null == (storageDeviceId = (storageInfo = iterator.next()).getStorageProviderSN())) {
            }
            if (null == storageDeviceId) continue;
            break;
        }
        return storageDeviceId;
    }

    public boolean isStorageReplicationReplica() {
        int protectionType = this.getType();
        return 2 == protectionType || 1 == protectionType;
    }

    public boolean isStorageSnapshotReplica() {
        int protectionType = this.getType();
        return 3 == protectionType || 8 == protectionType || 6 == protectionType || 4 == protectionType;
    }

    public boolean isBackUpReplica() {
        return 101 == this.getType();
    }

    public boolean isHyperCDPReplica() {
        return 4 == this.getType();
    }

    public boolean isSanSnapshotConsitentGroupReplica() {
        boolean result = this.isSanSnapshotReplica();
        if (!result) {
            return false;
        }
        Set<ProtectObjectReplica> protectObjectReplicaSet = this.getReplicas();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicaSet) {
            Set<RelicaStorageInfo> storageInfos = protectObjectReplica.getStorageInfos();
            for (RelicaStorageInfo storageInfo : storageInfos) {
                LocalStorageReplica localStorageReplica;
                if (!(storageInfo instanceof LocalStorageReplica) || VerifyUtil.isEmpty((String)(localStorageReplica = (LocalStorageReplica)storageInfo).getConsistentGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSanSnapshotReplica() {
        return 3 == this.getType() || 4 == this.getType();
    }

    public boolean isCloneVolumeReplica() {
        return 9 == this.getType();
    }

    public boolean isLocalStorageSnapshotReplica() {
        boolean result = this.isStorageSnapshotReplica();
        if (result) {
            String deviceSn = this.getStorageDeviceId();
            if (null == deviceSn) {
                return false;
            }
            return deviceSn.equals(this.getProductArray());
        }
        if (this.isBackUpReplica()) {
            String deviceSn = this.getStorageDeviceId();
            if (null == deviceSn) {
                return false;
            }
            return deviceSn.equals(this.getProductArray());
        }
        return false;
    }

    public static enum DeleteMode {
        SYNC(1),
        ASYNC(2);

        private int value;

        private DeleteMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

