/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.schedule.sdk.model;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReplicationSpeedPolicy
implements Serializable {
    private static final long serialVersionUID = -1228797953350661410L;
    private String startTime;
    private String endTime;
    private int syncRateLevel;
    private String storageSn;

    public String getStartTime() {
        return this.startTime;
    }

    public String getStorageSn() {
        return this.storageSn;
    }

    public void setStorageSn(String storageSn) {
        this.storageSn = storageSn;
    }

    public void setStartTime(String startTime) {
        this.checkTime(startTime);
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.checkTime(endTime);
        this.endTime = endTime;
    }

    public int getSyncRateLevel() {
        return this.syncRateLevel;
    }

    public void setSyncRateLevel(int syncRateLevel) {
        if (syncRateLevel < DmEnumDefine.SPEED_LEVEL_E.SPEED_LEVEL_LOW.getValue() || syncRateLevel > DmEnumDefine.SPEED_LEVEL_E.SPEED_LEVEL_ASAP.getValue()) {
            throw new LegoCheckedException(1073947393L);
        }
        this.syncRateLevel = syncRateLevel;
    }

    private void checkTime(String time) {
        time = Normalizer.normalize(time, Normalizer.Form.NFKC);
        String regex = "^([01]?\\d|2[0-3]):[0][0]$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(time);
        if (!matcher.matches()) {
            throw new LegoCheckedException(1073947393L);
        }
    }
}

