/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.template.sdk.service;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemlate;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;
import java.util.Set;

public abstract class AbstractReplicaBuilder
extends AbstractPolicyTemlate
implements IReplicaBuilder {
    protected static final String REPLICA_INDEX = "REPLICA_INDEX";
    protected static final String PROTECT_TYPE = "PROTECT_TYPE";
    protected static final String PROTECT_LOCATION = "PROTECT_LOCATION";
    protected static final String SRC_DEVICE = "SRC_DEVICE";
    protected static final String SRC_RESOURCEID_MAP = "SRC_NAS_RESOURCEIDS";
    protected static final String PROTECT_GROUP = "PROTECT_GROUP";
    private static final Log logger = LogFactory.getInstance(AbstractReplicaBuilder.class);
    private ThreadLocal<Map<String, Object>> builderContext = new AbstractPolicyTemlate.ThreadLocalMapContainer<String, Object>();

    public Map<String, Object> getBuilderContext() {
        return this.builderContext.get();
    }

    protected int getInt(String key) {
        return NumberUtil.convertToInteger((Object)String.valueOf(this.getBuilderContext().get(key)));
    }

    protected String getString(String key) {
        return String.valueOf(this.getBuilderContext().get(key));
    }

    protected String getDevAndLun(String deviceId, String lunId) {
        return deviceId + ":" + lunId;
    }

    @Override
    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        return null;
    }

    protected String getSiteBySn(String deviceSN) {
        String siteId = null;
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            siteId = drResource.getSiteId();
        }
        return siteId;
    }

    public String getSrcDevSN(ProtectGroup protectGroup) {
        String srcDevSN = null;
        for (ProtectObject po : protectGroup.getPolist()) {
            for (ProtectObjectStorageInfo info : po.getUsedStorageResourceSet()) {
                srcDevSN = info.getResourceProviderSN();
            }
        }
        if (VerifyUtil.isEmpty(srcDevSN)) {
            logger.error((Object)"product array is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        return srcDevSN;
    }
}

