/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.ism.drm.storage.sdk.model.LicenseFunctionItem;
import com.huawei.ism.drm.storage.sdk.model.LicenseUsageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StorageLicense
implements Serializable {
    private static final long serialVersionUID = 6394209485621768080L;
    private static final int FEATURE_ON = 1;
    private static final int FEATURE_OFF = 0;
    @JsonProperty(value="LibVer")
    private String libVer;
    @JsonProperty(value="FileExist")
    private String fileExist;
    @JsonProperty(value="CreatedTime")
    private String createdTime;
    @JsonProperty(value="LicenseSerialNo")
    private String licenseSerialNo;
    @JsonProperty(value="licenseType")
    private String licenseType;
    @JsonProperty(value="LicenseFunction")
    private List<LicenseFunctionItem> functionItemList;
    @JsonProperty(value="LicenseUsageInfo")
    private List<LicenseUsageInfo> usageInfoList;

    public String getLibVer() {
        return this.libVer;
    }

    public void setLibVer(String libVer) {
        this.libVer = libVer;
    }

    public String getFileExist() {
        return this.fileExist;
    }

    public void setFileExist(String fileExist) {
        this.fileExist = fileExist;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getLicenseSerialNo() {
        return this.licenseSerialNo;
    }

    public void setLicenseSerialNo(String licenseSerialNo) {
        this.licenseSerialNo = licenseSerialNo;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public List<LicenseFunctionItem> getFunctionItemList() {
        return this.functionItemList;
    }

    public void setFunctionItemList(List<LicenseFunctionItem> functionItemList) {
        this.functionItemList = functionItemList;
    }

    public List<LicenseUsageInfo> getUsageInfoList() {
        return this.usageInfoList;
    }

    public void setUsageInfoList(List<LicenseUsageInfo> usageInfoList) {
        this.usageInfoList = usageInfoList;
    }

    @JsonIgnore
    public boolean isSupportFeature(String featureId) {
        if (null == this.functionItemList || this.functionItemList.isEmpty()) {
            return false;
        }
        List items = this.functionItemList.stream().filter(item -> featureId.equals(item.getFeatureId()) && item.getFuncSwitch() == 1).collect(Collectors.toList());
        return null != items && !items.isEmpty();
    }

    public void disableFeature(String featureId) {
        List items = this.functionItemList.stream().filter(item -> featureId.equals(item.getFeatureId())).collect(Collectors.toList());
        if (null == items || items.isEmpty()) {
            return;
        }
        LicenseFunctionItem item2 = (LicenseFunctionItem)items.stream().findFirst().get();
        item2.setFuncSwitch(0);
    }

    public void addFeature(String featureId, String runTime) {
        if (null == this.functionItemList || this.functionItemList.isEmpty()) {
            this.functionItemList = new ArrayList<LicenseFunctionItem>();
        }
        LicenseFunctionItem item = new LicenseFunctionItem();
        item.setFuncSwitch(1);
        item.setFeatureId(featureId);
        item.setRunTime(runTime);
        this.functionItemList.add(item);
    }
}

