/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

import com.huawei.ism.drm.util.Base64;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class ReverseObjectSerializableUtils {
    private static final Log log = LogFactory.getInstance(ReverseObjectSerializableUtils.class);

    private ReverseObjectSerializableUtils() {
    }

    public static String serializableObj(Object obj) {
        ByteArrayOutputStream outputStream = null;
        ObjectOutputStream output = null;
        try {
            outputStream = new ByteArrayOutputStream();
            output = new ObjectOutputStream(outputStream);
            output.writeObject(obj);
            byte[] bufs = outputStream.toByteArray();
            String string = Base64.byteArrayToBase64(bufs);
            return string;
        }
        catch (IOException e) {
            log.error((Object)("serializable object class:" + obj.getClass() + " is error."), 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        finally {
            if (null != output) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    log.error((Object)"close serializable ObjectOutputStream is error.", 90160758787071L);
                }
            }
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"close serializable ByteArrayOutputStream is error.", 90160758787071L);
                }
            }
        }
    }

    public static <T> T reverseeObj(String content, Class<T> classs) {
        ByteArrayInputStream inputStream = null;
        ObjectInputStream input = null;
        try {
            inputStream = new ByteArrayInputStream(Base64.base64ToByteArray(content));
            input = new ObjectInputStream(inputStream);
            Object object = input.readObject();
            return (T)object;
        }
        catch (IOException e) {
            log.error((Object)("reversee serializable is error.class:" + classs), 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("reversee serializable is error.class:" + classs), 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.error((Object)"close serializable ObjectInputStream is error.", 90160758787071L);
                }
            }
            if (null != inputStream) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    log.error((Object)"close serializable ByteArrayInputStream is error.", 90160758787071L);
                }
            }
        }
    }
}

