/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.csha;

import com.huawei.csr.app.csha.constants.CshaCsrDefaultAction;
import com.huawei.csr.app.csha.service.CshaService;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AbstractAppManager;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.InstanceObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class CshaManager
extends AbstractAppManager {
    private static final Log LOG = LogFactory.getInstance(CshaManager.class);
    private CshaService cshaService;

    public CshaManager() {
        this.setAppIdentifier(new AppIdentifier(ServiceType.CSHA.getValue()));
    }

    public List<AppServiceInstance> canProtectServiceInstances(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        return this.cshaService.queryServiceInstances(filter, credential);
    }

    public boolean isProtectableServiceInstance(String serviceInstanceId, Credential credential) throws ClientException, IOException, ResponseException {
        return this.cshaService.isProtectableServiceInstance(serviceInstanceId, credential);
    }

    public Set<InstanceObject> getInstanceObjects(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        return this.cshaService.getInstanceObjects(serviceInstanceId, credential);
    }

    public Optional<RecoverStepAction> getServiceInstanceDefaultAction(RecoverOperateType csrOperationType) {
        if (VerifyUtil.isEmpty((Object)((Object)CshaCsrDefaultAction.from(csrOperationType)))) {
            LOG.error((Object)"CshaCsrDefaultAction not exist with OperationType '%s'", new Object[]{csrOperationType});
            throw new LegoCheckedException(1073952404L);
        }
        return Optional.ofNullable(CshaCsrDefaultAction.from(csrOperationType).getDefaultAction());
    }

    public AppServiceInstance getProtectServiceInstance(String instanceId, Credential credential) throws ResponseException, ClientException, IOException {
        return this.cshaService.queryProtectServiceInstanceDetail(instanceId, credential);
    }

    public CshaService getCshaService() {
        return this.cshaService;
    }

    public void setCshaService(CshaService cshaService) {
        this.cshaService = cshaService;
    }
}

