/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.csha.check;

import com.huawei.csr.app.csha.check.ICshaStepCheck;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public class CshaExecutorCheckManager {
    private static final Log LOG = LogFactory.getInstance(CshaExecutorCheckManager.class);
    private static CshaExecutorCheckManager instance;
    private final Map<String, ICshaStepCheck> stepCheckExecutors = new HashMap<String, ICshaStepCheck>();

    public static synchronized CshaExecutorCheckManager getInstance() {
        if (instance == null) {
            instance = new CshaExecutorCheckManager();
        }
        return instance;
    }

    public void onBind(ICshaStepCheck provider, Map<?, ?> properties) {
        this.stepCheckExecutors.put(provider.getOperationType(), provider);
    }

    public void onUnbind(ICshaStepCheck provider, Map<?, ?> properties) {
        this.stepCheckExecutors.remove(provider.getOperationType());
    }

    public ICshaStepCheck getStepExecutor(String operationType) {
        if (!this.stepCheckExecutors.containsKey(operationType)) {
            LOG.error((Object)"The stepCheck class is not found, operationType:%s", new Object[]{operationType});
            throw new LegoCheckedException(1073952404L, "The stepCheck class is not found, operationType: " + operationType);
        }
        return this.stepCheckExecutors.get(operationType);
    }
}

