/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.csha.check;

import com.huawei.csr.app.csha.check.ICshaStepCheck;
import com.huawei.csr.app.csha.constants.InstanceInfoStatus;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.sdk.csha.model.CshaInstance;
import com.huawei.sdk.csha.model.response.CshaInstanceDetail;
import java.util.Set;

public class SwitchRecoveryStepCheck
implements ICshaStepCheck {
    private static final Log LOG = LogFactory.getInstance(SwitchRecoveryStepCheck.class);

    @Override
    public String getOperationType() {
        return RecoverStepAction.SWITCHBACK.getValue();
    }

    @Override
    public boolean checkStepBeforeOperation(CshaInstanceDetail cshaInstanceDetail, String siteId) {
        CshaInstance cshaInstance = cshaInstanceDetail.getInstance();
        String instancePrimaryRegionAz = cshaInstance.getRegion() + cshaInstance.getAvailableZone();
        Set<String> regionAzSets = this.getSiteRegionAz(siteId);
        if (!regionAzSets.contains(instancePrimaryRegionAz) && (InstanceInfoStatus.NORMAL.getStatus().equals(cshaInstance.getStatus()) || InstanceInfoStatus.PAUSED_SWITCHOVER.getStatus().equals(cshaInstance.getStatus()) || InstanceInfoStatus.ERR_SWITCHOVER.getStatus().equals(cshaInstance.getStatus()))) {
            return false;
        }
        if (regionAzSets.contains(instancePrimaryRegionAz) && InstanceInfoStatus.NORMAL.getStatus().equals(cshaInstance.getStatus())) {
            return true;
        }
        LOG.error((Object)"Step(%s) is not reqiure execution Conditions, siteId: %s, instance status: %s", new Object[]{RecoverStepAction.SWITCHBACK.getValue(), siteId, cshaInstance.getStatus()});
        throw new LegoCheckedException(1073953101L);
    }

    @Override
    public boolean checkStepAfterOperation(CshaInstanceDetail cshaInstanceDetail, String siteId) {
        CshaInstance cshaInstance = cshaInstanceDetail.getInstance();
        String instancePrimaryRegionAz = cshaInstance.getRegion() + cshaInstance.getAvailableZone();
        String instanceRemoteRegionAz = cshaInstance.getRegion() + cshaInstance.getSalveAvailableZone();
        Set<String> regionAzSets = this.getSiteRegionAz(siteId);
        return regionAzSets.contains(instancePrimaryRegionAz) && !regionAzSets.contains(instanceRemoteRegionAz) && InstanceInfoStatus.NORMAL.getStatus().equals(cshaInstance.getStatus());
    }
}

