/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.csha.constants;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import java.util.Arrays;

public enum CshaCsrDefaultAction {
    PLANNED_MIGRATION(RecoverOperateType.PLANNED_MIGRATION, RecoverStepAction.PLANNED_MIGRATION),
    DISASTER_RECOVERY(RecoverOperateType.DISASTER_RECOVERY, RecoverStepAction.DISASTER_RECOVERY),
    REPROTECT(RecoverOperateType.REPROTECT, RecoverStepAction.REPROTECT),
    SWITCHBACK(RecoverOperateType.SWITCHBACK, RecoverStepAction.SWITCHBACK);

    private final RecoverOperateType csrOpType;
    private final RecoverStepAction defaultAction;

    private CshaCsrDefaultAction(RecoverOperateType csrOpType, RecoverStepAction defaultAction) {
        this.csrOpType = csrOpType;
        this.defaultAction = defaultAction;
    }

    public RecoverOperateType getCsrOpType() {
        return this.csrOpType;
    }

    public RecoverStepAction getDefaultAction() {
        return this.defaultAction;
    }

    @JsonCreator
    public static CshaCsrDefaultAction from(RecoverOperateType operateType) {
        return Arrays.stream(CshaCsrDefaultAction.values()).filter(em -> em.csrOpType.equals((Object)operateType)).findFirst().orElse(null);
    }
}

