/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.csha.constants;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import java.util.Arrays;

public enum InstanceInfoStatus {
    NORMAL("normal", ServiceInstanceStatus.NORMAL.getValue(), true),
    SWITCHOVERD("switchoverd", ServiceInstanceStatus.NORMAL.getValue(), true),
    FAILOVERED("failovered", ServiceInstanceStatus.NORMAL.getValue(), true),
    TESTED("tested", ServiceInstanceStatus.NORMAL.getValue(), true),
    ERR_DELETE("err-delete", ServiceInstanceStatus.ERROR.getValue(), false),
    ERR_SWITCHOVER("err-switchover", ServiceInstanceStatus.ERROR.getValue(), false),
    ERR_HOTMIGRATION("err-hotmigration", ServiceInstanceStatus.ERROR.getValue(), false),
    ERR_FAILOVER("err-failover", ServiceInstanceStatus.ERROR.getValue(), false),
    ERR_REPROTECT("err-reprotect", ServiceInstanceStatus.ERROR.getValue(), false),
    ERR_TEST("err-test", ServiceInstanceStatus.ERROR.getValue(), false),
    ERR_CLEAR("err-clear", ServiceInstanceStatus.ERROR.getValue(), false),
    ERR_MODIFY_TYPE("err-modify-type", ServiceInstanceStatus.ERROR.getValue(), false),
    DELETING("deleting", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    SWITCHOVERING("switchovering", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    HOTMIGRATIONING("hotmigrationing", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    FAILOVERING("failovering", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    REPROTECTING("reprotecting", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    TESTING("testing", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    CLEARING("clearing", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    MAINTAIN("maintain", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    LOCKED("locked", ServiceInstanceStatus.MAINTAIN.getValue(), false),
    STOP("stop", ServiceInstanceStatus.ERROR.getValue(), false),
    ERROR("error", ServiceInstanceStatus.ERROR.getValue(), false),
    DISABLED("disabled", ServiceInstanceStatus.ERROR.getValue(), false),
    COPYING("copying", ServiceInstanceStatus.COPYING.getValue(), false),
    PAUSED_SWITCHOVER("paused-switchover", ServiceInstanceStatus.MAINTAIN.getValue(), false);

    private final String status;
    private final String csrStatus;
    private final boolean isProtectable;

    private InstanceInfoStatus(String status, String csrStatus, boolean isProtectable) {
        this.status = status;
        this.csrStatus = csrStatus;
        this.isProtectable = isProtectable;
    }

    public String getCsrStatus() {
        return this.csrStatus;
    }

    @JsonValue
    public String getStatus() {
        return this.status;
    }

    public boolean getProtectable() {
        return this.isProtectable;
    }

    @JsonCreator
    public static InstanceInfoStatus from(String value) {
        return Arrays.stream(InstanceInfoStatus.values()).filter(em -> em.status.equalsIgnoreCase(value)).findFirst().orElse(null);
    }
}

