/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.csha.constants;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.csr.framework.common.statusopt.status.InstanceObjectStatus;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import java.util.Arrays;

public enum ObjectInfoStatus {
    BUILD("build", InstanceObjectStatus.CREATING.getValue()),
    ACTIVE("active", InstanceObjectStatus.NORMAL.getValue()),
    NORMAL("normal", InstanceObjectStatus.NORMAL.getValue()),
    ERROR("error", InstanceObjectStatus.ERROR.getValue()),
    REBUILD("rebuild", InstanceObjectStatus.MAINTAIN.getValue()),
    MIGRATING("migrating", InstanceObjectStatus.MAINTAIN.getValue()),
    STOPPED("stopped", InstanceObjectStatus.MAINTAIN.getValue()),
    SHUTOFF("shutoff", ServiceInstanceStatus.MAINTAIN.getValue()),
    UNRECOGNIZED("unrecognized", ServiceInstanceStatus.MAINTAIN.getValue());

    private final String status;
    private final String csrStatus;

    private ObjectInfoStatus(String status, String csrStatus) {
        this.status = status;
        this.csrStatus = csrStatus;
    }

    public String getCsrStatus() {
        return this.csrStatus;
    }

    @JsonValue
    public String getStatus() {
        return this.status;
    }

    @JsonCreator
    public static ObjectInfoStatus from(String value) {
        return Arrays.stream(ObjectInfoStatus.values()).filter(em -> em.status.equalsIgnoreCase(value)).findFirst().orElse(null);
    }
}

