/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.csha.executor;

import com.huawei.csr.app.csha.util.StatusCheckUtils;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.core.executor.AbstractStepExecutor;
import com.huawei.csr.framework.core.executor.PollingStrategy;
import com.huawei.csr.framework.core.executor.StepExecuteContext;
import com.huawei.csr.framework.core.identifier.StepIdentifier;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.csha.CshaClient;
import com.huawei.sdk.csha.model.CshaInstance;
import com.huawei.sdk.csha.model.RecoveryPolicy;
import com.huawei.sdk.csha.model.response.CshaInstanceDetail;
import java.io.IOException;

public class DisasterRecoveryExecutor
extends AbstractStepExecutor {
    private static final Log LOG = LogFactory.getInstance(DisasterRecoveryExecutor.class);
    private PollingStrategy cshaPoller;

    public DisasterRecoveryExecutor() {
        this.setStepIdentifier(new StepIdentifier(ServiceType.CSHA.getValue(), RecoverStepAction.DISASTER_RECOVERY.getValue()));
    }

    public void work(RecoverStep step, StepExecuteContext executeContext) throws ResponseException, ClientException, IOException {
        String siteId;
        AppServiceInstance serviceInstance = ((ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class)).getServiceInstanceById(step.getServiceInstanceId());
        Credential credential = new Credential(executeContext.getRequestContext().getProjectId(), executeContext.getRequestContext().getAuthToken(), EndpointUtil.getEndpoint((String)step.getServiceType(), (String)serviceInstance.getPdRegionId()));
        CshaClient client = (CshaClient)ServiceLocator.getInstance().getService(CshaClient.class);
        CshaInstanceDetail cshaInstanceDetail = client.getCshaInstanceDetail(serviceInstance.getInstanceId(), credential);
        if (StatusCheckUtils.checkBeforeOperateStatus(RecoverStepAction.DISASTER_RECOVERY, cshaInstanceDetail, siteId = executeContext.getOptSiteId())) {
            LOG.info((Object)"ServiceInstance Satisfied, no need execute, app status: %s, siteId: %s", new Object[]{cshaInstanceDetail.getInstance().getStatus(), siteId});
            return;
        }
        RecoveryPolicy recoveryPolicy = new RecoveryPolicy();
        CshaInstance cshaInstance = cshaInstanceDetail.getInstance();
        recoveryPolicy.setRegionId(cshaInstance.getRegion());
        recoveryPolicy.setAzId(cshaInstance.getAvailableZone());
        client.disasterRecovery(serviceInstance.getInstanceId(), recoveryPolicy, credential);
        this.cshaPoller.executePoller(executeContext, context -> {
            CshaInstanceDetail detail = client.getCshaInstanceDetail(serviceInstance.getInstanceId(), credential);
            if (VerifyUtil.isEmpty((Object)detail)) {
                LOG.error((Object)"Step(%s) of cshaInstance is not exist. instanceId:%s", new Object[]{step.getId(), serviceInstance.getInstanceId()});
                throw new LegoCheckedException(1073947394L);
            }
            return StatusCheckUtils.checkAfterOperateStatus(RecoverStepAction.DISASTER_RECOVERY, detail, siteId);
        });
    }

    public PollingStrategy getCshaPoller() {
        return this.cshaPoller;
    }

    public void setCshaPoller(PollingStrategy cshaPoller) {
        this.cshaPoller = cshaPoller;
    }
}

