/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.csha.executor;

import com.huawei.csr.app.csha.executor.PlannedMigrationExecutor;
import com.huawei.csr.app.csha.util.StatusCheckUtils;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.core.executor.StepExecuteContext;
import com.huawei.csr.framework.core.identifier.StepIdentifier;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.csha.model.response.CshaInstanceDetail;
import java.io.IOException;

public class SwitchRecoveryExecutor
extends PlannedMigrationExecutor {
    private static final Log LOG = LogFactory.getInstance(SwitchRecoveryExecutor.class);

    public SwitchRecoveryExecutor() {
        this.setStepIdentifier(new StepIdentifier(ServiceType.CSHA.getValue(), RecoverStepAction.SWITCHBACK.getValue()));
    }

    @Override
    public void work(RecoverStep step, StepExecuteContext executeContext) throws ResponseException, ClientException, IOException {
        super.work(step, executeContext);
    }

    @Override
    public boolean checkBeforeExecute(StepExecuteContext executeContext, CshaInstanceDetail cshaInstanceDetail) {
        String siteId = executeContext.getOptSiteId();
        if (StatusCheckUtils.checkBeforeOperateStatus(RecoverStepAction.SWITCHBACK, cshaInstanceDetail, siteId)) {
            LOG.info((Object)"ServiceInstance Satisfied, no need execute, app status: %s, siteId: %s", new Object[]{cshaInstanceDetail.getInstance().getStatus(), siteId});
            return true;
        }
        return false;
    }

    @Override
    public boolean checkAfterExecute(StepExecuteContext executeContext, CshaInstanceDetail cshaInstanceDetail) {
        return StatusCheckUtils.checkAfterOperateStatus(RecoverStepAction.SWITCHBACK, cshaInstanceDetail, executeContext.getOptSiteId());
    }
}

