/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.csha.service;

import com.huawei.csr.app.csha.constants.InstanceInfoReplicaStatus;
import com.huawei.csr.app.csha.constants.InstanceInfoStatus;
import com.huawei.csr.app.csha.constants.ObjectInfoStatus;
import com.huawei.csr.app.csha.service.CshaService;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.common.statusopt.status.InstanceObjectStatus;
import com.huawei.csr.framework.common.statusopt.status.ReplicaStatus;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.InstanceObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.csha.CshaClient;
import com.huawei.sdk.csha.model.CshaInstance;
import com.huawei.sdk.csha.model.request.CshaInstanceSearchReq;
import com.huawei.sdk.csha.model.response.CshaInstanceDetail;
import com.huawei.sdk.csha.model.response.ListCshaInstanceResponse;
import com.huawei.sdk.csha.model.response.ListCshaInstanceServerResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CshaServiceImpl
implements CshaService {
    private static final Log LOG = LogFactory.getInstance(CshaServiceImpl.class);
    private CshaClient cshaClient;

    @Override
    public List<AppServiceInstance> queryServiceInstances(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        int limitMax;
        if (!this.checkRegionAz(filter)) {
            LOG.error((Object)"CheckRegionAz error,pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId()});
            return Collections.emptyList();
        }
        LOG.debug((Object)"Start queryServiceInstances, pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s, projectId: %s, endpoint: %s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId(), credential.getProjectId(), credential.getEndpoint()});
        int totalCount = limitMax = 512;
        CshaInstanceSearchReq cshaInstanceSearchReq = new CshaInstanceSearchReq();
        cshaInstanceSearchReq.setName(filter.getInstanceName());
        cshaInstanceSearchReq.setInstanceType(ServiceType.CSHA.getValue());
        ArrayList cshaInstanceList = new ArrayList();
        for (int index = 1; totalCount >= index; index += limitMax) {
            cshaInstanceSearchReq.setMarker(Integer.valueOf(index));
            cshaInstanceSearchReq.setLimit(Integer.valueOf(limitMax));
            ListCshaInstanceResponse instancesResponseLoop = this.cshaClient.getCshaInstanceList(cshaInstanceSearchReq, credential);
            cshaInstanceList.addAll(instancesResponseLoop.getInstances());
            totalCount = instancesResponseLoop.getTotalCount();
        }
        Stream<Object> stream = cshaInstanceList.stream();
        if (!VerifyUtil.isEmpty((String)filter.getInstanceId())) {
            stream = stream.filter(serviceInstance -> serviceInstance.getId().contains(filter.getInstanceId()));
        }
        return stream.map(this::getAppServiceInstance).filter(serviceInstance -> ServiceType.CSHA.getValue().equals(serviceInstance.getServiceType()) && InstanceInfoStatus.from(serviceInstance.getStatus()).getProtectable() && filter.getPdAzId().equals(serviceInstance.getPdAzId()) && filter.getDrAzId().equals(serviceInstance.getDrAzId())).collect(Collectors.toList());
    }

    @Override
    public AppServiceInstance queryProtectServiceInstanceDetail(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        LOG.debug((Object)"Start queryProtectServiceInstanceDetail, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        CshaInstanceDetail cshaInstanceDetail = this.cshaClient.getCshaInstanceDetail(serviceInstanceId, credential);
        return this.getAppServiceInstance(cshaInstanceDetail.getInstance());
    }

    @Override
    public boolean isProtectableServiceInstance(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        LOG.debug((Object)"Start isProtectableServiceInstance, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        CshaInstanceDetail cshaInstanceDetail = this.cshaClient.getCshaInstanceDetail(serviceInstanceId, credential);
        return InstanceInfoStatus.from(cshaInstanceDetail.getInstance().getStatus()).getProtectable();
    }

    @Override
    public Set<InstanceObject> getInstanceObjects(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        LOG.debug((Object)"Start getInstanceObjects, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        ListCshaInstanceServerResponse list = this.cshaClient.getCshaInstanceServers(serviceInstanceId, credential);
        return this.convert2serverObject(list);
    }

    private AppServiceInstance getAppServiceInstance(CshaInstance cshaInstance) {
        AppServiceInstance instance = new AppServiceInstance();
        instance.setInstanceName(cshaInstance.getName());
        instance.setInstanceId(cshaInstance.getId());
        instance.setServiceType(ServiceType.CSHA.getValue());
        instance.setProjectId(cshaInstance.getProjectId());
        instance.setStatus(InstanceInfoStatus.from(cshaInstance.getStatus()).getCsrStatus());
        instance.setPdAzId(cshaInstance.getAvailableZone());
        instance.setPdRegionId(cshaInstance.getRegion());
        instance.setDrAzId(cshaInstance.getSalveAvailableZone());
        instance.setDrRegionId(cshaInstance.getRegion());
        ReplicaStatus csrStatus = InstanceInfoReplicaStatus.from(cshaInstance.getReplicaStatus()).getCsrStatus();
        instance.setReplicaStatus(csrStatus.getValue());
        instance.setInstanceObjectCount(Integer.valueOf(cshaInstance.getServers().size()));
        return instance;
    }

    private Set<InstanceObject> convert2serverObject(ListCshaInstanceServerResponse list) {
        return list.getServers().stream().map(item -> {
            InstanceObject instanceObject = new InstanceObject();
            instanceObject.setPdId(item.getServerId());
            instanceObject.setPdName(item.getName());
            ObjectInfoStatus pdStatusEnum = ObjectInfoStatus.from(item.getStatus());
            if (!VerifyUtil.isEmpty((Object)((Object)pdStatusEnum))) {
                instanceObject.setPdStatus(pdStatusEnum.getCsrStatus());
            }
            instanceObject.setDrId(item.getRecoverySetting().getOccupiedVm().getServerId());
            instanceObject.setDrName(item.getRecoverySetting().getOccupiedVm().getName());
            instanceObject.setDrStatus(InstanceObjectStatus.MAINTAIN.getValue());
            return instanceObject;
        }).collect(Collectors.toSet());
    }

    private boolean checkRegionAz(ServiceInstanceFilter filter) {
        return !VerifyUtil.isEmpty((String)filter.getPdRegionId()) && !VerifyUtil.isEmpty((String)filter.getPdAzId()) && !VerifyUtil.isEmpty((String)filter.getDrRegionId()) && !VerifyUtil.isEmpty((String)filter.getDrAzId());
    }

    public void setCshaClient(CshaClient cshaClient) {
        this.cshaClient = cshaClient;
    }
}

