/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.csha.topo;

import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.constants.TopoRelationState;
import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AppManager;
import com.huawei.csr.framework.core.manager.AppPluginManager;
import com.huawei.csr.framework.dao.model.TopoLink;
import com.huawei.csr.framework.dao.model.TopoNode;
import com.huawei.csr.framework.topo.build.AbstractTopoBuilder;
import com.huawei.csr.framework.topo.build.BuildContext;
import com.huawei.csr.framework.topo.build.TopoSource;
import com.huawei.csr.framework.topo.build.TopoSourceType;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.om.auth.util.AuthUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;
import java.util.List;

public class CshaTopoBuilder
extends AbstractTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(CshaTopoBuilder.class);

    public CshaTopoBuilder(String supportType, List<String> dependencies) {
        super(supportType, dependencies);
    }

    public void build(BuildContext context, TopoSource topoSource) {
        TopoNode masterTopoNode = this.buildCommonNode(topoSource, TopoRelationState.MASTER.getValue());
        masterTopoNode.setEntity(topoSource.getResourceId() + ":" + TopoSourceType.CSHA.getValue() + ":" + TopoRelationState.MASTER.getValue());
        context.addTopoNode(masterTopoNode);
        TopoNode slaveTopoNode = this.buildCommonNode(topoSource, TopoRelationState.SLAVE.getValue());
        slaveTopoNode.setEntity(topoSource.getResourceId() + ":" + TopoSourceType.CSHA.getValue() + ":" + TopoRelationState.SLAVE.getValue());
        context.addTopoNode(slaveTopoNode);
        TopoLink topoLink = this.buildCommonLink(topoSource, masterTopoNode, slaveTopoNode);
        context.addTopoLink(topoLink);
        List childSources = topoSource.getChildSources();
        childSources.forEach(eachSource -> {
            TopoNode masterPoTopoNode = this.buildCommonNode((TopoSource)eachSource, TopoRelationState.MASTER.getValue());
            masterPoTopoNode.setResourceId(masterTopoNode.getId());
            masterPoTopoNode.setEntity(eachSource.getPdId() + ":" + TopoSourceType.VM.getValue());
            context.addTopoNode(masterPoTopoNode);
            context.addAddress(this.getVmAddress(eachSource.getProjectId(), eachSource.getPdRegionId(), eachSource.getPdId()), masterPoTopoNode.getId() + "," + masterTopoNode.getId());
            TopoNode slavePoTopoNode = this.buildCommonNode((TopoSource)eachSource, TopoRelationState.SLAVE.getValue());
            slavePoTopoNode.setResourceId(slaveTopoNode.getId());
            slavePoTopoNode.setEntity(eachSource.getDrId() + ":" + TopoSourceType.VM.getValue());
            context.addTopoNode(slavePoTopoNode);
            context.addAddress(this.getVmAddress(eachSource.getProjectId(), eachSource.getDrRegionId(), eachSource.getDrId()), slavePoTopoNode.getId() + "," + slaveTopoNode.getId());
        });
    }

    private String getVmAddress(String projectId, String regionId, String poId) {
        String authToken;
        AppIdentifier appIdentifier = new AppIdentifier(ServiceType.ECS.getValue());
        AppManager manager = AppPluginManager.getInstance().getAppManager(appIdentifier);
        try {
            authToken = AuthUtil.getScopedAuthToken((String)projectId);
        }
        catch (ClientException | ResponseException | IOException e) {
            LOGGER.error((Object)"Fetch authToken failed. msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return "";
        }
        String endPoint = EndpointUtil.getEndpoint((String)TopoSourceType.ECS.getValue(), (String)regionId);
        Credential credential = new Credential(projectId, authToken, endPoint);
        try {
            return manager.getProtectServiceInstance(poId, credential).getInstanceAddress();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Get ecs failed. msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return "";
        }
    }
}

