/*
 * Decompiled with CFR 0.152.
 */
package com.huawei;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class FileSigner {
    private final String exportFile = "SignFile";
    private final String encryptKeyFile = "SignFile.conf";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Param error.");
            return;
        }
        FileSigner sigen = new FileSigner();
        if ("export".equals(args[0])) {
            if (args.length < 3) {
                System.out.println("usage: [export] [exportPath] [password].");
                return;
            }
            sigen.export(args[1], args[2]);
            return;
        }
        if (args.length == 1) {
            String filePath = args[0];
            sigen.signFile(filePath);
            return;
        }
        String baseDir = args[0];
        String filePath = args[1];
        System.out.println("set base directory: " + baseDir);
        System.out.println("read files from " + filePath + "...");
        File file = new File(filePath);
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String path = baseDir + line.trim();
                System.out.println("sign file: " + path);
                sigen.signFile(path);
            }
        }
        catch (Exception e) {
            try {
                System.out.println("sign file failed, error: " + e);
            }
            catch (Throwable throwable) {
                FileSigner.closeStream(br);
                throw throwable;
            }
            FileSigner.closeStream(br);
            return;
        }
        FileSigner.closeStream(br);
        return;
    }

    private static void closeInputStream(InputStream input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                System.out.println("close BufferedReader failed.");
            }
        }
    }

    private static void closeStream(BufferedReader br) {
        if (null != br) {
            try {
                br.close();
            }
            catch (IOException e) {
                System.out.println("close BufferedReader failed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void signFile(String file) {
        String currPath = System.getProperty("user.dir");
        System.out.println("currPath =" + currPath);
        String wccConfFile = currPath + "/Runtime/LegoRuntime/conf/wcc";
        File conf = new File(wccConfFile);
        FileInputStream input = null;
        try {
            KmcInstance.initComponent((String)conf.getCanonicalPath(), (boolean)true);
            System.out.println("start sign file: " + file);
            input = new FileInputStream(file);
            byte[] bytes = new byte[((InputStream)input).available()];
            ((InputStream)input).read(bytes);
            String hash = KmcInstance.hmac((String)new String(bytes, StandardCharsets.UTF_8));
            this.writeHashToSign(file, hash);
            FileSigner.closeInputStream(input);
        }
        catch (FileNotFoundException e) {
            System.out.println("sigen file [" + file + "] failed, can't find the file.");
        }
        catch (Exception e2) {
            System.out.println("sign file [" + file + "] failed, errMsg: " + e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            FileSigner.closeInputStream(input);
        }
        finally {
            FileSigner.closeInputStream(input);
        }
    }

    private void writeFile(String file, String msg) throws IOException {
        FileWriter fw = null;
        File ff = new File(file);
        try {
            if (ff.exists()) {
                ff.delete();
            }
            if (ff.createNewFile()) {
                fw = new FileWriter(file);
                fw.write(msg);
                fw.flush();
            }
        }
        catch (Exception e) {
            System.out.println("write file failed, ErrMsg: " + e);
            throw new IOException("writ file failed, file is: " + file);
        }
        finally {
            FileSigner.cloeseWriter(fw);
        }
    }

    public void writeHashToSign(String sFile, String hash) throws IOException {
        File sign = new File(sFile);
        String path = sign.getParent();
        File sigenFile = new File(path, sign.getName() + ".sign");
        String tmp = sigenFile.getCanonicalPath();
        this.writeFile(tmp, hash);
    }

    private static void cloeseWriter(FileWriter fw) {
        if (null != fw) {
            try {
                fw.close();
            }
            catch (Exception e) {
                System.out.println("close writer failed.");
            }
        }
    }

    private void writePwdToFile(String path, String password) throws IOException {
        String key = null;
        try {
            key = KmcInstance.encrypt((String)password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File encryptFile = new File(path, "SignFile.conf");
        String file = encryptFile.getCanonicalPath();
        this.writeFile(file, key);
    }

    private void export(String exportPath, String password) {
        System.out.println("Export cryptor to file.");
        String currPath = System.getProperty("user.dir");
        String wccConfFile = currPath + "/Runtime/LegoRuntime/conf";
        File conf = new File(wccConfFile);
        try {
            KmcInstance.initComponent((String)conf.getCanonicalPath(), (boolean)true);
            this.writePwdToFile(exportPath, password);
        }
        catch (IOException e) {
            System.out.println("Write encryptedPwd to file failed.");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File export = new File(exportPath, "SignFile");
        try {
            String file = export.getCanonicalPath();
            KmcInstance.getInstance().exportMkFile(file, password.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

