/*
 * Decompiled with CFR 0.152.
 */
package com.huawei;

import com.huawei.EncryptFile;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ProperUtil {
    private static final String fileName = "FileName";
    private static final String keyName = "KeyName";
    private static final String keyValue = "KeyValue";
    private static final String nodeValue = "NodeValue";
    private List<EncryptFile> utilList = new ArrayList<EncryptFile>();
    private Properties PROPS = new Properties();

    private static boolean isEmpty(String str) {
        return "".equals(str) || null == str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEncryptedProperties(String confFile) {
        InputStream is = null;
        try {
            ClassLoader clazzLoader = ProperUtil.class.getClassLoader();
            if (null != clazzLoader) {
                is = clazzLoader.getResourceAsStream(confFile);
            }
            if (null != is) {
                this.PROPS.load(is);
                this.initMaps();
            } else {
                System.out.println("get resource failed.");
            }
        }
        catch (IOException e) {
            System.out.println("read default.properties fail." + e);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    System.out.println("close exception: " + e);
                }
            }
        }
    }

    private void initMaps() throws IOException {
        Set<Object> keys = this.PROPS.keySet();
        for (String string : keys) {
            EncryptFile fileUtil = new EncryptFile();
            if (!string.startsWith(fileName)) continue;
            String endStr = string.substring(fileName.length());
            String fileN = this.PROPS.getProperty(string);
            String keyN = this.PROPS.getProperty(keyName + endStr);
            String node = this.PROPS.getProperty(nodeValue + endStr);
            if (ProperUtil.isEmpty(fileN) || ProperUtil.isEmpty(keyN)) {
                System.out.println("file: " + fileN + ", key: " + keyN + ", some value is null.");
                throw new IOException();
            }
            if (fileN.endsWith(".xml") && ProperUtil.isEmpty(node)) {
                System.out.println("xml must config the key: NodeValue" + endStr);
                throw new IOException();
            }
            if (this.PROPS.containsKey(keyValue + endStr)) {
                String keyV = this.PROPS.getProperty(keyValue + endStr);
                fileUtil.setKeyValue(keyV);
            }
            fileUtil.setFileName(fileN);
            fileUtil.setKeyName(keyN);
            fileUtil.setNodeValue(node);
            this.utilList.add(fileUtil);
        }
    }

    public Properties getKmcConfFile(String kmcConf) {
        ClassLoader classLoader = null;
        Properties allProperties = new Properties();
        Properties tempProperties = new Properties();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(kmcConf));
            tempProperties.load(bufferedReader);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.printf("load default properties file : %s", e.toString());
            e.printStackTrace();
        }
        if (null != tempProperties) {
            return tempProperties;
        }
        if (classLoader == null) {
            try (InputStream inputStream = classLoader.getResourceAsStream(kmcConf);){
                allProperties.load(inputStream);
            }
            catch (IOException e) {
                System.err.printf("load default properties file : %s", e.toString());
            }
        }
        return allProperties;
    }

    public List<EncryptFile> getUtilList() {
        return this.utilList;
    }

    public Properties getProps() {
        return this.PROPS;
    }
}

