/*
 * Decompiled with CFR 0.152.
 */
package com.huawei;

import com.huawei.EncryptFile;
import com.huawei.FileUtil;
import com.huawei.ProperUtil;
import com.huawei.WccEncryptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class UpdatePassword {
    private static final String PROPERTIES = "conf.properties";

    private static void updateServerXml(String xmlFile, String node, String key, String value1) throws Exception {
        if (!new File(xmlFile).exists()) {
            System.out.println("file is not exists: " + xmlFile);
            return;
        }
        FileOutputStream fout = null;
        XMLWriter writer = null;
        SAXReader reader = new SAXReader();
        File xml = new File(xmlFile);
        try {
            UpdatePassword.setSecurityFeatures(reader);
            Document document = reader.read(xml);
            List element = document.selectNodes(node);
            if (null == element) {
                System.out.println("select nodes failed.");
            }
            for (Node ele : element) {
                String currentValue;
                if (null == ((Element)ele).attribute(key) || "".equals(currentValue = ((Element)ele).attribute(key).getValue()) && null == currentValue) continue;
                System.out.println("node key: " + key + ", node value: " + value1);
                String encryptdata = WccEncryptor.encode(value1);
                ((Element)ele).addAttribute(key, encryptdata);
                System.out.println("get line: " + encryptdata);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            fout = new FileOutputStream(new File(xmlFile));
            writer = new XMLWriter((OutputStream)fout, format);
            writer.write(document);
        }
        catch (Exception e) {
            try {
                System.out.println("update " + xmlFile + " failed, exception: " + e);
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.closeOutStream(fout, writer);
                throw throwable;
            }
        }
        FileUtil.closeOutStream(fout, writer);
    }

    private static void setSecurityFeatures(SAXReader reader) throws SAXException {
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    private static void updateProperties(String file, String key, String value) throws IOException {
        String[] values;
        File tmp = new File(file);
        if (!tmp.exists()) {
            System.out.println("the file is not exists.");
            throw new IOException();
        }
        String[] keys = key.split(";");
        if (keys.length != (values = value.split(";")).length) {
            System.out.println("keys length= " + keys.length + ", values length: " + values.length);
            throw new IOException();
        }
        LineIterator lineIterator = FileUtils.lineIterator((File)new File(file), (String)StandardCharsets.UTF_8.name());
        String filePathTmp = new File(file).getParent() + File.separator + "tmpConf.properties";
        BufferedWriter filePathTmpBw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePathTmp), StandardCharsets.UTF_8));
        while (lineIterator.hasNext()) {
            String line = lineIterator.next();
            if (line != null) {
                String newLine = line;
                for (int i = 0; i < keys.length; ++i) {
                    if (FileUtil.isEmpty(line) || !line.replace(" ", "").startsWith(keys[i] + "=")) continue;
                    System.out.println("keys: " + keys[i] + ", values: " + values[i]);
                    newLine = keys[i] + "=" + WccEncryptor.encrypt(values[i]);
                    System.out.println("get line: " + newLine);
                }
                filePathTmpBw.write(newLine);
                filePathTmpBw.newLine();
                continue;
            }
            filePathTmpBw.write(line);
            filePathTmpBw.newLine();
        }
        if (null != lineIterator) {
            lineIterator.close();
        }
        if (null != filePathTmpBw) {
            filePathTmpBw.close();
        }
        new File(file).delete();
        FileUtils.moveFile((File)new File(filePathTmp), (File)new File(file));
    }

    private static void encryptPassword(String file, String value) throws Exception {
        File tmp = new File(file);
        if (!tmp.exists()) {
            System.out.println("the file is not exists.");
            throw new IOException();
        }
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(tmp));
            String str = WccEncryptor.encrypt(value);
            writer.write(str);
            writer.newLine();
            writer.flush();
        }
        catch (Exception e) {
            try {
                System.out.println("error. " + e);
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.closeReader(writer, reader);
                throw throwable;
            }
        }
        FileUtil.closeReader(writer, reader);
    }

    public static void main(String[] args) throws Exception {
        ProperUtil properUtil = new ProperUtil();
        properUtil.getEncryptedProperties(PROPERTIES);
        List<EncryptFile> fileList = properUtil.getUtilList();
        if (null == fileList || fileList.isEmpty()) {
            System.out.println("fileList is null, return");
            return;
        }
        for (EncryptFile fileUtil : fileList) {
            String fileName = fileUtil.getFileName();
            String keyName = fileUtil.getKeyName();
            String keyValue = fileUtil.getKeyValue();
            if (fileName.endsWith(".xml")) {
                String nodeValue = fileUtil.getNodeValue();
                UpdatePassword.updateServerXml(fileName, nodeValue, keyName, keyValue);
                continue;
            }
            if (fileName.endsWith(".properties")) {
                UpdatePassword.updateProperties(fileName, keyName, keyValue);
                continue;
            }
            UpdatePassword.encryptPassword(fileName, keyValue);
        }
    }
}

