/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.rollback;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.rollback.RollBackTaskManager;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.common.sdk.service.IRollBackExecutor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.Serializable;
import org.springframework.dao.DataAccessException;

public class RollBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(RollBackTask.class);
    private static Object lock = new Object();
    private IRollBackExecutor executor;
    private String taskId;

    public RollBackTask(IRollBackExecutor executor, String taskId, String targetName) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)targetName, (String)"ism.drm.pg.clear.vmresource", (String)"System", (String)"", null), true);
        this.executor = executor;
        this.taskId = taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        Object object = lock;
        synchronized (object) {
            this.lockRollBackTaskInfo();
        }
        RollBackTaskInfo task = (RollBackTaskInfo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(RollBackTaskInfo.class, (Serializable)((Object)this.taskId));
        if (null == task) {
            throw new LegoCheckedException(2117645L);
        }
        boolean result = false;
        try {
            result = this.executor.execute(task.getExecuteParam());
            if (!result) {
                throw new LegoCheckedException(-1L);
            }
        }
        catch (LegoCheckedException e) {
            AlarmReporter.sendAlarm(task.getAlarmId(), task.getSourceUuid(), task.getSourceType(), FaultEnum.AlarmSeverity.MAJOR, this.getAlarmParams(task.getAlarmParam()));
            logger.error((Object)"task execute over and result is failed.", (Throwable)e);
            task.setTaskStatus(Integer.valueOf(-1));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)task);
            throw e;
        }
        catch (Exception e) {
            AlarmReporter.sendAlarm(task.getAlarmId(), task.getSourceUuid(), task.getSourceType(), FaultEnum.AlarmSeverity.MAJOR, this.getAlarmParams(task.getAlarmParam()));
            task.setTaskStatus(Integer.valueOf(-1));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)task);
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to delete/update task(" + this.taskId + ") status."), (long)-1L, (String[])new String[0], (Log)logger);
        }
        if (result) {
            logger.debug((Object)"task execute over and result is success.");
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)task);
            AlarmReporter.restoreAlarm(task.getAlarmId(), this.taskId);
            RollBackTaskManager.getInstance().cancelTimer(this.taskId);
        }
    }

    private String[] getAlarmParams(String alarmParams) {
        if (VerifyUtil.isEmpty((String)alarmParams)) {
            return new String[]{this.taskId};
        }
        String[] taskAlarmParam = alarmParams.split(":");
        String[] result = new String[1 + taskAlarmParam.length];
        result[0] = this.taskId;
        System.arraycopy(taskAlarmParam, 0, result, 1, taskAlarmParam.length);
        return result;
    }

    private void lockRollBackTaskInfo() {
        RollBackTaskInfo task = (RollBackTaskInfo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(RollBackTaskInfo.class, (Serializable)((Object)this.taskId));
        if (null == task) {
            logger.error((Object)("task is not existed:" + this.taskId));
            throw new LegoCheckedException(2117645L);
        }
        if (2 == task.getTaskStatus()) {
            logger.error((Object)("task is already running:" + this.taskId));
            throw new LegoCheckedException(102401L);
        }
        task.setTaskStatus(Integer.valueOf(2));
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)task);
        }
        catch (DataAccessException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to update task(" + this.taskId + ") status."), (long)-1L, (String[])new String[0], (Log)logger);
        }
    }
}

