/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.ism.drm.base.util.DrmObjectInputStream;
import com.huawei.ism.drm.util.Base64;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutputStream;

public final class DrmObjectSerializableUtil {
    private static final Log log = LogFactory.getInstance(DrmObjectSerializableUtil.class);
    private static ClassLoader globalClassLoader;

    private DrmObjectSerializableUtil() {
    }

    public static ClassLoader getGlobalClassLoader() {
        return globalClassLoader;
    }

    public static synchronized void setGlobalClassLoader(ClassLoader globalClassLoaderParam) {
        if (null == globalClassLoader) {
            globalClassLoader = globalClassLoaderParam;
        }
    }

    public static String serializableObj(Object obj) {
        String string;
        ByteArrayOutputStream outputStream = null;
        ObjectOutputStream output = null;
        try {
            outputStream = new ByteArrayOutputStream();
            output = new ObjectOutputStream(outputStream);
            output.writeObject(obj);
            byte[] bufs = outputStream.toByteArray();
            string = Base64.byteArrayToBase64((byte[])bufs);
        }
        catch (IOException e) {
            try {
                log.error((Object)("serializable object class:" + obj.getClass() + " is error."), 90160758787071L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                CommonUtil.close(output);
                CommonUtil.close((Closeable)outputStream);
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)output);
        CommonUtil.close((Closeable)outputStream);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T reverseeObj(String content, Class<T> classs) {
        Object object;
        ByteArrayInputStream inputStream = null;
        DrmObjectInputStream input = null;
        try {
            inputStream = new ByteArrayInputStream(Base64.base64ToByteArray((String)content));
            input = new DrmObjectInputStream(inputStream, globalClassLoader);
            object = input.readObject();
        }
        catch (IOException e) {
            try {
                log.error((Object)("reversee serializable is error.class:" + classs), 90160758787071L);
                throw new LegoCheckedException(-1L, (Throwable)e);
                catch (ClassNotFoundException e2) {
                    log.error((Object)("reversee serializable is error.class:" + classs), 90160758787071L);
                    throw new LegoCheckedException(-1L, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(input);
                CommonUtil.close((Closeable)inputStream);
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)input);
        CommonUtil.close((Closeable)inputStream);
        return (T)object;
    }
}

