/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.component;

import com.huawei.ism.drm.cert.NodeAgentCommand;
import com.huawei.ism.drm.cert.component.ComponentCertificateService;
import com.huawei.ism.drm.cert.sdk.service.command.CommandReaction;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import com.huawei.nodeagent.thrift.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DependedCertificateService
extends ComponentCertificateService {
    private static final String SPLIT = "-";
    private String keyStoreFileName;
    private String keyStorePriField;
    private NodeAgentCommand certificateQueryCommand;

    public DependedCertificateService(String keyStoreFileName, String keyStorePriField, List<String> certs, String operateCommand, String rollbackCommand) {
        super(certs, operateCommand, rollbackCommand);
        this.keyStoreFileName = keyStoreFileName;
        this.keyStorePriField = keyStorePriField;
    }

    public void initialize() {
    }

    public void setCertificateQueryCommand(NodeAgentCommand certificateQueryCommand) {
        this.certificateQueryCommand = certificateQueryCommand;
    }

    @Override
    protected Map<String, String> getBuiltinOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        String password = LegoConfig.getInstance().getKeyValue(this.keyStorePriField);
        options.put("keystore-filename", this.keyStoreFileName);
        options.put("keystore-password", WccEncryptor.decrypt((String)password));
        return options;
    }

    @Override
    public void setNodeAgentLocalService(NodeAgentLocalService.Iface nodeAgentLocalService) {
        super.setNodeAgentLocalService(nodeAgentLocalService);
        this.certificateQueryCommand.setNodeAgentLocalService(nodeAgentLocalService);
    }

    @Override
    public CommandReaction<Map<Node, Response>> operateCertificate(List<Node> nodes, Parameter ... params) {
        ArrayList<String> successAlias = new ArrayList<String>();
        Parameter param = Parameter.combine((Parameter[])params);
        String certName = (String)param.getOpts().get("cert-name");
        String timeStamp = (String)param.getOpts().get("timestamp");
        for (int i = 0; i < param.getArgs().size(); ++i) {
            String commandAlias = certName + SPLIT + timeStamp + SPLIT + i;
            param.getOpts().put("cert-name", commandAlias);
            String arg = (String)param.getArgs().get(i);
            CommandReaction<Map<Node, Response>> commandReaction = super.operateCertificate(nodes, new Parameter(param.getOpts(), Collections.singletonList(arg)));
            if (commandReaction.success()) {
                commandReaction.getContext().put("successAlias", successAlias);
                return commandReaction;
            }
            successAlias.add(commandAlias);
        }
        CommandReaction successResult = CommandReaction.genSuccessNodeResponses(nodes);
        successResult.getContext().put("successAlias", successAlias);
        Parameter confirmParameter = new Parameter(Collections.singletonMap("cert-name", certName));
        confirmParameter.getOpts().put("resultMap", JSONObject.fromObject((Object)successResult.getContext()).toString());
        CommandReaction<Map<Node, Response>> commandReaction = this.confirmCertificate(nodes, confirmParameter);
        if (commandReaction.failed()) {
            commandReaction.getContext().put("successAlias", successAlias);
            return commandReaction;
        }
        return successResult;
    }

    @Override
    public CommandReaction<Map<Node, Response>> rollbackCertificate(List<Node> nodes, Parameter ... params) {
        Parameter param = Parameter.combine((Parameter[])params);
        List successAlias = new ArrayList();
        JSONObject jObj = JSONObject.fromObject(param.getOpts().get("resultMap"));
        if (jObj.containsKey((Object)"successAlias")) {
            successAlias = JSONArray.toCollection((JSONArray)jObj.getJSONArray("successAlias"), String.class);
        }
        for (String commandAlias : successAlias) {
            param.getOpts().put("cert-name", commandAlias);
            CommandReaction<Map<Node, Response>> commandReaction = super.rollbackCertificate(nodes, new Parameter(param.getOpts(), Collections.emptyList()));
            if (!commandReaction.failed()) continue;
            return commandReaction;
        }
        return CommandReaction.genSuccessNodeResponses(nodes);
    }

    public CommandReaction<Map<Node, Response>> confirmCertificate(List<Node> nodes, Parameter ... params) {
        Parameter param = Parameter.combine((Parameter[])params);
        CommandReaction<Map<Node, Response>> queryResult = this.executeCommand(this.certificateQueryCommand, nodes, params);
        if (!queryResult.success()) {
            return queryResult;
        }
        Set<String> currentAlias = this.getCurrentCertAliases(queryResult);
        HashSet<String> successAlias = new HashSet<String>();
        JSONObject jObj = JSONObject.fromObject(param.getOpts().get("resultMap"));
        if (jObj.containsKey((Object)"successAlias")) {
            List tempList = JSONArray.toCollection((JSONArray)jObj.getJSONArray("successAlias"), String.class);
            for (String alias2 : tempList) {
                successAlias.add(alias2.toLowerCase(Locale.getDefault()));
            }
        }
        currentAlias.removeAll(successAlias);
        HashSet timeStampSet = new HashSet();
        currentAlias.forEach(alias -> {
            String[] strs;
            if (alias.contains(SPLIT) && (strs = alias.split(SPLIT)).length >= 3) {
                String stamp = strs[strs.length - 2];
                timeStampSet.add(stamp);
            }
        });
        ArrayList timeStampList = new ArrayList(timeStampSet);
        Collections.sort(timeStampList);
        HashSet deleteTimeStampSet = new HashSet();
        int maxKeepSize = (int)LegoConfig.getInstance().getNumber("CERT_RESERVE_NUMBER", 99L);
        if (timeStampList.size() > maxKeepSize) {
            deleteTimeStampSet.addAll(timeStampList.subList(0, timeStampList.size() - maxKeepSize));
        }
        for (String alias3 : currentAlias) {
            boolean canDelete = false;
            for (String deleteStamp : deleteTimeStampSet) {
                if (!alias3.contains(deleteStamp)) continue;
                canDelete = true;
                break;
            }
            if (!canDelete) continue;
            param.getOpts().put("cert-name", alias3);
            CommandReaction<Map<Node, Response>> result = super.rollbackCertificate(nodes, new Parameter(param.getOpts(), Collections.emptyList()));
            if (result.success()) continue;
            return result;
        }
        return CommandReaction.genSuccessNodeResponses(nodes);
    }

    private Set<String> getCurrentCertAliases(CommandReaction<Map<Node, Response>> queryResult) {
        HashSet<String> currentAlias = new HashSet<String>();
        for (Response response : ((Map)queryResult.getResult()).values()) {
            String[] strs;
            if (VerifyUtil.isEmpty((String)response.getDetails())) continue;
            for (String str : strs = response.getDetails().split(",")) {
                if (VerifyUtil.isEmpty((String)str)) continue;
                currentAlias.add(str);
            }
        }
        return currentAlias;
    }
}

