/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.cdm.usedata.sdk.service.IUseCopyDataService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.backup.service.INovaServerService;
import com.huawei.ism.drm.base.service.AbstractProtectionRecoveryService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmObjectSerializableUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanCreateEventHandler;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public abstract class AbstractRecoveryPlanService
extends AbstractProtectionRecoveryService
implements IRecoveryPlanService {
    private static Log logger = LogFactory.getInstance(AbstractRecoveryPlanService.class);
    private static final long MAX_RECOVERY_PLAN_NUM = 2000L;
    private static final Object RECOVERY_PLAN_LOCK = new Object();
    private IBizScopeManager bizScopeManager;
    private List<IRecoveryPlanCreateEventHandler> recoveryPlanCreateEventHandlers = new ArrayList<IRecoveryPlanCreateEventHandler>();

    public IBizScopeManager getBizScopeManager() {
        return this.bizScopeManager;
    }

    public void setBizScopeManager(IBizScopeManager bizScopeManager) {
        this.bizScopeManager = bizScopeManager;
    }

    public void addRecoveryPlanCreateEventHandler(IRecoveryPlanCreateEventHandler handler, Map<String, Object> props) {
        if (handler != null && !this.recoveryPlanCreateEventHandlers.contains(handler)) {
            this.recoveryPlanCreateEventHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCreateRecoveryPlan(long userID, RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            logger.error((Object)"The parameter recoveryPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            this.createRecoveryPlan(userID, recoveryPlan, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncModifyRecoveryPlan(RecoveryPlan recoveryPlan) {
        RecoveryPlan localInfo = this.getRecoveryPlan(recoveryPlan.getPlanId());
        if (null == localInfo) {
            logger.debug((Object)"localInfo null,not syncModifyRecoveryPlan");
            return;
        }
        localInfo.setDescription(recoveryPlan.getDescription());
        localInfo.setName(recoveryPlan.getName());
        Session session = null;
        try {
            session = this.getHibernateSession();
            session.beginTransaction();
            session.saveOrUpdate((Object)localInfo);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Exception)e, (String)"Hibernate execute failed", (long)0x300001L, (String[])new String[0]);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncUpdateRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E> poRecoveryStatusMap) {
        RecoveryPlan localInfo = this.getRecoveryPlan(recoveryPlan.getPlanId());
        if (null == localInfo) {
            return;
        }
        localInfo.setLastExecuteType(recoveryPlan.getLastExecuteType());
        localInfo.setPlanStatus(recoveryPlan.getPlanStatus());
        localInfo.setProcessStatus(recoveryPlan.getProcessStatus());
        localInfo.setPlanProgress(recoveryPlan.getPlanProgress());
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() == localInfo.getLastExecuteType()) {
            localInfo.setLastTestStatus(recoveryPlan.getLastTestStatus());
            String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
            localInfo.getGlobalSettings().put(disasterSiteId + "_TestResult", String.valueOf(recoveryPlan.getPlanStatus()));
            String hostOrGroupId = RecoveryServiceUtil.getDisasterHostSN(recoveryPlan);
            if (!VerifyUtil.isEmpty((String)hostOrGroupId)) {
                localInfo.getGlobalSettings().put(hostOrGroupId + "_TestResult", String.valueOf(recoveryPlan.getPlanStatus()));
            }
        }
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            session.saveOrUpdate((Object)localInfo);
            this.updatePoRecoveryStatus((Set<ProtectGroup>)localInfo.getProtectGroups(), poRecoveryStatusMap, session);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Exception)e, (String)"Hibernate execute failed", (long)0x300001L, (String[])new String[0]);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    public void syncRemoveRecoveryPlan(String recoveryPlanId) {
        block3: {
            if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
                logger.error((Object)"Invalid parameter", 90160758784001L);
                throw new LegoCheckedException(1073947393L);
            }
            try {
                this.deleteRecoveryPlan(recoveryPlanId, false);
            }
            catch (LegoCheckedException e) {
                if (201L == e.getErrorCode() || 1073947394L == e.getErrorCode()) break block3;
                throw e;
            }
        }
        this.bizScopeManager.deleteScopeObject(recoveryPlanId);
    }

    public void syncRecoveryLogs(List<RecoveryLog> recoveryLogs) {
        if (VerifyUtil.isEmpty(recoveryLogs)) {
            logger.trace((Object)"param is null");
            return;
        }
        this.saveOrUpdateRecoveryLogs(recoveryLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRecoveryPlan(long userID, RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            logger.error((Object)"The parameter recoveryPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String planId = UUIDGenerator.getUUID();
        recoveryPlan.setPlanStatus(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY.getValue());
        recoveryPlan.setPlanId(planId);
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            return this.createRecoveryPlan(userID, recoveryPlan, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createMultiRecoveryPlan(long userID, RecoveryPlan recoveryPlan) {
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            String planId = UUIDGenerator.getUUID();
            recoveryPlan.setPlanStatus(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY.getValue());
            recoveryPlan.setPlanId(planId);
            return this.createRecoveryPlan(userID, recoveryPlan, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRpBasicInfo(String planId, Integer planUse, String planName, String planDesc) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)planName)) {
            logger.error((Object)("The parameter is null. PlanId:" + planId + ",PlanName:" + planName), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            RecoveryPlan recoveryPlan;
            if (this.isExistedRecoveryPlanByName(planName, planId, planUse)) {
                logger.error((Object)("The plan name already exists. PlanName:" + planName + ",PlanId:" + planId), 90160758784001L);
                throw new LegoCheckedException(1073947392L);
            }
            if (this.isExistedRecoveryPlanById(planId)) {
                recoveryPlan = this.getRecoveryPlan(planId);
                if (null == recoveryPlan) {
                    logger.error((Object)("The recovery plan does not exist. PlanId:" + planId), 90160758784001L);
                    throw new LegoCheckedException(1073947394L);
                }
                RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO);
                recoveryPlan.setName(planName);
                recoveryPlan.setDescription(planDesc);
                List<Site> remoteSites = RecoveryServiceUtil.getRemoteSites(recoveryPlan);
                if (DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE.getValue() == recoveryPlan.getPlanType()) {
                    recoveryPlan.setRecoveryProcesses(null);
                    this.syncCRDOperationToRemote(remoteSites, (Object)recoveryPlan, "/ws/recoveryplans/syncModifyRecoveryPlan");
                }
            } else {
                logger.error((Object)("The recovery plan does not exist. PlanId:" + planId + ",PlanName:" + planName), 90160758784001L);
                throw new LegoCheckedException(201L);
            }
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
        }
    }

    public void saveOrUpdateGlobalSettings(String planId, Map<String, Object> globalSettings) {
        if (VerifyUtil.isEmpty((String)planId) || null == globalSettings) {
            throw new LegoCheckedException(-1L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        this.saveOrUpdateGlobalSettings(recoveryPlan, globalSettings);
    }

    public void saveOrUpdateRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (!this.checkRecoverySettings(planId, settings)) {
            throw new LegoCheckedException(-1L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            logger.error((Object)"IRecoveryProcessProvider is null!");
            throw new LegoCheckedException(1073947393L);
        }
        provider.checkRecoverySettings(settings);
        RecoveryServiceUtil.checkRecoveryOperationPrivilegeBySite(recoveryPlan, null);
        this.saveOrUpdateRecoverySettings(recoveryPlan, settings);
        List<Site> remoteSites = RecoveryServiceUtil.getRemoteSites(recoveryPlan);
        if (VerifyUtil.isEmpty(remoteSites)) {
            return;
        }
        Iterator<Site> iterator = remoteSites.iterator();
        if (iterator.hasNext()) {
            try {
                this.syncRecoverySettingsToRemote(iterator.next(), planId, settings);
            }
            catch (Exception e) {
                logger.error((Object)("Sync recovery settings to remote failed. PlanId:" + planId), 90160758784001L);
            }
        }
    }

    public void syncSaveOrUpdateRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (!this.checkRecoverySettings(planId, settings)) {
            throw new LegoCheckedException(-1L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        IRecoveryProcessProvider procProvider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        RecoveryPlan tempPlan = new RecoveryPlan();
        tempPlan.setRecoverySettings(new HashSet<RecoverySetting>(settings));
        if (procProvider == null) {
            logger.error((Object)"procProvider is null!");
            throw new LegoCheckedException(1073947393L);
        }
        procProvider.encryptProperties(tempPlan);
        this.saveOrUpdateRecoverySettings(recoveryPlan, settings);
    }

    public void syncGlobalSettingsToRemote(Site remoteSite, String planId, Map<String, Object> globalSettings) {
        HashMap<String, Object> requestInfos = new HashMap<String, Object>();
        requestInfos.put("planId", planId);
        requestInfos.put("settings", globalSettings);
        logger.trace((Object)("planId: " + planId));
        this.syncCRDOperationToRemote(remoteSite, requestInfos, "/ws/recoveryplans/syncGlobalSettings");
    }

    public void syncRecoverySettingsToRemote(Site remoteSite, String planId, List<RecoverySetting> settings) {
        HashSet<RecoverySetting> cloneSettings = new HashSet<RecoverySetting>();
        try {
            for (RecoverySetting setting : settings) {
                cloneSettings.add((RecoverySetting)setting.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (cloneSettings.isEmpty()) {
            return;
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        IRecoveryProcessProvider procProvider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        recoveryPlan.setRecoverySettings(cloneSettings);
        procProvider.decryptPropreties(recoveryPlan);
        HashMap<String, Object> requestInfos = new HashMap<String, Object>();
        requestInfos.put("planId", planId);
        requestInfos.put("settings", new ArrayList(cloneSettings));
        this.syncCRDOperationToRemote(remoteSite, requestInfos, "/ws/recoveryplans/syncRecoverySettings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecoveryPlan(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        logger.info((Object)"begin to delete recovery plan %s.", new Object[]{recoveryPlanId});
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            this.deleteRecoveryPlan(recoveryPlanId, true);
        }
        this.bizScopeManager.deleteScopeObject(recoveryPlanId);
        logger.info((Object)"delete recovery plan %s success.", new Object[]{recoveryPlanId});
    }

    public List<RecoveryPlan> getAllRecoveryPlan() {
        ArrayList<RecoveryPlan> recoveryPlans = new ArrayList();
        try {
            recoveryPlans = this.getBaseDao().getHibernateTemplate().find("from RecoveryPlan", new Object[0]);
            return recoveryPlans;
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery plans failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return recoveryPlans;
        }
    }

    public List<RecoveryPlan> getAllRecoveryPlan(long userID) {
        logger.trace((Object)"getAllRecoveryPlan");
        List recoveryPlans = this.getAllRecoveryPlan();
        if (!VerifyUtil.isEmpty(recoveryPlans)) {
            recoveryPlans = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(Long.valueOf(userID), recoveryPlans);
        }
        return recoveryPlans;
    }

    public boolean isUsedProtectGroupByRp(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(pgId, false);
        if (null == protectGroup) {
            logger.error((Object)("ProtectGroup(" + pgId + ") not exist"));
            throw new LegoCheckedException(1073947394L);
        }
        String planId = this.getAssociatedRecoveryPlanWithProtectGroup(protectGroup.getUuid());
        return !VerifyUtil.isEmpty((String)planId);
    }

    public boolean isUsedProtectGroupByAllRp(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            String errMsg = "pgId is empty.[{0}]";
            logger.error((Object)MessageFormatUtil.format((String)errMsg, (Object[])new Object[]{pgId}));
            throw new LegoCheckedException(1073947393L, new String[]{pgId});
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(pgId, false);
        if (null == protectGroup) {
            String errMsg = "ProtectGroup is not exist.[{0}]";
            logger.error((Object)MessageFormatUtil.format((String)errMsg, (Object[])new Object[]{pgId}));
            throw new LegoCheckedException(1073947394L, new String[]{pgId});
        }
        List<String> list = this.getAssociatedRecoveryPlanListWithProtectGroup(protectGroup.getUuid(), new ArrayList<Integer>());
        return !VerifyUtil.isEmpty(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecoverySetting> getRecoverySettings(String planId, String itemKey) {
        ArrayList<RecoverySetting> settings = new ArrayList<RecoverySetting>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHQL = "from RecoverySetting RS where RS.recoveryPlan.planId=:planId and RS.name=:itemKey";
            Query query = session.createQuery(queryHQL);
            query.setString("planId", planId);
            query.setString("itemKey", itemKey);
            List results = query.list();
            if (null != results && !results.isEmpty()) {
                for (Object result : results) {
                    settings.add((RecoverySetting)result);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Querying recovery settings failed. Id:" + planId + ",key:" + itemKey + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoverySetting getRecoverySetting(String planId, String ownerId, String itemKey) {
        RecoverySetting recoverySetting = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHQL = "from RecoverySetting RS where RS.recoveryPlan.planId=:planId and RS.ownerId=:ownerId and RS.name=:itemKey";
            Query query = session.createQuery(queryHQL);
            query.setString("planId", planId);
            query.setString("ownerId", ownerId);
            query.setString("itemKey", itemKey);
            List results = query.list();
            if (null != results && 1 == results.size()) {
                recoverySetting = (RecoverySetting)results.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Querying recovery settings failed. Id:" + planId + ",key:" + itemKey + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoverySetting;
    }

    public <T> T queryDataFromRemote(Site remoteSite, Object requestParamsMsg, String serviceUrl, Class<T> responseDataType) {
        logger.trace((Object)"queryDataFromRemote");
        RestClient client = SiteUtil.initClient(remoteSite);
        Object result = client.postSerializableObj(requestParamsMsg, serviceUrl, responseDataType);
        return (T)result;
    }

    public void syncCRDOperationToRemote(Site remoteSite, Object requestParamsMsg, String serviceUrl) {
        logger.trace((Object)"syncCRDOperationToRemote");
        RestClient client = SiteUtil.initClient(remoteSite);
        client.postSerializableObj(requestParamsMsg, serviceUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RecoveryProcessDefinition> getRecoveryProcesses(String recoveryPlanId, int procType) {
        Set<RecoveryProcessDefinition> processes;
        Session session = null;
        try {
            session = this.getHibernateSession();
            processes = this.getRecoveryProcesses(recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)procType), session);
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery process failed. PlanId:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            processes = new HashSet<RecoveryProcessDefinition>();
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return processes;
    }

    public List<RecoveryProcessor> getRecoveryProcessors(String planId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        RecoveryProcessDefinition rpDefinition;
        if (VerifyUtil.isEmpty((String)planId) || null == procType) {
            throw new LegoCheckedException(1073947393L);
        }
        Set<RecoveryProcessDefinition> rpDefinitions = this.getRecoveryProcesses(planId, procType.getValue());
        if (VerifyUtil.isEmpty(rpDefinitions)) {
            IRecoveryManager recoveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
            RecoveryPlan plan = this.getRecoveryPlanWithProcess(planId);
            rpDefinition = recoveryManager.createRecoveryProcessDefinition(plan, procType);
        } else {
            Iterator<RecoveryProcessDefinition> iterator = rpDefinitions.iterator();
            if (!iterator.hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            rpDefinition = iterator.next();
        }
        if (null == rpDefinition) {
            logger.error((Object)"The process definition does not exist.", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        List<RecoveryProcessor> sortedProcessors = RecoveryServiceUtil.sortRecoveryProcessors(rpDefinition.getRecoveryProcessors());
        ArrayList<RecoveryProcessor> processors = new ArrayList<RecoveryProcessor>();
        for (RecoveryProcessor processor : sortedProcessors) {
            RecoveryProcessor newProcessor = new RecoveryProcessor();
            newProcessor.setPlanId(processor.getPlanId());
            newProcessor.setProcId(processor.getProcId());
            newProcessor.setProcType(processor.getProcType());
            newProcessor.setIsEditable(processor.getIsEditable());
            newProcessor.setIsEnabled(processor.getIsEnabled());
            newProcessor.setIsPreset(processor.getIsPreset());
            processor.updateProcessName();
            processor.updateDescription();
            newProcessor.setProcName(processor.getProcName());
            newProcessor.setDescription(processor.getDescription());
            newProcessor.setProcessId(processor.getProcessId());
            Map props = processor.getProps();
            if (!processor.getIsPreset().booleanValue()) {
                JSONObject executeParams = JSONObject.fromObject(props.get("STEP_PARAMS"));
                Map data = newProcessor.getProps();
                String isUserDefined = (String)props.get("isUserDefined");
                if ("false".equals(isUserDefined)) {
                    IHostScriptSchemeService schemeService = (IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class);
                    String schemeId = (String)props.get("recoveryScriptSchemeId");
                    Map paramValidation = schemeService.getParamValidation(schemeId);
                    String stepParamsStr = ScriptParamsUtils.filterSensitiveParam((Map)paramValidation, (String)executeParams.toString());
                    data.put("STEP_PARAMS", stepParamsStr);
                    data.put("recoveryScriptSchemeId", props.get("recoveryScriptSchemeId"));
                } else {
                    data.put("STEP_PARAMS", executeParams.toString());
                }
                data.put("isUserDefined", isUserDefined);
                data.put("position", props.get("position"));
                data.put("EXECUTE_POLICY", props.get("EXECUTE_POLICY"));
            }
            processors.add(newProcessor);
        }
        return processors;
    }

    public void createMountPlan(User user, MountConfiguration mountPlan) {
        logger.trace((Object)"begin to createMountPlan.");
        if (null == mountPlan) {
            logger.error((Object)"The parameter mountPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkMountPlan(mountPlan);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        String mountConfigs = JSONObject.fromObject((Object)mountPlan).toString();
        replicaService.mountReplica(user, mountPlan.getProtectGroupId(), mountPlan.getReplicaId(), mountConfigs);
    }

    public void modifyMountplan(User user, RecoveryPlan mountPlan, MountConfiguration configuration) {
        logger.trace((Object)"begin to modifyMountplan.");
        if (VerifyUtil.isEmpty((Object)mountPlan) || VerifyUtil.isEmpty((Object)configuration)) {
            logger.error((Object)"The parameter mountPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String startTime = configuration.getStartTime() == null ? "" : configuration.getStartTime();
        String description = configuration.getDescription();
        String name = configuration.getName();
        String replicaId = this.getReplicaIdByPlanId(mountPlan);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        String mountConfigs = this.getMountConfigByReplicaId(replica);
        MountConfiguration mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        IUseCopyDataService service = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        if (VerifyUtil.isEmpty((String)startTime)) {
            this.execMountPlanManual(user, mountPlan);
        } else {
            Date startDate = null;
            try {
                SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                startDate = sDateFormat.parse(startTime, new ParsePosition(0));
            }
            catch (Exception e) {
                String errorMsg = "parse start time got error,startTime cannot  from \"yyyy-MM-dd HH:mm:ss\". startTime:" + startTime;
                ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
            }
            Date currentDate = new Date();
            if (currentDate.getTime() >= startDate.getTime()) {
                logger.error((Object)"Execution time %s is less than current time.", new Object[]{startTime});
                throw new LegoCheckedException(1073948456L);
            }
            String newTime = String.valueOf(startDate.getTime());
            service.updateTask(mountPlan, newTime);
        }
        mountConfiguration.setStartTime(startTime);
        mountPlan.setName(name);
        mountConfiguration.setName(name);
        mountPlan.setDescription(description);
        mountConfiguration.setDescription(description);
        this.getBaseDao().getTransactionTemplate().execute(status -> {
            ProtectGroupReplica newReplica = replicaService.queryProtectGroupReplicaById(replicaId);
            if (VerifyUtil.isEmpty((Object)newReplica)) {
                logger.error((Object)"replica dose not exists. replicaId:[%s]", new Object[]{replicaId});
                throw new LegoCheckedException(2117645L);
            }
            String newConfig = JSONObject.fromObject((Object)mountConfiguration).toString();
            newReplica.addProperty("mountConfigs", newConfig);
            replicaService.saveOrUpdateReplica(newReplica);
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)mountPlan);
            return null;
        });
    }

    public String getHostName(String hostId, Site site, ProtectGroup pg) {
        String hostName = "--";
        if (10 == pg.getPoType()) {
            HashMap<String, String> querys = new HashMap<String, String>();
            querys.put("uuid", hostId);
            List moLists = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).queryMoList(ManagedObject.class, querys);
            if (!VerifyUtil.isEmpty((Collection)moLists)) {
                ManagedObject mo = (ManagedObject)moLists.get(0);
                hostName = mo.getName();
            }
            return hostName;
        }
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostId);
        if (null != drResource) {
            return drResource.getName();
        }
        DrResource cloudServer = (DrResource)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(DrResource.class, (Serializable)((Object)hostId));
        if (!VerifyUtil.isEmpty((Object)cloudServer)) {
            return cloudServer.getName();
        }
        if (!VerifyUtil.isEmpty((Object)site) && site.getIsCloudSite().booleanValue()) {
            INovaServerService novaSevice = (INovaServerService)ServiceLocator.getInstance().getService(INovaServerService.class);
            if (VerifyUtil.isEmpty((Object)novaSevice)) {
                logger.warn((Object)"Can not get Nova service.");
                return hostName;
            }
            Map server = novaSevice.getNovaServer(site.getSiteId(), hostId);
            if (null != server) {
                return server.get("name").toString();
            }
            logger.warn((Object)"Can not get Nova(%s) server.", new Object[]{1073947393L, hostId});
        }
        return hostName;
    }

    public void execMountPlanManual(User user, RecoveryPlan mountPlan) {
        logger.trace((Object)"begin to execMountPlanManual.");
        if (null == mountPlan) {
            logger.error((Object)"The parameter mountPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String replicaId = this.getReplicaIdByPlanId(mountPlan);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        if (VerifyUtil.isEmpty((Object)replica)) {
            logger.error((Object)("can not get replica with replica id " + replicaId + "."));
            throw new LegoCheckedException(2117645L);
        }
        if (1 != replica.getStatus()) {
            logger.error((Object)"Replica is not valid: %s, status=%s.", new Object[]{replica.getId(), String.valueOf(replica.getStatus())});
            throw new LegoCheckedException(1073948459L);
        }
        ReplicaFactoryManager manager = ReplicaFactoryManager.getInstance();
        IReplicaFactory factory = manager.getReplicaFactory(replica.getType());
        if (!factory.validReplica(replica, true)) {
            logger.error((Object)("Replica is not valid: " + replica.getId()));
            throw new LegoCheckedException(1073948459L);
        }
        String mountConfigs = this.getMountConfigByReplicaId(replica);
        MountConfiguration mountCnf = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        String hostSn = mountCnf.getHostOrGroupSn();
        mountCnf.getExtParameters().put("REPLICA_ID", replicaId);
        mountCnf.getExtParameters().put("PG_DISASTER_HOST", hostSn);
        mountCnf.getExtParameters().put("disasterHostSn", hostSn);
        IUseCopyDataService useCopyService = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        useCopyService.mountReplica(mountPlan.getPlanId(), replicaId, mountCnf, user);
        IUseCopyDataService service = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        service.updateTask(mountPlan, null);
        mountCnf.setStartTime(null);
        ProtectGroupReplica newReplica = replicaService.queryProtectGroupReplicaById(replicaId);
        String newConfig = JSONObject.fromObject((Object)mountCnf).toString();
        newReplica.addProperty("mountConfigs", newConfig);
        replicaService.saveOrUpdateReplica(newReplica);
    }

    public void clearMountPlanManual(User user, RecoveryPlan mountPlan, boolean bDeleteReplica) {
        logger.trace((Object)"begin to clearMountPlanManual.");
        if (null == mountPlan) {
            logger.error((Object)"The parameter mountPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String replicaId = this.getReplicaIdByPlanId(mountPlan);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        replicaService.unmountReplica(user, mountPlan.getProtectGroup().getUuid(), replicaId, bDeleteReplica);
    }

    private String getReplicaIdByPlanId(RecoveryPlan mountPlan) {
        String replicaId = (String)mountPlan.getGlobalSettings().get("REPLICA_ID");
        if (VerifyUtil.isEmpty((String)replicaId)) {
            logger.error((Object)("mountPlan " + mountPlan.getPlanId() + "have no replica, can not mount replica!"));
            throw new LegoCheckedException(1073947393L);
        }
        return replicaId;
    }

    private String getMountConfigByReplicaId(ProtectGroupReplica replica) {
        String mountConfigs = replica.getProperty("mountConfigs");
        if (VerifyUtil.isEmpty((String)mountConfigs)) {
            logger.error((Object)("replica id " + replica.getId() + " can not get mountConfiguration."));
            throw new LegoCheckedException(2117645L);
        }
        return mountConfigs;
    }

    private void validAndDecryptPwd(Map<String, Object> params, Map<String, Object> paramsInfos) {
        if (VerifyUtil.isEmpty(params)) {
            return;
        }
        JSONObject jsonParams = JSONObject.fromObject(params);
        for (Object key : jsonParams.keySet()) {
            String value;
            JSONObject jsonObject;
            String keyStr = (String)key;
            if (!paramsInfos.containsKey(keyStr) || !"true".equals((jsonObject = JSONObject.fromObject((Object)paramsInfos.get(keyStr))).get("sensitive")) || VerifyUtil.isEmpty((String)(value = (String)jsonParams.get(keyStr)))) continue;
            String encryptPwd = WccEncryptor.decrypt((String)value);
            jsonParams.put(key, (Object)encryptPwd);
        }
    }

    public String getAssociatedRecoveryPlanWithProtectGroup(String protectGroupId) {
        ArrayList<Integer> planUseNotIn = new ArrayList<Integer>();
        planUseNotIn.add(RecoveryPlanUse.INTERNAL_USE.getValue());
        List<String> planIds = this.getAssociatedRecoveryPlanListWithProtectGroup(protectGroupId, planUseNotIn);
        if (VerifyUtil.isEmpty(planIds)) {
            return null;
        }
        return planIds.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAssociatedRecoveryPlanListWithProtectGroup(String protectGroupId, List<Integer> planUseNotIn) {
        Session session = null;
        try {
            List planIds;
            session = this.getHibernateSession();
            String querySQL = "select PLANID from ti_drp_r_pg where PGID=:pgId";
            if (!VerifyUtil.isEmpty(planUseNotIn)) {
                querySQL = "select r.PLANID from ti_drp_r_pg r left join ti_recoveryplan l  on r.PLANID = l.PLANID where r.PGID=:pgId";
                StringBuilder sb = new StringBuilder();
                sb.append(" and l.PLANUSE not in(");
                for (int i = 0; i < planUseNotIn.size(); ++i) {
                    sb.append(planUseNotIn.get(i));
                    if (i >= planUseNotIn.size() - 1) continue;
                    sb.append(", ");
                }
                sb.append(") ");
                querySQL = querySQL + sb.toString();
            }
            NativeQuery query = session.createSQLQuery(querySQL);
            query.setString("pgId", protectGroupId);
            List list = planIds = query.list();
            return list;
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery plan associated with pg failed. PgId:" + protectGroupId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return null;
    }

    public void setPoRepToRecoveryPlan(RecoveryPlan recoveryPlan) {
        logger.trace((Object)"setPoRepToRecoveryPlan");
        Set pgSet = recoveryPlan.getProtectGroups();
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        for (ProtectGroup pg : pgSet) {
            List queryProtectGroupReplicaByGroup = replicaService.queryProtectGroupReplicaByGroup(pg.getUuid(), "", true, null);
            pg.getReplicaList().clear();
            pg.getReplicaList().addAll(queryProtectGroupReplicaByGroup);
        }
    }

    protected void syncCRDOperationToRemote(List<Site> remoteSites, Object requestParamsMsg, String serviceUrl) {
        if (VerifyUtil.isEmpty(remoteSites)) {
            return;
        }
        Iterator<Site> iterator = remoteSites.iterator();
        if (iterator.hasNext()) {
            Site remoteSite = iterator.next();
            RestClient client = SiteUtil.initClient(remoteSite);
            client.postSerializableObj(requestParamsMsg, serviceUrl);
        }
    }

    protected Session getHibernateSession() {
        HibernateTemplate template = this.getBaseDao().getHibernateTemplate();
        Session session = template.getSessionFactory().openSession();
        return session;
    }

    protected boolean isNotZeroCountQueryResult(List<?> countQueryResult) {
        BigInteger count;
        Object obj;
        return null != countQueryResult && !countQueryResult.isEmpty() && (obj = countQueryResult.get(0)) instanceof BigInteger && 0 != (count = (BigInteger)obj).intValue();
    }

    protected void updatePoRecoveryStatus(Set<ProtectGroup> protectGroups, Map<String, DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E> poRecoveryStatusMap, Session session) {
        if (VerifyUtil.isEmpty(protectGroups) || VerifyUtil.isEmpty(poRecoveryStatusMap) || null == session) {
            logger.debug((Object)"not need updatePoRecoveryStatus exit null param.");
            return;
        }
        String updateSQL = "UPDATE ti_protectobject SET PORECOVERYSTATUS=:poRecoveryStatus where POID in (:poIds)";
        HashMap<Integer, ArrayList<String>> groups = new HashMap<Integer, ArrayList<String>>();
        for (ProtectGroup protectGroup : protectGroups) {
            for (ProtectObject protectObject : protectGroup.getPolist()) {
                DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E poRecoveryStatus = poRecoveryStatusMap.get(protectObject.getUuid());
                if (null == poRecoveryStatus) continue;
                ArrayList<String> group = (ArrayList<String>)groups.get(poRecoveryStatus.getValue());
                if (null == group) {
                    group = new ArrayList<String>();
                    groups.put(poRecoveryStatus.getValue(), group);
                }
                group.add(protectObject.getUuid());
            }
        }
        for (Map.Entry next : groups.entrySet()) {
            Integer poRecoveryStatus = (Integer)next.getKey();
            List poIds = (List)next.getValue();
            NativeQuery query = session.createSQLQuery(updateSQL);
            query.setInteger("poRecoveryStatus", poRecoveryStatus.intValue());
            query.setParameterList("poIds", (Collection)poIds);
            query.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveOrUpdateRecoveryLogs(List<RecoveryLog> recoveryLogs) {
        Session session = null;
        try {
            HibernateTemplate template = this.getBaseDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            session.beginTransaction();
            for (RecoveryLog recoveryLog : recoveryLogs) {
                recoveryLog.setIsSynchronized(Boolean.valueOf(true));
                session.saveOrUpdate((Object)recoveryLog);
                for (RecoveryProcessorDetail detail : recoveryLog.getRecoveryProcessDetails()) {
                    session.saveOrUpdate((Object)detail);
                }
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Exception)e, (String)"Hibernate execute failed", (long)0x300001L, (String[])new String[0]);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    protected Set<RecoveryProcessDefinition> getRecoveryProcesses(String planId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, Session session) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId, false, false);
        if (null == recoveryPlan) {
            logger.error((Object)("The recovery plan does not exist.PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        return this.getRecoveryProcesses(session, recoveryPlan, type);
    }

    public Set<RecoveryProcessDefinition> getRecoveryProcesses(Session session, RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type) {
        List recoveryProcesses;
        String planId = recoveryPlan.getPlanId();
        HashSet<RecoveryProcessDefinition> processes = new HashSet<RecoveryProcessDefinition>();
        ProtectGroup protectGroup = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == protectGroup) {
            logger.error((Object)("The protectGroup does not exist.PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        if (null == planId || null == session) {
            return processes;
        }
        String queryHQL = "from RecoveryProcessDefinition rproc where rproc.planId=:planId";
        if (null != type) {
            queryHQL = queryHQL + " and rproc.procType=:procType";
        }
        Query query = session.createQuery(queryHQL);
        query.setString("planId", planId);
        if (null != type) {
            query.setInteger("procType", type.getValue());
        }
        if (null != (recoveryProcesses = query.list()) && !recoveryProcesses.isEmpty()) {
            for (Object obj : recoveryProcesses) {
                RecoveryProcessDefinition rpDefinition = (RecoveryProcessDefinition)obj;
                Set<RecoveryProcessor> recoveryProcessors = AbstractRecoveryPlanService.getRecoveryProcessors(rpDefinition.getProcessId(), type, session);
                for (RecoveryProcessor processor : recoveryProcessors) {
                    processor.resetEnableStatus(protectGroup, type);
                }
                rpDefinition.setRecoveryProcessors(recoveryProcessors);
                processes.add(rpDefinition);
            }
        }
        return processes;
    }

    protected Set<RecoveryProcessDefinition> constructRecoveryProcessDefinitions(List<?> result) {
        HashSet<RecoveryProcessDefinition> rpDefinitions = new HashSet<RecoveryProcessDefinition>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 6 != (values = (Object[])object).length) continue;
            RecoveryProcessDefinition rpDefinition = new RecoveryProcessDefinition();
            rpDefinition.setProcessId(CommUtil.convertToString((Object)values[0]));
            rpDefinition.setProcType(CommUtil.convertToInteger((Object)values[1]).intValue());
            rpDefinition.setAppType(CommUtil.convertToInteger((Object)values[2]).intValue());
            rpDefinition.setProtectionType(CommUtil.convertToInteger((Object)values[3]).intValue());
            rpDefinition.setPlanId(CommUtil.convertToString((Object)values[4]));
            rpDefinition.setDisasterSiteId(CommUtil.convertToString((Object)values[5]));
            rpDefinitions.add(rpDefinition);
        }
        return rpDefinitions;
    }

    protected static Set<RecoveryProcessor> getRecoveryProcessors(String processId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, Session session) {
        List recoveryProcessors;
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        if (null == processId || null == session) {
            return processors;
        }
        String queryHQL = "from RecoveryProcessor rProcessor where rProcessor.processId=:processId and rProcessor.parentProc is null";
        if (null != type) {
            queryHQL = queryHQL + " and rProcessor.procType=:procType";
        }
        Query query = session.createQuery(queryHQL);
        query.setString("processId", processId);
        if (null != type) {
            query.setInteger("procType", type.getValue());
        }
        if (null != (recoveryProcessors = query.list()) && !recoveryProcessors.isEmpty()) {
            for (Object obj : recoveryProcessors) {
                processors.add((RecoveryProcessor)obj);
            }
        }
        return processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRecoveryPlanExisted(String planId) {
        Session session;
        boolean isExsited;
        block4: {
            isExsited = false;
            session = null;
            try {
                String querySQL = "select count(*) from ti_recoveryplan where planid=:planId";
                session = this.getHibernateSession();
                NativeQuery query = session.createSQLQuery(querySQL);
                query.setString("planId", planId);
                List results = query.list();
                if (null == results || results.isEmpty()) break block4;
                isExsited = true;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Querying recovery plan failed. Id:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return isExsited;
    }

    private boolean checkRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty(settings)) {
            return false;
        }
        for (RecoverySetting setting : settings) {
            RecoveryPlan plan = setting.getRecoveryPlan();
            if (null != plan && null != plan.getPlanId() && plan.getPlanId().equals(planId)) continue;
            return false;
        }
        return true;
    }

    private void deleteRecoveryPlan(String recoveryPlanId, boolean isNeedSyncRemove) {
        RecoveryPlan recoveryPlan;
        block6: {
            long startA = System.currentTimeMillis();
            recoveryPlan = this.getRecoveryPlan(recoveryPlanId, false, false);
            if (null == recoveryPlan) {
                logger.error((Object)("The recovery plan does not exist.PlanId:" + recoveryPlanId), 90160758784001L);
                throw new LegoCheckedException(201L);
            }
            long startB = System.currentTimeMillis();
            logger.info((Object)("getRecoveryPlan cost time:" + (startB - startA)));
            if (recoveryPlan.getUse() == 1) {
                IUseCopyDataService copyDataService = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
                copyDataService.deleteTask(recoveryPlan);
            }
            if (isNeedSyncRemove) {
                RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN);
                if (DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE.getValue() == recoveryPlan.getPlanType()) {
                    try {
                        long startAA = System.currentTimeMillis();
                        this.setPoRepToRecoveryPlan(recoveryPlan);
                        long startBB = System.currentTimeMillis();
                        this.removeRemoteRecoveryPlan(recoveryPlan);
                        long startCC = System.currentTimeMillis();
                        logger.info((Object)("set PoRep To RecoveryPlan cost time:" + (startBB - startAA) + ", remove RemoteRecoveryPlan cost time:" + (startCC - startBB)));
                    }
                    catch (LegoCheckedException e) {
                        logger.error((Object)("Deleting remote rp failed. id:" + recoveryPlanId), (Throwable)e, 90160758784001L);
                        if (201L == e.getErrorCode() || 1073947394L == e.getErrorCode()) break block6;
                        throw e;
                    }
                }
            }
        }
        this.deleteRecoveryPlan(recoveryPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistedRecoveryPlanById(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExist = false;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySQL = "select PLANID from ti_recoveryplan where PLANID=:planId";
            NativeQuery query = session.createSQLQuery(querySQL);
            query.setString("planId", recoveryPlanId);
            List recoveryPlans = query.list();
            if (null != recoveryPlans && !recoveryPlans.isEmpty()) {
                isExist = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Checking whether the recovery plan existed failed. PlanId:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRecoveryPlan(RecoveryPlan recoveryPlan) {
        Session session = null;
        try {
            session = this.getHibernateSession();
            session.beginTransaction();
            String deleteDetailSql = "delete from ti_recoveryprocessordetail where logid in (select logid from ti_recoverylog where planid=:planid)";
            NativeQuery sqlQuery = session.createSQLQuery(deleteDetailSql);
            sqlQuery.setString("planid", recoveryPlan.getPlanId());
            long startA = System.currentTimeMillis();
            sqlQuery.executeUpdate();
            long startB = System.currentTimeMillis();
            session.delete((Object)recoveryPlan);
            long startC = System.currentTimeMillis();
            session.getTransaction().commit();
            long startD = System.currentTimeMillis();
            logger.info((Object)("delete detail cost time:" + (startB - startA) + ", delete cost time:" + (startC - startB) + ", commit cost time:" + (startD - startC)));
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e, (String)("Deleting recovery plan failed. Id:" + recoveryPlan.getPlanId()), (long)1073948688L, null, (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExistedAssociatedRecoveryPlan(Set<ProtectGroup> protectGroups) {
        if (VerifyUtil.isEmpty(protectGroups)) {
            logger.error((Object)"The parameter is invalid.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = false;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySQL = "select a.PLANID from ti_drp_r_pg a left join ti_recoveryplan b on a.PLANID=b.PLANID where a.PGID=:pgId and b.PLANUSE !=" + RecoveryPlanUse.INTERNAL_USE.getValue();
            for (ProtectGroup protectGroup : protectGroups) {
                NativeQuery query = session.createSQLQuery(querySQL);
                query.setString("pgId", protectGroup.getUuid());
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) continue;
                isExisted = true;
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting associated recovery plan failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return isExisted;
    }

    private void checkRecoveryPlanForCreate(RecoveryPlan recoveryPlan, boolean isNeedSync, boolean supportMultiPlan) {
        this.checkParameterValidityForCreate(recoveryPlan);
        Integer planUse = recoveryPlan.getUse();
        if (VerifyUtil.isEmpty((Object)planUse)) {
            planUse = RecoveryPlanUse.PUBLIC_USE.getValue();
        }
        if (this.isExistedRecoveryPlanByName(recoveryPlan.getName(), planUse)) {
            logger.error((Object)("The plan name already exists. PlanName:" + recoveryPlan.getName()), 90160758784001L);
            String productSiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
            ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
            Site productSite = siteService.getSiteById(productSiteId);
            List localSites = siteService.getAllLocalSites();
            boolean isProductLocal = localSites.contains(productSite);
            Set<String> disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan);
            boolean isDisasterLocal = RecoveryServiceUtil.isExistLocalRecoverySite(disasterSiteIds);
            if (isProductLocal && !isDisasterLocal) {
                throw new LegoCheckedException(1073948725L);
            }
            if (!isProductLocal && isDisasterLocal) {
                throw new LegoCheckedException(1073948726L);
            }
            throw new LegoCheckedException(1073947392L);
        }
        if (!supportMultiPlan && this.isExistedAssociatedRecoveryPlan(recoveryPlan.getProtectGroups())) {
            logger.error((Object)("The associated recovery plan already exists. PlanName:" + recoveryPlan.getName()), 90160758784001L);
            throw new LegoCheckedException(1073948694L);
        }
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            IProtectObjectProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
            if (!provider.needRefreshPgStorageInfoPreBuildReplica(protectGroup)) continue;
            logger.error((Object)"protect group cannot create recovery plan.name:%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948748L);
        }
        this.checkRecoveryPlanNumLimit(recoveryPlan);
    }

    private void checkSiteIfExists(RecoveryPlan recoveryPlan, boolean isNeedSync) {
        boolean isLocalAllDisasterSites;
        String productSiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List localSites = siteService.getAllLocalSites();
        boolean isProductLocal = RecoveryServiceUtil.isContainSite(localSites, productSiteId);
        if (isProductLocal && (isLocalAllDisasterSites = this.isLocalAllDisasterSites(recoveryPlan, localSites))) {
            return;
        }
        Site productSite = siteService.getSiteById(productSiteId);
        if (!isProductLocal && null == productSite) {
            long errorCode = 1073948718L;
            if (!isNeedSync) {
                errorCode = 1073948720L;
            }
            throw new LegoCheckedException(errorCode);
        }
        for (String disasterSiteId : RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan)) {
            boolean isDisasterLocal = RecoveryServiceUtil.isContainSite(localSites, disasterSiteId);
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (isDisasterLocal || null != disasterSite) continue;
            long errorCode = 1073948719L;
            if (!isNeedSync) {
                errorCode = 1073948721L;
            }
            throw new LegoCheckedException(errorCode);
        }
    }

    private boolean isLocalAllDisasterSites(RecoveryPlan recoveryPlan, List<Site> localSites) {
        boolean isLocalAllDisasterSites = true;
        Set<String> disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan);
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        for (String disasterSiteId : disasterSiteIds) {
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (localSites.contains(disasterSite)) continue;
            isLocalAllDisasterSites = false;
            break;
        }
        return isLocalAllDisasterSites;
    }

    private void removeRemoteRecoveryPlan(RecoveryPlan recoveryPlan) {
        List<Site> remoteSites = RecoveryServiceUtil.getRemoteSites(recoveryPlan);
        if (VerifyUtil.isEmpty(remoteSites)) {
            logger.warn((Object)("The remote sites is empty. planId:" + recoveryPlan.getPlanId()), 90160758784000L);
            return;
        }
        for (Site remoteSite : remoteSites) {
            this.syncCRDOperationToRemote(remoteSite, (Object)recoveryPlan.getPlanId(), "/ws/recoveryplans/syncRemoveRecoveryPlan/");
        }
    }

    private String createRecoveryPlan(long userID, RecoveryPlan recoveryPlan, boolean isNeedSyncCreate) {
        return this.createRecoveryPlan(userID, recoveryPlan, isNeedSyncCreate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createRecoveryPlan(long userID, RecoveryPlan recoveryPlan, boolean isNeedSyncCreate, boolean supportMultiPlan) {
        if (recoveryPlan == null) {
            logger.error((Object)"The parameter recoveryPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkRecoveryPlanForCreate(recoveryPlan, isNeedSyncCreate, supportMultiPlan);
        Session session = null;
        try {
            Set processes = null;
            if (isNeedSyncCreate) {
                processes = RecoveryServiceUtil.getInitRecoveryProcessDefinitions(recoveryPlan);
                recoveryPlan.setProcessesSerialMsg(DrmObjectSerializableUtil.serializableObj(processes));
            } else {
                String planSerialMsg = recoveryPlan.getProcessesSerialMsg();
                processes = DrmObjectSerializableUtil.reverseeObj(planSerialMsg, Set.class);
            }
            List<Site> remoteSites = RecoveryServiceUtil.getRemoteSites(recoveryPlan);
            if (isNeedSyncCreate && DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE.getValue() == recoveryPlan.getPlanType() && !VerifyUtil.isEmpty(remoteSites)) {
                this.createRecoveryPlanFromRemote(recoveryPlan, remoteSites);
            }
            recoveryPlan.setRecoveryProcesses(processes);
            if (VerifyUtil.isEmpty((Object)recoveryPlan.getCreateTime())) {
                recoveryPlan.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            }
            session = this.getHibernateSession();
            session.beginTransaction();
            session.save((Object)recoveryPlan);
            this.updatePoRecoveryStatus((Set<ProtectGroup>)recoveryPlan.getProtectGroups(), DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E.NOT_STARTED, session);
            if (this.recoveryPlanCreateEventHandlers != null) {
                for (IRecoveryPlanCreateEventHandler handler : this.recoveryPlanCreateEventHandlers) {
                    HibernateUtil.execute(() -> handler.handle(recoveryPlan), session);
                }
            }
            session.save((Object)recoveryPlan);
            session.getTransaction().commit();
            DBOperationUtil.closeSession(session);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Creating recovery plan failed.", (Throwable)e);
            DBOperationUtil.rollbackSession(session);
            throw e;
            catch (Exception e2) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e2, (String)"Creating recovery plan failed.", (long)-1L, null, (Log)logger);
            }
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        this.bizScopeManager.addObject(Long.valueOf(userID), new String[]{recoveryPlan.getPlanId()});
        return recoveryPlan.getPlanId();
    }

    private void createRecoveryPlanFromRemote(RecoveryPlan recoveryPlan, List<Site> remoteSites) {
        Iterator<Site> iterator = remoteSites.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        Site remoteSite = iterator.next();
        try {
            RestClient client = SiteUtil.initClient(remoteSite);
            client.postSerializableObj((Object)recoveryPlan, "/ws/recoveryplans/syncCreateRecoveryPlan");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Sync create rp failed. Name:" + recoveryPlan.getName()), (Throwable)e, 90160758784001L);
            if (1073948686L == e.getErrorCode()) {
                e = this.reDefineHostNotExistException(recoveryPlan, remoteSite, e);
            }
            throw e;
        }
    }

    private LegoCheckedException reDefineHostNotExistException(RecoveryPlan recoveryPlan, Site remoteSite, LegoCheckedException e) {
        if (remoteSite.getSiteId().equals(RecoveryServiceUtil.getProductSiteId(recoveryPlan))) {
            Site disasterSite = this.getLocalDisasterSites(recoveryPlan).get(0);
            if (VerifyUtil.isEmpty((Object[])e.getParameters())) {
                return e;
            }
            DrResource hostOrGroup = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(e.getParameters()[0]);
            String hostOrGroupName = e.getParameters()[0];
            if (null != hostOrGroup) {
                hostOrGroupName = hostOrGroup.getName();
            }
            String[] expParams = new String[]{hostOrGroupName, remoteSite.getName(), disasterSite.getName()};
            e = new LegoCheckedException(1073948728L, expParams);
        }
        return e;
    }

    private List<Site> getLocalDisasterSites(RecoveryPlan recoveryPlan) {
        ArrayList<Site> disasterSites = new ArrayList<Site>();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Set<String> disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan);
        List localSites = siteService.getAllLocalSites();
        for (Site localSite : localSites) {
            if (!disasterSiteIds.contains(localSite.getSiteId())) continue;
            disasterSites.add(localSite);
        }
        return disasterSites;
    }

    private void resetRecoveryPlanGlobalSetting(RecoveryPlan recoveryPlan, Map<String, Object> settings) {
        HashMap<String, String> globalSetting = recoveryPlan.getGlobalSettings();
        if (VerifyUtil.isEmpty(settings)) {
            globalSetting = new HashMap<String, String>();
            recoveryPlan.setGlobalSettings(globalSetting);
            return;
        }
        Set<Map.Entry<String, Object>> entrySet = settings.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            globalSetting.put(key, String.valueOf(value));
        }
    }

    private void resetRecoveryPlanSettings(RecoveryPlan recoveryPlan, List<RecoverySetting> settings) {
        if (VerifyUtil.isEmpty(settings)) {
            return;
        }
        Set preSettings = recoveryPlan.getRecoverySettings();
        for (RecoverySetting setting : settings) {
            boolean isExisted = false;
            for (RecoverySetting preSetting : preSettings) {
                if (!setting.getRecoveryPlan().getPlanId().equals(preSetting.getRecoveryPlan().getPlanId()) || !setting.getOwnerId().equals(preSetting.getOwnerId()) || !setting.getName().equals(preSetting.getName())) continue;
                preSetting.setValue(setting.getValue());
                isExisted = true;
            }
            if (isExisted) continue;
            preSettings.add(setting);
        }
    }

    private void checkRecoveryPlanNumLimit(RecoveryPlan recoveryPlan) {
        int count = this.getValidRecoveryPlanNum();
        if (2000L > (long)count) {
            return;
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == pg) {
            throw new LegoCheckedException(1073947393L);
        }
        String productSiteId = pg.getProductSiteId();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List localSites = siteService.getAllLocalSites();
        Site productSite = siteService.getSiteById(productSiteId);
        boolean isProductLocal = localSites.contains(productSite);
        long errorCode = 1073948715L;
        if (isProductLocal) {
            errorCode = 1073948714L;
        }
        throw new LegoCheckedException(errorCode, new String[]{String.valueOf(2000L)});
    }

    private void checkParameterValidityForCreate(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((String)recoveryPlan.getName()) || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup persistentPG = protectGroupService.getProtectGroupByID(protectGroup.getUuid(), false);
        if (persistentPG.isInvalid()) {
            logger.error((Object)("Protect Group has been invalid. Id:" + protectGroup.getUuid()), 90160758784001L);
            throw new LegoCheckedException(1073948693L);
        }
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(persistentPG);
        if (null == provider) {
            logger.error((Object)("There is no matched provider. Id:" + protectGroup.getUuid()), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType())) {
            return;
        }
        boolean isMatched = provider.isSuitableProtectGroup(DrmEnumDefine.RECOVERY_PLAN_TYPE_E.getType((int)recoveryPlan.getPlanType()), persistentPG);
        if (!isMatched) {
            logger.error((Object)("Protect Group is not matched for the specified plan type. Id:" + protectGroup.getUuid() + ",PlanType:" + recoveryPlan.getPlanType()), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getValidRecoveryPlanNum() {
        Session session;
        int count;
        block4: {
            count = 0;
            session = null;
            try {
                Object obj;
                String querySQL = "select count(*) from ti_recoveryplan where PLANSTATUS != -1 and PLANUSE = 0 ";
                session = this.getHibernateSession();
                NativeQuery query = session.createSQLQuery(querySQL);
                List recoveryPlans = query.list();
                if (null == recoveryPlans || recoveryPlans.isEmpty() || !((obj = recoveryPlans.get(0)) instanceof BigInteger)) break block4;
                count = ((BigInteger)obj).intValue();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Checking back recovery task count failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOrUpdateRecoverySettings(RecoveryPlan recoveryPlan, List<RecoverySetting> settings) {
        RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING);
        this.resetRecoveryPlanSettings(recoveryPlan, settings);
        Session session = null;
        try {
            session = this.getHibernateSession();
            session.beginTransaction();
            for (RecoverySetting recoverySetting : recoveryPlan.getRecoverySettings()) {
                session.saveOrUpdate((Object)recoverySetting);
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateRecoverySettings failed.", (long)-1L, null, (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    private void saveOrUpdateGlobalSettings(RecoveryPlan recoveryPlan, Map<String, Object> globalSettings) {
        RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING);
        this.resetRecoveryPlanGlobalSetting(recoveryPlan, globalSettings);
        try {
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateGlobalSettings failed.", (long)-1L, null, (Log)logger);
        }
    }

    private void updatePoRecoveryStatus(Set<ProtectGroup> protectGroups, DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E poRecoveryStatus, Session session) {
        String updateSQL = "UPDATE ti_protectobject SET PORECOVERYSTATUS=:poRecoveryStatus where PGID=:pgId";
        for (ProtectGroup pg : protectGroups) {
            NativeQuery query = session.createSQLQuery(updateSQL);
            query.setInteger("poRecoveryStatus", poRecoveryStatus.getValue());
            query.setString("pgId", pg.getUuid());
            query.executeUpdate();
        }
    }

    private void checkMountPlan(MountConfiguration mountPlan) {
        int[] targetTypes;
        if (VerifyUtil.isEmpty((String)mountPlan.getHostOrGroupSn())) {
            logger.error((Object)("mount plan " + mountPlan.getName() + " mount host is invalid."));
            throw new LegoCheckedException(1073947393L);
        }
        Site site = null;
        if (!VerifyUtil.isEmpty((String)mountPlan.getSiteId()) && VerifyUtil.isEmpty((Object)(site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(mountPlan.getSiteId())))) {
            logger.error((Object)("The site is not exist, siteId is" + mountPlan.getSiteId()));
            throw new LegoCheckedException(2117645L, "The site is not exist");
        }
        if (!VerifyUtil.isEmpty(site) && !VerifyUtil.isEmpty((Object)site.getIsCloudSite()) && site.getIsCloudSite().booleanValue()) {
            Map cloudHost = ((INovaServerService)ServiceLocator.getInstance().getService(INovaServerService.class)).getNovaServer(mountPlan.getSiteId(), mountPlan.getHostOrGroupSn());
            if (VerifyUtil.isEmpty((Map)cloudHost)) {
                logger.error((Object)("mount plan " + mountPlan.getName() + " mount cloud host is not exist."));
                throw new LegoCheckedException(1077950337L, "The cloud host is not exist");
            }
        } else {
            DrResource hostOrGroup = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(mountPlan.getHostOrGroupSn().split(":")[0]);
            if (VerifyUtil.isEmpty((Object)hostOrGroup)) {
                logger.error((Object)("mount plan " + mountPlan.getName() + " mount host is not exist."));
                throw new LegoCheckedException(1077950337L, "The host is not exist");
            }
        }
        String protectGroupId = mountPlan.getProtectGroupId();
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"protect group not exist.id:%s", new Object[]{protectGroupId});
            throw new LegoCheckedException(2117645L);
        }
        IProtectObjectProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        if (provider.needRefreshPgStorageInfoPreBuildReplica(protectGroup)) {
            logger.error((Object)"protect group cannot create recovery plan.name:%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948748L);
        }
        if (!VerifyUtil.isEmpty((String)mountPlan.getStartTime())) {
            Date currentDate = new Date();
            Date execDate = null;
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                execDate = sDateFormat.parse(mountPlan.getStartTime());
            }
            catch (Exception e) {
                logger.error((Object)("mountplan start time is error format, " + mountPlan.getStartTime() + "."));
                throw new LegoCheckedException(1073947393L);
            }
            if (currentDate.getTime() >= execDate.getTime()) {
                logger.error((Object)("Execution time " + mountPlan.getStartTime() + " is less than current time."));
                throw new LegoCheckedException(1073948456L);
            }
        }
        for (int targetType : targetTypes = new int[]{-1, 3, 9, 10, 5}) {
            if (targetType != mountPlan.getTargetReplicaType()) continue;
            return;
        }
        logger.error((Object)("target type is invalid " + mountPlan.getTargetReplicaType()));
        throw new LegoCheckedException(1073947393L);
    }
}

