/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanObserverManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.process.RecoveryPreCheckerManager;
import com.huawei.ism.drm.recovery.framework.process.RecoveryPreProcessorManager;
import com.huawei.ism.drm.recovery.framework.task.FixedRecoveryThreadPool;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTask;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTaskExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.task.ReprotectCallBackExcuteRecoveryTask;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.SyncLockManager;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

@Service(Name="com.huawei.ism.drm.drp.sdk.service.IRecoveryManager", Desc="", Interface=IRecoveryManager.class)
public class RecoveryManager
extends BaseService
implements IRecoveryManager {
    private static final Log logger = LogFactory.getInstance(RecoveryManager.class);
    private static final String URL_TEST = "/ws/recoveryplans/{planId}/action/test";
    private static final String URL_TESTCLEANUP = "/ws/recoveryplans/{planId}/action/testCleanup";
    private static final String URL_PLANEDMIGRATION = "/ws/recoveryplans/{planId}/action/plannedMigration";
    private static final String URL_HOTMIGRATION = "/ws/recoveryplans/{planId}/action/hotMigration";
    private static final String URL_REPROTECT = "/ws/recoveryplans/{planId}/action/reprotect";
    private static final String URL_ACTION_CONTINUE = "/ws/recoveryplans/{planId}/action/{actionType}/continue";
    private static final String SEPARATOR = ":";
    private IRecoveryPlanService recoveryPlanService;

    public IRecoveryPlanService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public void setRecoveryPlanService(IRecoveryPlanService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDisasterRecovery(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            this.checkParameters(recoveryPlanId, recoveryContext, operator);
            RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
            IRecoveryProcessProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
            ProtectGroup pg = recoveryPlan.getProtectGroup();
            this.checkMatchAz2Region(recoveryContext, pg, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY);
            Map settings = provider.checkRecoveryContext(recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY, recoveryContext, operator);
            String newDisasterSiteId = null;
            Object disasterSiteValue = settings.get("DISASTER_SITE_ID");
            if (null != disasterSiteValue) {
                newDisasterSiteId = String.valueOf(disasterSiteValue);
            }
            RecoveryServiceUtil.checkRecoveryOperationPrivilegeBySite(recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY, newDisasterSiteId);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY);
            this.dealGlobalSettings(recoveryPlan);
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            this.checkInstanceStatusAndHoldVm(recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY);
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    public void startPlanedMotion(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.migration(recoveryPlanId, recoveryContext, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION, URL_PLANEDMIGRATION);
    }

    private void migration(String recoveryPlanId, Map<String, String> recoveryContext, User operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E excuteType, String urlMigration) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        IRecoveryProcessProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
        this.dealGlobalSettings(recoveryPlan);
        String recoverySiteId = provider.getRecoverySiteId(recoveryPlanId, excuteType, recoveryContext);
        Site recoverySite = RecoveryServiceUtil.getRecoverySite(recoverySiteId);
        if (0 != recoverySite.getSiteType()) {
            this.sendRestRequestToDisasterSite(recoveryPlanId, recoveryContext, recoverySite, urlMigration, null);
        } else {
            this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, excuteType);
        }
    }

    public void continuePlannedMigration(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        IRecoveryProcessProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
        this.dealGlobalSettings(recoveryPlan);
        String recoverySiteId = provider.getRecoverySiteId(recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION, recoveryContext);
        Site recoverySite = RecoveryServiceUtil.getRecoverySite(recoverySiteId);
        if (0 != recoverySite.getSiteType()) {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            uriVariables.put("actionType", DrmEnumDefine.RecoveryActionType.PLANED_MOTION.getValue());
            this.sendRestRequestToDisasterSite(recoveryPlanId, recoveryContext, recoverySite, URL_ACTION_CONTINUE, uriVariables);
        } else {
            Boolean isContinue = Boolean.parseBoolean(recoveryContext.get("recovery_continue_key"));
            this.handleRecoveryContinue(recoveryPlan, isContinue, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION);
        }
    }

    public void startHotMigration(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.migration(recoveryPlanId, recoveryContext, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION, URL_HOTMIGRATION);
    }

    private IRecoveryProcessProvider getRecoveryProcessProvider(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        this.checkIfProtectObjectExisted(recoveryPlan);
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            throw new LegoCheckedException(1073947393L);
        }
        return provider;
    }

    private void dealGlobalSettings(RecoveryPlan recoveryPlan) {
        Map globalSettings = recoveryPlan.getGlobalSettings();
        if (globalSettings.containsKey("RECOVERY_EXTEND_ATTRIBUTES")) {
            globalSettings.put("RECOVERY_EXTEND_ATTRIBUTES", "-1");
        }
        globalSettings.remove("REPLICA_ID");
    }

    public void startRecoveryDrilling(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        IRecoveryProcessProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
        String recoverySiteId = null;
        if (this.validateIsArrayHypermetro(recoveryPlan)) {
            this.checkPriorityStationType(recoveryContext);
            recoverySiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
            recoveryContext.put("DISASTER_SITE_ID", recoverySiteId);
        } else {
            recoverySiteId = provider.getRecoverySiteId(recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING, recoveryContext);
        }
        Site recoverySite = RecoveryServiceUtil.getRecoverySite(recoverySiteId);
        this.dealGlobalSettings(recoveryPlan);
        this.prepareSuffixType(recoveryPlanId, recoveryContext, "Drilling");
        recoveryContext.put("recovery_region_id", recoverySite.getRegionId());
        recoveryContext.put("region_id", (String)recoveryPlan.getProtectGroup().getProps().get("regionId"));
        if (0 != recoverySite.getSiteType()) {
            this.sendRestRequestToDisasterSite(recoveryPlanId, recoveryContext, recoverySite, URL_TEST, null);
        } else {
            this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING);
        }
    }

    private boolean validateIsArrayHypermetro(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        ProtectGroup pg = (ProtectGroup)protectGroups.iterator().next();
        if (15 != pg.getTemplate().getType()) {
            return false;
        }
        ProtectObject po = (ProtectObject)pg.getPolist().iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.error((Object)("usedStorageResourceSet is empty! pgName : " + pg.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        return posi.getResourceType().intValue() == DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue();
    }

    private void checkPriorityStationType(Map<String, String> recoveryContext) {
        String priorityStationType = recoveryContext.get("priorityStationType");
        HashSet<String> types = new HashSet<String>();
        types.add(String.valueOf(0));
        types.add(String.valueOf(1));
        if (VerifyUtil.isEmpty((String)priorityStationType)) {
            logger.error((Object)"priorityStationType is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!types.contains(priorityStationType)) {
            logger.error((Object)"priorityStationType is error, priorityStationType:%s .", new Object[]{priorityStationType});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void cleanRecoveryDrilling(String recoveryPlanId, User operator) {
        this.checkParameters(recoveryPlanId, operator);
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(recoveryPlanId);
        Site recoverySite = this.getRecoverySite(recoveryPlan);
        if (recoverySite.getSiteType() != 0) {
            this.sendRestRequestToDisasterSite(recoveryPlanId, recoverySite, URL_TESTCLEANUP);
        } else {
            this.handleRecoveryOperation(recoveryPlan, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING);
        }
    }

    private RecoveryPlan getRecoveryPlan(String recoveryPlanId) {
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        this.checkIfProtectObjectExisted(recoveryPlan);
        return recoveryPlan;
    }

    public void reprotectRecoveryPlan(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        Site recoverySite = this.getRecoverySite(recoveryPlan);
        if (0 != recoverySite.getSiteType()) {
            this.sendRestRequestToDisasterSite(recoveryPlanId, recoveryContext, recoverySite, URL_REPROTECT, null);
        } else {
            RecoveryServiceUtil.checkReprotectOperationPrivilege(recoveryPlan);
            this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT);
        }
    }

    private Site getRecoverySite(RecoveryPlan recoveryPlan) {
        String recoverySiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        if (VerifyUtil.isEmpty((String)recoverySiteId)) {
            throw new LegoCheckedException(1073948768L);
        }
        return RecoveryServiceUtil.getRecoverySite(recoverySiteId);
    }

    private void sendRestRequestToDisasterSite(String recoveryPlanId, Map<String, String> recoveryContext, Site curDisasterSite, String restUrl, Map<String, Object> uriVariablesMap) {
        RestClient client = SiteUtil.initClient(curDisasterSite);
        try {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            if (uriVariablesMap != null) {
                uriVariables.putAll(uriVariablesMap);
            }
            uriVariables.put("planId", recoveryPlanId);
            uriVariables.put("recoveryContext", recoveryContext);
            JSONObject object = JSONObject.fromObject(recoveryContext);
            client.put(restUrl, object.toString(), uriVariables);
        }
        catch (LegoCheckedException le) {
            ExceptionUtil.rethrowException((Throwable)le, (String)le.getMessage(), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
        }
    }

    private void sendRestRequestToDisasterSite(String recoveryPlanId, Site curDisasterSite, String restUrl) {
        RestClient client = SiteUtil.initClient(curDisasterSite);
        try {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("planId", recoveryPlanId);
            client.invoke(restUrl, uriVariables, HttpMethod.PUT);
        }
        catch (LegoCheckedException le) {
            ExceptionUtil.rethrowException((Throwable)le, (String)le.getMessage(), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
        }
    }

    public void startSwaping(String recoveryPlanId, User operator) {
        this.checkParameters(recoveryPlanId, operator);
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(recoveryPlanId);
        String recoverySiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
        recoveryPlan.getGlobalSettings().put("DISASTER_SITE_ID", recoverySiteId);
        this.handleRecoveryOperation(recoveryPlan, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SWAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryContinue(RecoveryPlan recoveryPlan, Boolean isContinue, User operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E executeType) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            this.checkRecoveryPlanPaused(recoveryPlan);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.getType((int)executeType.getValue()));
            RecoveryProcessDefinition rpDefinition = recoveryPlan.getRecoveryProcess(executeType);
            if (rpDefinition == null) {
                logger.error((Object)"rpDefinition is null.");
                throw new LegoCheckedException(1073947393L);
            }
            HashMap<String, String> recoveryContext = new HashMap<String, String>();
            recoveryContext.put("IS_CONTINUE_PROCESS", isContinue.toString());
            this.submitRecoveryBackTask(recoveryPlan, rpDefinition, operator, recoveryContext);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryOperation(RecoveryPlan recoveryPlan, Map<String, String> recoveryContext, User operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        this.checkMatchAz2Region(recoveryContext, pg, execType);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
            if (null == provider) {
                logger.error((Object)"provider is null. RecoveryPlanId is %s .", new Object[]{recoveryPlanId});
                return;
            }
            HashMap<String, Object> settings = new HashMap<String, String>();
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.equals((Object)execType) || this.validateIsArrayHypermetro(recoveryPlan)) {
                settings.putAll(recoveryContext);
            } else {
                settings = provider.checkRecoveryContext(recoveryPlanId, execType, recoveryContext, operator);
            }
            RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.getType((int)execType.getValue()));
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            this.checkInstanceStatusAndHoldVm(recoveryPlan, execType);
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, execType);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, recoveryContext);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryOperation(RecoveryPlan recoveryPlan, User operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.getType((int)execType.getValue()));
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, execType);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    private void checkMatchAz2Region(Map<String, String> recoveryContext, ProtectGroup pg, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType) {
        String pgRegionId = (String)pg.getProps().get("regionId");
        if (!VerifyUtil.isEmpty((String)pgRegionId) && pgRegionId.contains(SEPARATOR)) {
            pgRegionId = pgRegionId.split(SEPARATOR)[1];
        }
        String azId = recoveryContext.get("az_id");
        String regionId = recoveryContext.get("region_id");
        String pgazId = (String)pg.getProps().get("zoneName");
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.equals((Object)execType) || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.equals((Object)execType) || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.equals((Object)execType) || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.equals((Object)execType)) {
            if (!(VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)pgRegionId) || regionId.equals(pgRegionId))) {
                logger.error((Object)"region or az message error, regionId: %s, pgRegionId: %s", new Object[]{regionId, pgRegionId});
                throw new LegoCheckedException(1073949727L);
            }
            if (!(VerifyUtil.isEmpty((String)azId) || VerifyUtil.isEmpty((String)pgazId) || azId.equals(pgazId))) {
                logger.error((Object)"region or az message error, azId: %s, pgazId: %s", new Object[]{azId, pgazId});
                throw new LegoCheckedException(1073949727L);
            }
        }
    }

    protected void checkRecoveryPlanExecuting(String recoveryPlanId) {
        if (SyncLockManager.isLocked(recoveryPlanId + 0)) {
            logger.error((Object)("The recovery plan is executing. PlanId:" + recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(1073948750L);
        }
    }

    private void checkRecoveryPlanPaused(RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_PAUSED.getValue() != recoveryPlan.getPlanStatus()) {
            String msg = String.format(Locale.ROOT, "The recovery plan is not paused. PlanId:%s .", recoveryPlan.getPlanId());
            logger.error((Object)msg);
            throw new LegoCheckedException(msg);
        }
    }

    protected void tryLockRecoveryPlan(String recoveryPlanId) {
        if (!SyncLockManager.tryLock(recoveryPlanId + 1)) {
            logger.error((Object)("The recovery plan is executing. PlanId:" + recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(1073948750L);
        }
    }

    protected void unLockRecoveryPlan(String recoveryPlanId) {
        SyncLockManager.unLock(recoveryPlanId + 1);
    }

    protected RecoveryPlan updateRecoveryPlanSetting(RecoveryPlan recoveryPlan, Map<String, Object> settings) {
        if (null == recoveryPlan || null == settings || settings.isEmpty()) {
            return recoveryPlan;
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
        settings.put("PRODUCT_SITE_ID", productSiteId);
        HashSet<RecoverySetting> recoverySettings = recoveryPlan.getRecoverySettings();
        if (null == recoverySettings) {
            recoverySettings = new HashSet<RecoverySetting>();
            recoveryPlan.setRecoverySettings(recoverySettings);
        }
        Map globalSettings = recoveryPlan.getGlobalSettings();
        HashMap<String, Object> syncSettings = new HashMap<String, Object>();
        syncSettings.putAll(globalSettings);
        String disasterSiteId = String.valueOf(settings.get("DISASTER_SITE_ID"));
        Set<Map.Entry<String, Object>> settingsEntrySet = settings.entrySet();
        for (Map.Entry<String, Object> entry : settingsEntrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Map)) {
                globalSettings.put(key, String.valueOf(value));
                syncSettings.put(key, value);
                continue;
            }
            Map subSettingsMap = (Map)value;
            Set subEntrySet = subSettingsMap.entrySet();
            for (Map.Entry subEntry : subEntrySet) {
                Object subKey = subEntry.getKey();
                Object subValue = subEntry.getValue();
                RecoverySetting recoverySetting = new RecoverySetting();
                recoverySetting.setRecoveryPlan(recoveryPlan);
                recoverySetting.setDisasterSiteId(disasterSiteId);
                recoverySetting.setOwnerId(String.valueOf(subKey));
                recoverySetting.setName(key);
                recoverySetting.setValue(String.valueOf(subValue));
                RecoveryServiceUtil.resetRecoverySetting(recoverySettings, recoverySetting);
            }
        }
        this.syncSettingsToRemote(recoveryPlan, syncSettings);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
        return recoveryPlan;
    }

    protected void syncSettingsToRemote(final RecoveryPlan recoveryPlan, final Map<String, Object> syncSettings) {
        List<Site> remoteSites = RecoveryServiceUtil.getRemoteSites(recoveryPlan);
        if (VerifyUtil.isEmpty(remoteSites)) {
            return;
        }
        final Iterator<Site> iterator = remoteSites.iterator();
        if (iterator.hasNext()) {
            FixedRecoveryThreadPool.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        RecoveryManager.this.recoveryPlanService.syncGlobalSettingsToRemote((Site)iterator.next(), recoveryPlan.getPlanId(), syncSettings);
                    }
                    catch (Exception e) {
                        logger.error((Object)("SyncSettingsToRemote failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                    }
                    return Boolean.TRUE;
                }
            });
        }
    }

    protected void checkParameters(String recoveryPlanId, User operator) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || VerifyUtil.isEmpty((Object)operator) || VerifyUtil.isEmpty((String)operator.getUserName())) {
            logger.error((Object)"Invalid parameter.", 90160758786876L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkParameters(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || null == recoveryContext || VerifyUtil.isEmpty((Object)operator) || VerifyUtil.isEmpty((String)operator.getUserName())) {
            logger.error((Object)"Invalid parameter.", 90160758786876L);
        }
    }

    protected synchronized void submitRecoveryBackTask(RecoveryPlan plan, RecoveryProcessDefinition rpDefinition, User operator, Map<String, String> recoveryContext) {
        if (null == plan) {
            logger.error((Object)"plan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == rpDefinition) {
            logger.error((Object)"rpDefinition is null.");
            throw new LegoCheckedException(1073947393L);
        }
        this.recoveryPlanService.checkBackendRecoveryTaskCount(plan);
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E rpExecuteType = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)rpDefinition.getProcType());
        Map<String, Object> initialContextData = this.getInitialContextData(plan, rpExecuteType);
        initialContextData.put("RecoveryProcessDefinition", rpDefinition);
        this.setSuffixTypeToContextData(recoveryContext, initialContextData);
        this.setIsConfirmReprotectionToContextData(recoveryContext, initialContextData);
        this.setContinueTagToContextData(recoveryContext, initialContextData);
        RecoveryBackTask recoveryBackTask = new RecoveryBackTask();
        recoveryBackTask.setInitialContextData(initialContextData);
        recoveryBackTask.setRecoveryPlan(plan);
        recoveryBackTask.setRecoveryPlanExecuteType(rpExecuteType);
        recoveryBackTask.setOperator(operator);
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.equals((Object)rpExecuteType)) {
            ReprotectCallBackExcuteRecoveryTask callBackTask = new ReprotectCallBackExcuteRecoveryTask();
            recoveryBackTask.setCallBaskTask(callBackTask);
        }
        RecoveryProcessSerialExecutor recoveryTemplate = this.getRecoveryTemplate(rpDefinition, rpExecuteType);
        recoveryBackTask.setRecoveryProcessTemplate(recoveryTemplate);
        RecoveryPreCheckerManager.getInstance().check(plan, rpExecuteType);
        Map<String, Object> preProcessResults = RecoveryPreProcessorManager.getInstance().process(plan, rpExecuteType);
        recoveryBackTask.setPreProcessResults(preProcessResults);
        logger.info((Object)"Begin submit recovery task. Plan name:%s,id: %s, status:%s, task type:%s", new Object[]{plan.getName(), plan.getPlanId(), plan.getPlanStatus(), rpExecuteType});
        RecoveryBackTaskExecutor.submitRecoveryBackTask(recoveryBackTask);
    }

    private void setIsConfirmReprotectionToContextData(Map<String, String> recoveryContext, Map<String, Object> initialContextData) {
        if (VerifyUtil.isEmpty(recoveryContext) || !recoveryContext.containsKey("is_confirm_reprotection")) {
            return;
        }
        initialContextData.put("IS_CONFIRM_REPROTECTION", recoveryContext.get("is_confirm_reprotection"));
    }

    private void setContinueTagToContextData(Map<String, String> recoveryContext, Map<String, Object> initialContextData) {
        if (VerifyUtil.isEmpty(recoveryContext) || !recoveryContext.containsKey("IS_CONTINUE_PROCESS")) {
            return;
        }
        initialContextData.put("IS_CONTINUE_PROCESS", recoveryContext.get("IS_CONTINUE_PROCESS"));
    }

    protected void setSuffixTypeToContextData(Map<String, String> recoveryContext, Map<String, Object> initialContextData) {
        if (VerifyUtil.isEmpty(recoveryContext) || !recoveryContext.containsKey("NameSuffixKey")) {
            logger.info((Object)"context is empty.");
            return;
        }
        String suffix = recoveryContext.get("NameSuffixKey");
        logger.info((Object)"name suffix key: %s.", new Object[]{suffix});
        initialContextData.put("NameSuffixKey", suffix);
    }

    protected void prepareSuffixType(String recoveryPlanId, Map<String, String> recoveryContext, String initSuffix) {
        logger.info((Object)"prepare initial suffix.");
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(recoveryPlanId, true, false);
        if (null == recoveryPlan) {
            logger.error((Object)"recovery plan is null, id: %s.", new Object[]{recoveryPlanId});
            throw new LegoCheckedException(201L);
        }
        String suffix = initSuffix + "_" + recoveryPlan.getName();
        logger.info((Object)"name suffix in params: %s.", new Object[]{suffix});
        recoveryContext.put("NameSuffixKey", suffix);
    }

    protected RecoveryProcessSerialExecutor getRecoveryTemplate(RecoveryProcessDefinition rpDefinition, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E recoveryPlanExecuteType) {
        if (null == rpDefinition) {
            throw new LegoCheckedException(1073947393L);
        }
        Set processors = rpDefinition.getRecoveryProcessors();
        List<? extends IProcessor> sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation(processors);
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(sortedProcessors, recoveryPlanExecuteType);
        if (null == executor) {
            logger.error((Object)"Creating recovery process executor failed.", 90160758784001L);
            throw new LegoCheckedException(0x300001L);
        }
        return executor;
    }

    protected RecoveryProcessDefinition getRecoveryProcessDef(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType) {
        IRecoveryProcessProvider provider;
        RecoveryProcessDefinition rpDefinition = recoveryPlan.getRecoveryProcess(execType);
        if (null == rpDefinition || this.doUpgradeForAutoPlanMotion(recoveryPlan, execType, rpDefinition)) {
            rpDefinition = this.createRecoveryProcessDefinition(recoveryPlan, execType);
        }
        if (null == (provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan))) {
            throw new LegoCheckedException(1073947393L);
        }
        provider.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, true);
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        if (null == protectGroup) {
            logger.error((Object)("The protectGroup does not exist.PlanId:" + recoveryPlan.getPlanId()), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.resetEnableStatus(protectGroup, execType);
        }
        return rpDefinition;
    }

    public RecoveryProcessDefinition createRecoveryProcessDefinition(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        DrmEnumDefine.APP_TYPE appType = RecoveryServiceUtil.getAppType(recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"recoveryPlanId is %s .", new Object[]{recoveryPlan.getPlanId()});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        RecoveryProcessDefinition rpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, execType, protectGroup);
        HashSet<RecoveryProcessDefinition> recoveryProcesses = recoveryPlan.getRecoveryProcesses();
        if (null == recoveryProcesses) {
            recoveryProcesses = new HashSet<RecoveryProcessDefinition>();
            recoveryPlan.setRecoveryProcesses(recoveryProcesses);
        }
        recoveryProcesses.add(rpDefinition);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
        return rpDefinition;
    }

    protected void checkIfProtectObjectExisted(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList protectObjects = new ArrayList();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) continue;
            protectObjects.addAll(protectGroup.getPolist());
        }
        if (protectObjects.isEmpty()) {
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected Map<String, Object> getInitialContextData(RecoveryPlan plan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E rpExecuteType) {
        HashMap<String, Object> initialContextData = new HashMap<String, Object>();
        String disasterSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
        String replicaId = (String)plan.getGlobalSettings().get("REPLICA_ID");
        if (VerifyUtil.isEmpty((Collection)plan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = plan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        ProtectGroupReplica replica = RecoveryProcessUtil.getProtectGroupReplicaByReplicaId(protectGroup, replicaId);
        if (null == replica) {
            replica = RecoveryProcessUtil.getProtectGroupReplicaBySiteId(protectGroup, disasterSiteId);
        }
        if (null == replica) {
            logger.error((Object)"getReplica failed:%s ,pg:%s .", new Object[]{replicaId, protectGroup.getName()});
            return initialContextData;
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        replica = replicaService.queryProtectGroupReplicaById(replica.getId());
        logger.info((Object)("Initial context data, PlanId:" + plan.getPlanId() + ", SiteId:" + disasterSiteId + ", ReplicaId:" + replicaId + ", Replica:" + replica));
        Set<ProtectObject> protectObjects = RecoveryProcessUtil.getRecoveryProtectObjects(protectGroup, replica, rpExecuteType);
        initialContextData.put("Recovery_ProtectObjects", protectObjects);
        initialContextData.put("Recovery_ProtectGroup", protectGroup);
        initialContextData.put("Recovery_PgReplica", replica);
        return initialContextData;
    }

    private void checkInstanceStatusAndHoldVm(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type) {
        MessageEvent event = new MessageEvent();
        HashMap<String, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E> messageMap = new HashMap<String, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E>();
        messageMap.put("message_event_excute_type", type);
        event.setMessageMap(messageMap);
        event.setMessageType(7);
        ArrayList<RecoveryPlan> objectList = new ArrayList<RecoveryPlan>();
        objectList.add(recoveryPlan);
        event.setObjectList(objectList);
        IRecoveryPlanObserverManager observerManager = (IRecoveryPlanObserverManager)ServiceLocator.getInstance().getService(IRecoveryPlanObserverManager.class);
        observerManager.notifyObserverList(event, "before");
    }

    public boolean doUpgradeForAutoPlanMotion(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType, RecoveryProcessDefinition rpDefinition) {
        logger.info((Object)"doUpgradeForAutoPlanMotion: recoveryPlan %s, execType %s", new Object[]{recoveryPlan.getName(), execType.getValue()});
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        if (!Arrays.asList(34, 22, 21).contains(protectGroup.getTemplate().getType())) {
            return false;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() != execType.getValue()) {
            return false;
        }
        Set set = rpDefinition.getRecoveryProcessors().stream().filter(processor -> processor.getProcName().contains("OpenStackReverseStorageRepDirectionProcessor")).collect(Collectors.toSet());
        if (!set.isEmpty()) {
            logger.info((Object)"no need refactPlanMotionProcessDefinition: %s", new Object[]{recoveryPlan.getName()});
            return false;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED.getValue() == recoveryPlan.getPlanStatus()) {
            logger.info((Object)"%s is PLANED_MOTION_FAILED, need refact definition.", new Object[]{recoveryPlan.getName()});
            this.refactPlanMotionProcessDefinition(recoveryPlan, rpDefinition, protectGroup);
        }
        if (DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED.getValue() == recoveryPlan.getPlanStatus()) {
            logger.info((Object)"recoveryPlan(%s), status(%s), need refact definition.", new Object[]{recoveryPlan.getName(), recoveryPlan.getPlanStatus()});
            recoveryPlan.getRecoveryProcesses().remove(rpDefinition);
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.deleteRecoveryProcessDefinition(rpDefinition);
            return true;
        }
        return false;
    }

    private void refactPlanMotionProcessDefinition(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, ProtectGroup protectGroup) {
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        DrmEnumDefine.APP_TYPE appType = RecoveryServiceUtil.getAppType(recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        if (provider == null) {
            logger.error((Object)"Can not find suitable provider");
            throw new LegoCheckedException(2117645L);
        }
        RecoveryProcessDefinition reprotectedRpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT, protectGroup);
        List<RecoveryProcessor> reProcessors = RecoveryServiceUtil.sortRecoveryProcessors(reprotectedRpDefinition.getRecoveryProcessors());
        ArrayList<Class<? extends RecoveryProcessor>> procClsList = new ArrayList<Class<? extends RecoveryProcessor>>();
        for (int ix = 3; ix < reProcessors.size(); ++ix) {
            procClsList.add(reProcessors.get(ix).getClass());
        }
        this.refactRecoveryProcessors(recoveryPlan, rpDefinition, procClsList);
    }

    private void refactRecoveryProcessors(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, List<Class<? extends RecoveryProcessor>> procClsList) {
        RecoveryProcessor lastProcessor = RecoveryServiceUtil.getLastRecoveryProcessor(rpDefinition.getRecoveryProcessors());
        if (null == lastProcessor || VerifyUtil.isEmpty(procClsList)) {
            logger.error((Object)"refact processDefinition error. Can not find the last processor .");
            return;
        }
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        logger.info((Object)"recoveryPlan(%s), need delete definition %s.", new Object[]{recoveryPlan.getName(), rpDefinition.getName()});
        Set recoveryProcesses = recoveryPlan.getRecoveryProcesses();
        recoveryProcesses.remove(rpDefinition);
        recoveryProcessService.deleteRecoveryProcessDefinition(rpDefinition);
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            logger.error((Object)"Can not find suitable provider");
            throw new LegoCheckedException(2117645L);
        }
        provider.insertRecoveryProcessors(rpDefinition, lastProcessor.getPreviousProcessor().getClass(), procClsList, true, false);
        provider.deleteRecoveryProcessors(rpDefinition, lastProcessor.getProcId(), false);
        for (RecoveryProcessor pro : rpDefinition.getRecoveryProcessors()) {
            pro.setProcessId(rpDefinition.getProcessId());
            pro.setPlanId(recoveryPlan.getPlanId());
            if (!procClsList.contains(pro.getClass())) continue;
            pro.setIsPreset(Boolean.valueOf(true));
            pro.setIsEditable(Boolean.valueOf(false));
        }
        recoveryProcesses.add(rpDefinition);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
    }
}

