/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.ObjectConvert;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.mo.ProtectObjectBo;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanListener;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.service.impl.RecoveryPlanQueryServiceImpl;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTask;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.MapUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

@Service(Name="IRecoveryPlanService", Desc="", Interface=IRecoveryPlanService.class)
public class RecoveryPlanServiceImpl
extends RecoveryPlanQueryServiceImpl {
    private static Log logger = LogFactory.getInstance(RecoveryPlanServiceImpl.class);
    private static final String PDB = "PDB";
    private static final String SEPARATOR = ":";
    private IProtectGroupService protectGroupService;
    private List<IRecoveryPlanListener> listeners = new ArrayList<IRecoveryPlanListener>();

    public void addListener(IRecoveryPlanListener listener, Map<?, ?> properties) {
        this.listeners.add(listener);
    }

    public IProtectGroupService getProtectGroupService() {
        return this.protectGroupService;
    }

    public void setProtectGroupService(IProtectGroupService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public RecoveryPlan getRecoveryPlan(String recoveryPlanId) {
        return this.getRecoveryPlan(recoveryPlanId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>> getRecoveryPlansInfo(List<String> planIdList) {
        HashMap<String, Map<String, String>> planProgressMap = new HashMap<String, Map<String, String>>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySQL = "select rp.planid, rp.planstatus, rp.planprogress from ti_recoveryPlan rp where rp.planid in (:planIds)";
            List<List<String>> queryParams = DBOperationUtil.createBatchQueryParameters(planIdList, 10);
            for (List<String> param : queryParams) {
                NativeQuery query = session.createSQLQuery(querySQL);
                query.setParameterList("planIds", param);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) continue;
                for (Object object : results) {
                    Object[] values;
                    if (!(object instanceof Object[]) || 3 != (values = (Object[])object).length) continue;
                    HashMap<String, String> infos = new HashMap<String, String>();
                    String planId = String.valueOf(values[0]);
                    String planStatus = String.valueOf(values[1]);
                    String planProgress = String.valueOf(values[2]);
                    infos.put("planProgress", planProgress);
                    infos.put("planStatus", planStatus);
                    planProgressMap.put(planId, infos);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting plan progress failed. Ids:" + planIdList.toString() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return planProgressMap;
    }

    public RecoveryPlan getRecoveryPlanWithProcess(String recoveryPlanId) {
        return this.getRecoveryPlan(recoveryPlanId, true);
    }

    public void checkBackendRecoveryTaskCount(RecoveryPlan recoveryPlan) {
        int remoteRegionNum;
        String drRegionId;
        int count = this.getBackRunningRecoveryTaskNum();
        long recoveryTaskNum = LegoConfig.getInstance().getNumber("recovery.parallel.run.quantity.config", 20L);
        if (recoveryTaskNum <= (long)count) {
            throw new LegoCheckedException(1073948713L, new String[]{String.valueOf(recoveryTaskNum)});
        }
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        String regionId = (String)pg.getProps().get("regionId");
        if (!VerifyUtil.isEmpty((String)regionId) && regionId.contains(SEPARATOR)) {
            regionId = regionId.split(SEPARATOR)[1];
        }
        if (!VerifyUtil.isEmpty((String)(drRegionId = (String)pg.getProps().get("drRegionId"))) && drRegionId.contains(SEPARATOR)) {
            drRegionId = drRegionId.split(SEPARATOR)[1];
        }
        if (VerifyUtil.isEmpty((String)regionId) && VerifyUtil.isEmpty((String)drRegionId)) {
            return;
        }
        long openstackcount = LegoConfig.getInstance().getNumber("region.parallel.run.quantity.config", 10L);
        ConcurrentHashMap parallelMap = RecoveryBackTask.getConcurrentHashMapInstance();
        int localRegionNum = regionId != null && !VerifyUtil.isEmpty(parallelMap.get(regionId)) ? ((AtomicInteger)parallelMap.get(regionId)).intValue() : 0;
        int n = remoteRegionNum = drRegionId != null && !VerifyUtil.isEmpty(parallelMap.get(drRegionId)) ? ((AtomicInteger)parallelMap.get(drRegionId)).intValue() : 0;
        if ((long)localRegionNum >= openstackcount || (long)remoteRegionNum >= openstackcount) {
            logger.error((Object)"Recovery parallel run is more than [%s]", new Object[]{String.valueOf(count)});
            throw new SpecCheckedException("recovery_parallel_execution_quantity", openstackcount, localRegionNum > remoteRegionNum ? (long)localRegionNum : (long)remoteRegionNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistedRecoveryPlanByName(String planName, Integer type) {
        if (VerifyUtil.isEmpty((String)planName)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExist = false;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySQL = "select PLANID from ti_recoveryplan where PLANNAME=:planName and PLANUSE=:planuse";
            NativeQuery query = session.createSQLQuery(querySQL);
            query.setString("planName", planName);
            query.setInteger("planuse", type.intValue());
            List recoveryPlans = query.list();
            if (null != recoveryPlans && !recoveryPlans.isEmpty()) {
                isExist = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Checking whether the recovery plan existed failed. Name:" + planName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistedRecoveryPlanByName(String planName, String planId, Integer planUse) {
        if (VerifyUtil.isEmpty((String)planName) || VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)("Invalid parameter. PlanName:" + planName + ",planId:" + planId), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExist = false;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySQL = "select PLANID from ti_recoveryplan where PLANNAME=:planName and PLANUSE=:planUse and PLANID!=:planId";
            NativeQuery query = session.createSQLQuery(querySQL);
            query.setString("planName", planName);
            query.setInteger("planUse", planUse.intValue());
            query.setString("planId", planId);
            List recoveryPlans = query.list();
            if (null != recoveryPlans && !recoveryPlans.isEmpty()) {
                isExist = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Checking whether the recovery plan existed failed. Name:" + planName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return isExist;
    }

    public RecoveryLog getRecoveryLog(String recoveryLogId) {
        if (VerifyUtil.isEmpty((String)recoveryLogId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return null;
        }
        RecoveryLog recoveryLog = null;
        try {
            Object obj = this.getBaseDao().getHibernateTemplate().get(RecoveryLog.class, (Serializable)((Object)recoveryLogId));
            if (null != obj) {
                recoveryLog = (RecoveryLog)obj;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery log failed. Id:" + recoveryLogId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return recoveryLog;
    }

    public RecoveryProcessorDetail getRecoveryProcessorDetail(String detailId) {
        if (VerifyUtil.isEmpty((String)detailId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return null;
        }
        RecoveryProcessorDetail detail = null;
        try {
            Object obj = this.getBaseDao().getHibernateTemplate().get(RecoveryProcessorDetail.class, (Serializable)((Object)detailId));
            if (null != obj) {
                detail = (RecoveryProcessorDetail)obj;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery process detail failed. Id:" + detailId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return detail;
    }

    public RecoveryProcessorDetail getRecoveryProcessorDetail(String planId, String detailId) {
        String disasterSiteId;
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)detailId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.queryRecoveryPlan(planId, false);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
        if (this.isNeedQueryFromDisaster(productSiteId, disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID"))) {
            Site remoteSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(disasterSiteId);
            RestClient client = SiteUtil.initClient(remoteSite);
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("planId", planId);
            request.put("detailId", detailId);
            RecoveryProcessorDetail result = (RecoveryProcessorDetail)client.postSerializableObj(request, "/ws/recoveryplans/getRecoveryProcessorDetail", RecoveryProcessorDetail.class);
            return result;
        }
        return this.getRecoveryProcessorDetail(detailId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryLog getLatestRecoveryLog(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return null;
        }
        String queryHQL = "from RecoveryLog rl where rl.planId=:planId and (rl.endTime=null or rl.logStatus=4) order by rl.startTime desc";
        RecoveryLog recoveryLog = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            Query query = session.createQuery(queryHQL);
            query.setString("planId", recoveryPlanId);
            List recoveryLogs = query.list();
            if (null != recoveryLogs && !recoveryLogs.isEmpty()) {
                recoveryLog = (RecoveryLog)recoveryLogs.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery logs failed. Id:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryLog;
    }

    public RecoveryLog getLatestHistoryRecoveryLog(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = this.isRecoveryPlanExisted(recoveryPlanId);
        if (!isExisted) {
            logger.error((Object)("Recovery plan does not exist. logId:" + recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        String queryHQL = "from RecoveryLog rl where rl.planId=:planId and rl.endTime!=null order by rl.startTime desc";
        return this.getRecoveryLog(recoveryPlanId, queryHQL);
    }

    public Page pageQueryRecoveryPlan(int pageNum, int pageSize, String orderBy, boolean isAsc, int planType, Map<String, Object> extFilterMap, Long userId) {
        if (null == extFilterMap) {
            logger.trace((Object)"prop is null");
            extFilterMap = new HashMap<String, Object>();
        }
        if (!RecoveryPlan.checkPlanType((int)planType)) {
            logger.error((Object)("planType:" + String.valueOf(planType) + " is invalid."));
            throw new LegoCheckedException(1073947393L);
        }
        extFilterMap.put("PLANUSE", planType);
        List<RecoveryPlan> list = this.getRecoveryPlans(orderBy, isAsc, extFilterMap);
        list = this.foreignKeyQueryFilter(userId, list, extFilterMap);
        Page page = Page.createPage((int)pageNum, (int)pageSize, (List)((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, list));
        this.fillRecoveryPlanProgress(page.getResult());
        if (!VerifyUtil.isEmpty((Collection)page.getResult())) {
            Iterator planIterator = page.getResult().iterator();
            while (planIterator.hasNext()) {
                RecoveryPlan recoveryPlan = (RecoveryPlan)planIterator.next();
                if (!VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) continue;
                logger.error((Object)("no protectGroups for plan:" + recoveryPlan.getPlanId() + " name:" + recoveryPlan.getName()));
                planIterator.remove();
            }
        }
        return page;
    }

    public Page pageQueryRecoveryLog(String planId, int pageNum, int pageSize, String orderBy, boolean isAsc) {
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)("The parameter is invalid. PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = this.isRecoveryPlanExisted(planId);
        if (!isExisted) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition1 = new QueryCondition("planId", (Object)planId);
        QueryCondition queryCondition2 = new QueryCondition("endTime", (Object)"null", 2);
        queryConditions.add(queryCondition1);
        queryConditions.add(queryCondition2);
        List criterionList = this.getBaseDao().translatePropsToCriterions(queryConditions);
        Page page = this.getBaseDao().pagedQuery(RecoveryLog.class, pageNum, pageSize, criterionList, orderBy, isAsc);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsedHostGroupByRp(String hostGroupId) {
        boolean result = false;
        Session session = null;
        try {
            Object obj;
            session = this.getHibernateSession();
            String querySQL = "select count(1) from ti_recoverysetting where NAME=:name and VALUE=:value";
            NativeQuery query = session.createSQLQuery(querySQL);
            query.setString("name", "PG_DISASTER_HOST");
            query.setString("value", hostGroupId);
            List resultTmp = query.list();
            if (null != resultTmp && !resultTmp.isEmpty() && (obj = resultTmp.get(0)) instanceof BigInteger) {
                BigInteger bi = (BigInteger)obj;
                result = bi.compareTo(BigInteger.ONE) == 0;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting RecoverySetting failed. Id:" + hostGroupId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return result;
    }

    public List<ProtectGroup> getAvailableProtectGroups(long userID, DrmEnumDefine.RECOVERY_PLAN_TYPE_E planType) {
        List<ProtectGroup> allProtectGroups = this.getAllProtectGroups(userID);
        if (null == allProtectGroups || allProtectGroups.isEmpty()) {
            logger.trace((Object)("allProtectGroups is null: " + userID));
            return new ArrayList<ProtectGroup>();
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List localSites = siteService.getAllLocalSites();
        ArrayList<ProtectGroup> availableProtectGroups = new ArrayList<ProtectGroup>();
        List<RecoveryPlan> recoveryPlans = this.queryRecoveryPlans(userID, false);
        Iterator<RecoveryPlan> iterator = recoveryPlans.iterator();
        while (iterator.hasNext()) {
            RecoveryPlan recoveryPlan = iterator.next();
            if (!Integer.valueOf(RecoveryPlanUse.INTERNAL_USE.getValue()).equals(recoveryPlan.getUse())) continue;
            iterator.remove();
        }
        for (ProtectGroup pp : allProtectGroups) {
            boolean isValid = this.isAvailableProtectGroup(pp, localSites, recoveryPlans, planType);
            if (!isValid) continue;
            availableProtectGroups.add(pp);
        }
        return availableProtectGroups;
    }

    public void syncDisableRecoveryProcessor(String planId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, String procId) {
        logger.trace((Object)("planId is: " + planId));
        this.updateRecoveryProcessorEnableStatus(planId, procType, procId, false, false);
    }

    public void syncEnableRecoveryProcessor(String planId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, String procId) {
        logger.trace((Object)("planId is: " + planId));
        this.updateRecoveryProcessorEnableStatus(planId, procType, procId, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryProcessor getRecoveryProcessor(String procId) {
        if (null == procId) {
            logger.error((Object)"The procId is null.", 90160758784001L);
            return null;
        }
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHQL = "from RecoveryProcessor rProcessor where rProcessor.procId=:procId";
            Query query = session.createQuery(queryHQL);
            query.setString("procId", procId);
            List results = query.list();
            if (null != results && !results.isEmpty()) {
                if (1 == results.size()) {
                    RecoveryProcessor processor = new RecoveryProcessor();
                    RecoveryProcessor tempProcessor = (RecoveryProcessor)results.get(0);
                    processor.setProcId(tempProcessor.getProcId());
                    tempProcessor.updateProcessName();
                    processor.setProcName(tempProcessor.getProcName());
                    processor.setPlanId(tempProcessor.getPlanId());
                    processor.setProcType(tempProcessor.getProcType());
                    RecoveryProcessor recoveryProcessor = processor;
                    return recoveryProcessor;
                }
                logger.error((Object)("The db data has problem. ProcId:" + procId), 90160758784001L);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Querying the recovery processor failed. procId:" + procId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return null;
    }

    public DrmEnumDefine.RECOVERY_PLAN_TYPE_E getSuitablePlanType(ProtectGroup protectGroup) {
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(protectGroup);
        if (null == provider) {
            throw new LegoCheckedException(1073947395L);
        }
        if (provider.isSuitableProtectGroup(DrmEnumDefine.RECOVERY_PLAN_TYPE_E.LOCAL, protectGroup)) {
            return DrmEnumDefine.RECOVERY_PLAN_TYPE_E.LOCAL;
        }
        if (provider.isSuitableProtectGroup(DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE, protectGroup)) {
            return DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE;
        }
        throw new LegoCheckedException(1073948748L);
    }

    public Page pageQueryProtectObjectInRP(String planId, int pageNum, int pageSize, String orderBy, boolean isAsc) {
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.trace((Object)"planId is null");
            return null;
        }
        RecoveryPlan plan = this.queryRecoveryPlan(planId, true);
        if (null == plan) {
            throw new LegoCheckedException(201L);
        }
        ArrayList<ProtectObjectBo> protectObjectBos = new ArrayList<ProtectObjectBo>();
        Set settings = RecoveryUtil.getRecoverySettingsByItemKey((String)planId, (String)"PG_DISASTER_HOST", (Set)plan.getRecoverySettings());
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroupServiceImpl pgServiceImpl = (ProtectGroupServiceImpl)pgService;
        Set protectGroups = plan.getProtectGroups();
        for (ProtectGroup protectGroup : protectGroups) {
            String hostOrGroupId = this.getHostOrGroupId(planId, settings, protectGroup);
            IProtectObjectProvider provider = pgServiceImpl.getProtectObjectProvider(protectGroup.getPoType());
            ArrayList<ProtectObject> protectObjList = new ArrayList<ProtectObject>();
            protectObjList.addAll(protectGroup.getPolist());
            this.resetProtectObjectProperties(protectObjList, protectGroup, plan);
            provider.refreshProtectObjectProperties(protectObjList);
            ArrayList<String> uuidList = new ArrayList<String>();
            for (ProtectObject protectObj : protectObjList) {
                uuidList.add(protectObj.getMoUuid());
            }
            Map<String, String> nameMap = RecoveryServiceUtil.getAllMoNameMap(uuidList);
            for (ProtectObject protectObj : protectObjList) {
                ProtectObjectBo protectObjectBo = this.convertToProtectObjectBo(protectObj, protectGroup.getName(), hostOrGroupId);
                protectObjectBos.add(protectObjectBo);
                String moName = nameMap.get(protectObj.getMoUuid());
                if (VerifyUtil.isEmpty((String)moName) || "--".equals(moName)) continue;
                protectObjectBo.setName(moName);
            }
        }
        Collections.sort(protectObjectBos, new CommonComparator(orderBy, isAsc));
        return Page.createPage((int)pageNum, (int)pageSize, protectObjectBos);
    }

    private String getHostOrGroupId(String planId, Set<RecoverySetting> settings, ProtectGroup protectGroup) {
        Iterator recvoerySettingIterator;
        Set hostOrGroupSettings = RecoveryUtil.getRecoverySettingsByOwnerId((String)planId, (String)protectGroup.getUuid(), settings);
        String hostOrGroupId = "--";
        if (null != hostOrGroupSettings && (recvoerySettingIterator = hostOrGroupSettings.iterator()).hasNext()) {
            hostOrGroupId = ((RecoverySetting)recvoerySettingIterator.next()).getValue();
        }
        return hostOrGroupId;
    }

    private void resetProtectObjectProperties(List<ProtectObject> protectObjects, ProtectGroup protectGroup, RecoveryPlan plan) {
        for (ProtectObject protectObj : protectObjects) {
            protectObj.setProtectGroup(protectGroup);
            Set poSettings = RecoveryUtil.getRecoverySettingsByOwnerId((String)plan.getPlanId(), (String)protectObj.getUuid(), (Set)plan.getRecoverySettings());
            HashMap<String, String> poSettingMap = new HashMap<String, String>();
            for (RecoverySetting setting : poSettings) {
                poSettingMap.put(setting.getName(), setting.getValue());
            }
            if (null == protectObj.getProps()) {
                protectObj.setProps(new HashMap());
            }
            this.dealPdbOfChange(protectObj, poSettingMap);
            protectObj.getProps().putAll(poSettingMap);
        }
    }

    private void dealPdbOfChange(ProtectObject protectObj, Map<String, String> poSettingMap) {
        if (!"1".equals(protectObj.getProps().get("IS_CDB"))) {
            return;
        }
        String protectObjPdbStr = (String)protectObj.getProps().get(PDB);
        if (VerifyUtil.isEmpty((String)protectObjPdbStr)) {
            return;
        }
        JSONArray protectPdbArray = JSONArray.fromObject((Object)protectObjPdbStr);
        String recoverySettingPdbStr = poSettingMap.get(PDB);
        if (VerifyUtil.isEmpty((String)recoverySettingPdbStr)) {
            return;
        }
        JSONArray recSettingArray = JSONArray.fromObject((Object)recoverySettingPdbStr);
        JSONArray jsonArray = new JSONArray();
        for (Object protectPdbObj : protectPdbArray) {
            JSONObject poJson = JSONObject.fromObject(protectPdbObj);
            String conId = String.valueOf(poJson.get("conID"));
            String pdbName = String.valueOf(poJson.get("pdbName"));
            if ("CDB$ROOT".equals(pdbName) || "PDB$SEED".equals(pdbName)) continue;
            for (Object recSetting : recSettingArray) {
                JSONObject recJson = JSONObject.fromObject(recSetting);
                if (!conId.equals(String.valueOf(recJson.get("conID")))) continue;
                poJson.put((Object)"isStart", (Object)String.valueOf(recJson.get("isStart")));
            }
            jsonArray.add((Object)poJson);
        }
        poSettingMap.remove(PDB);
        poSettingMap.put(PDB, jsonArray.toString());
    }

    public void updateRecoveryProcessorEnableStatus(String planId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, String procId, boolean isEnable, boolean isNeedSync) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)procId) || null == procType) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.queryRecoveryPlan(planId, false);
        if (null == recoveryPlan) {
            logger.trace((Object)("recoveryPlan is null" + planId));
            throw new LegoCheckedException(201L);
        }
        RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR);
        if (isNeedSync) {
            RecoveryServiceUtil.checkRecoveryOperationPrivilegeBySite(recoveryPlan, null);
            List<Site> remoteSites = RecoveryServiceUtil.getRemoteSites(recoveryPlan);
            if (DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE.getValue() == recoveryPlan.getPlanType()) {
                HashMap<String, Object> requestMsg = new HashMap<String, Object>();
                requestMsg.put("planId", planId);
                requestMsg.put("procType", procType);
                requestMsg.put("procId", procId);
                requestMsg.put("isEnable", isEnable);
                this.syncCRDOperationToRemote(remoteSites, requestMsg, "/ws/recoveryplans/syncUpdateRecoveryProcessorEnableStatus");
            }
        }
        Set<RecoveryProcessDefinition> processes = this.getRecoveryProcesses(planId, procType.getValue());
        this.saveOrUpdateProcessorEnableStatus(procId, isEnable, processes);
    }

    private List<RecoveryPlan> foreignKeyQueryFilter(Long userId, List<RecoveryPlan> srcRps, Map<String, Object> filterMap) {
        ArrayList<RecoveryPlan> resRps = new ArrayList<RecoveryPlan>();
        Integer appType = MapUtils.getInteger(filterMap, (Object)"appType");
        String productSiteId = MapUtils.getString(filterMap, (Object)"productSiteId");
        String protectGroupId = MapUtils.getString(filterMap, (Object)"protectGroupId");
        String createStartTime = MapUtils.getString(filterMap, (Object)"createStartTime");
        String createEndTime = MapUtils.getString(filterMap, (Object)"createEndTime");
        String replicaId = MapUtils.getString(filterMap, (Object)"replicaId");
        String mountSiteId = MapUtils.getString(filterMap, (Object)"mountSiteId");
        String mountHostId = MapUtils.getString(filterMap, (Object)"mountHostId");
        List<ProtectGroup> protectGroups = this.getAllProtectGroups(userId);
        Map<String, String> planIdPgIdMap = this.getPlanIdPgIdMap();
        Map<String, String> planIdReplcaIdMap = this.getPlanIdReplicaIdMap();
        Map<String, String> replicaIdMountConfigMap = this.getMountConfigMap();
        for (RecoveryPlan rp : srcRps) {
            String pgId = planIdPgIdMap.get(rp.getPlanId());
            ProtectGroup pg = Optional.of(protectGroups.stream().filter(protectGroup -> protectGroup.getUuid().equals(pgId)).findAny()).get().orElse(null);
            if (VerifyUtil.isEmpty((Object)pg)) {
                logger.error((Object)("plan bind pg is null. planId:" + rp.getPlanId()));
                continue;
            }
            if (!this.isConditionFilter(protectGroupId, pg.getUuid()) || !this.isConditionFilter(productSiteId, pg.getProductSiteId()) || !this.isConditionFilter(appType, pg.getPoType()) || !this.isTimeRange(createStartTime, createEndTime, rp.getCreateTime())) continue;
            this.mountConfigsFilter(resRps, rp, planIdReplcaIdMap, replicaIdMountConfigMap, replicaId, mountSiteId, mountHostId);
        }
        this.hwStackFilter(filterMap, resRps, protectGroups, planIdPgIdMap);
        return resRps;
    }

    private void hwStackFilter(Map<String, Object> filterMap, List<RecoveryPlan> resRps, List<ProtectGroup> protectGroups, Map<String, String> planIdPgIdMap) {
        String regionId = MapUtils.getString(filterMap, (Object)"regionId");
        String azId = MapUtils.getString(filterMap, (Object)"azId");
        String projectId = MapUtils.getString(filterMap, (Object)"projectId");
        String instProtectType = MapUtils.getString(filterMap, (Object)"instProtectType");
        if (!VerifyUtil.isEmptyAll((Object[])new Object[]{regionId, azId, projectId, instProtectType})) {
            Map<String, Map<String, String>> pgPropsMap = ProtectGroupUtil.getAllPgProps();
            Iterator<RecoveryPlan> iterator = resRps.iterator();
            while (iterator.hasNext()) {
                RecoveryPlan rp = iterator.next();
                String pgId = planIdPgIdMap.get(rp.getPlanId());
                ProtectGroup pg = Optional.of(protectGroups.stream().filter(protectGroup -> protectGroup.getUuid().equals(pgId)).findAny()).get().orElse(null);
                if (VerifyUtil.isEmpty((Object)pg)) {
                    logger.error((Object)("plan bind pg is null. planId:" + rp.getPlanId()));
                    continue;
                }
                if (VerifyUtil.isEmpty((Object)pg.getTemplate())) {
                    logger.error((Object)("pg template is null. pgName:" + pg.getName()));
                    continue;
                }
                if (!PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(pg.getTemplate().getType())) continue;
                Map<String, String> propMap = pgPropsMap.get(pg.getUuid());
                if (null == propMap) {
                    propMap = new HashMap<String, String>();
                }
                this.hwStackFilter(iterator, propMap, regionId, azId, projectId, instProtectType);
            }
        }
    }

    private void hwStackFilter(Iterator<RecoveryPlan> iterator, Map<String, String> propMap, String regionId, String azId, String projectId, String instProtectType) {
        if (!VerifyUtil.isEmpty((String)regionId) && !regionId.equals(RecoveryPlanServiceImpl.getIdFromOpenstackUuid(propMap.get("regionId")))) {
            iterator.remove();
        } else if (!VerifyUtil.isEmpty((String)azId) && !azId.equals(RecoveryPlanServiceImpl.getIdFromOpenstackUuid(propMap.get("zoneName")))) {
            iterator.remove();
        } else if (!VerifyUtil.isEmpty((String)projectId) && !projectId.equals(RecoveryPlanServiceImpl.getIdFromOpenstackUuid(propMap.get("projectId")))) {
            iterator.remove();
        } else if (!VerifyUtil.isEmpty((String)instProtectType)) {
            ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E filterValue = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)instProtectType);
            ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E pgValue = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)propMap.get("serviceInstanceType"));
            if (!VerifyUtil.isEmpty((Object)filterValue) && !filterValue.equals((Object)pgValue)) {
                iterator.remove();
            }
        }
    }

    public static String getIdFromOpenstackUuid(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            return null;
        }
        if (uuid.contains(SEPARATOR)) {
            uuid = uuid.split(SEPARATOR)[1];
        }
        return uuid;
    }

    private void mountConfigsFilter(List<RecoveryPlan> resRps, RecoveryPlan rp, Map<String, String> planIdReplcaIdMap, Map<String, String> replicaIdMountConfigMap, String replicaId, String mountSiteId, String mountHostId) {
        if (rp.getUse().equals(RecoveryPlan.MOUNT_PLAN)) {
            String replicaIdInRp = planIdReplcaIdMap.get(rp.getPlanId());
            if (this.isConditionFilter(replicaId, replicaIdInRp)) {
                String mountConfigs = replicaIdMountConfigMap.get(replicaIdInRp);
                if (VerifyUtil.isEmpty((String)mountConfigs)) {
                    if (mountHostId == null && mountSiteId == null) {
                        resRps.add(rp);
                    }
                    logger.error((Object)("mountConfigs is not exist. replicaId:" + replicaIdInRp));
                    return;
                }
                MountConfiguration mc = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
                String mountSiteIdInRp = mc.getSiteId();
                String mountHostIdInRp = mc.getHostOrGroupSn();
                if (this.isConditionFilter(mountHostId, mountHostIdInRp) && this.isConditionFilter(mountSiteId, mountSiteIdInRp)) {
                    HashMap<String, String> globalSetting = new HashMap<String, String>();
                    globalSetting.put("mountConfig", mountConfigs);
                    rp.setGlobalSettings(globalSetting);
                    resRps.add(rp);
                }
            }
        } else if (rp.getUse().equals(RecoveryPlan.RECOVERY_PLAN)) {
            resRps.add(rp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getPlanIdPgIdMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String strSQL = "select PLANID,PGID from ti_drp_r_pg";
            NativeQuery query = session.createSQLQuery(strSQL);
            List results = query.list();
            for (Object object : results) {
                Object[] values;
                if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
                map.put(CommUtil.convertToString((Object)values[0]), CommUtil.convertToString((Object)values[1]));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting ti_drp_r_pg failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getPlanIdReplicaIdMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Session session = null;
        try {
            map = new HashMap();
            session = this.getHibernateSession();
            String strSQL = "select PLANID,PROPVALUE from ti_rp_globalsettings where PROPNAME=:PROPNAME";
            NativeQuery query = session.createSQLQuery(strSQL);
            query.setString("PROPNAME", "REPLICA_ID");
            List results = query.list();
            for (Object object : results) {
                Object[] values;
                if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
                map.put(CommUtil.convertToString((Object)values[0]), CommUtil.convertToString((Object)values[1]));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Getting all globalsettings failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getMountConfigMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Session session = null;
        try {
            map = new HashMap();
            session = this.getHibernateSession();
            String strSQL = "select ID,PROPVALUE from ti_protectgroupreplica_prop where PROPNAME=:PROPNAME";
            NativeQuery query = session.createSQLQuery(strSQL);
            query.setString("PROPNAME", "mountConfigs");
            List results = query.list();
            for (Object object : results) {
                Object[] values;
                if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
                map.put(CommUtil.convertToString((Object)values[0]), CommUtil.convertToString((Object)values[1]));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Getting all globalsettings failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return map;
    }

    private boolean isConditionFilter(Object condition, Object tgt) {
        if (condition == null) {
            return true;
        }
        return condition.equals(tgt);
    }

    private boolean isTimeRange(String startTime, String endTime, Long createTimeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long startTimeStamp = startTime == null ? Long.MIN_VALUE : sdf.parse(startTime, new ParsePosition(0)).getTime();
        long endTimeStamp = endTime == null ? Long.MAX_VALUE : sdf.parse(endTime, new ParsePosition(0)).getTime();
        return createTimeStamp >= startTimeStamp && createTimeStamp <= endTimeStamp;
    }

    private void saveOrUpdateProcessorEnableStatus(String procId, boolean isEnable, Set<RecoveryProcessDefinition> processes) {
        if (VerifyUtil.isEmpty(processes)) {
            logger.trace((Object)("processes is null" + procId));
            throw new LegoCheckedException(1073947393L);
        }
        boolean isProcessorExist = false;
        Iterator<RecoveryProcessDefinition> iterator = processes.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition rpDefinition = iterator.next();
        for (RecoveryProcessor processor : rpDefinition.getRecoveryProcessors()) {
            if (!processor.getProcId().equals(procId)) continue;
            isProcessorExist = true;
            if (!processor.getIsEditable().booleanValue()) {
                throw new LegoCheckedException(1073948732L);
            }
            processor.setIsEnabled(Boolean.valueOf(isEnable));
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)processor);
            MessageEvent event = MessageEvent.createMessageEvent((int)1, (Object[])new Object[]{rpDefinition, processor});
            this.notifyListener(event);
            break;
        }
        if (!isProcessorExist) {
            throw new LegoCheckedException(201L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProtectGroup> getAllProtectGroups(long userID) {
        List<Object> allProtectGrops = new ArrayList();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySQL = "select pg.PGID, pg.UUID as pguuid, pg.PRODUCTSITEID, st.siteName, pg.PGNAME, pg.POTYPE, pt.TYPE, pt.SUBTYPE, pg.ISPRIMARY, pg.STATUS, pt.UUID as ptuuid, pt.NAME, pt.DESCRIPTION, pg.PGPROVIDERSN from ti_protectgroup pg, ti_site st, ti_policytemplate pt where pg.PTID = pt.PTID and pg.PRODUCTSITEID = st.siteId";
            NativeQuery query = session.createSQLQuery(querySQL);
            List result = query.list();
            if (!VerifyUtil.isEmpty((Collection)result)) {
                allProtectGrops = this.constructProtectGroups(result);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting all protect groups failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(Long.valueOf(userID), allProtectGrops);
    }

    private boolean isAvailableProtectGroup(ProtectGroup protectGroup, List<Site> localSites, List<RecoveryPlan> recoveryPlans, DrmEnumDefine.RECOVERY_PLAN_TYPE_E planType) {
        if (DrmEnumDefine.RECOVERY_PLAN_TYPE_E.LOCAL.equals((Object)planType) && !RecoveryServiceUtil.isContainSite(localSites, protectGroup.getProductSiteId())) {
            return false;
        }
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(protectGroup);
        if (null == provider) {
            logger.trace((Object)"provider is null");
            return false;
        }
        boolean isSuitableProtectGroup = provider.isSuitableProtectGroup(planType, protectGroup);
        if (!isSuitableProtectGroup) {
            return false;
        }
        boolean isPlanIncludedPg = this.isUsedProtectGroup(recoveryPlans, protectGroup);
        return !isPlanIncludedPg && !protectGroup.isInvalid();
    }

    private boolean isUsedProtectGroup(List<RecoveryPlan> recoveryPlans, ProtectGroup protectGroup) {
        if (null == recoveryPlans || recoveryPlans.isEmpty()) {
            logger.trace((Object)"recoveryPlans is null");
            return false;
        }
        for (RecoveryPlan recoveryPlan : recoveryPlans) {
            Set usedProtectGroups = recoveryPlan.getProtectGroups();
            for (ProtectGroup usedProtectGroup : usedProtectGroups) {
                if (!usedProtectGroup.getUuid().equals(protectGroup.getUuid())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryLog getRecoveryLog(String recoveryPlanId, String queryHQL) {
        RecoveryLog recoveryLog = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            Query query = session.createQuery(queryHQL);
            query.setString("planId", recoveryPlanId);
            List recoveryLogs = query.list();
            if (null != recoveryLogs && !recoveryLogs.isEmpty()) {
                recoveryLog = (RecoveryLog)recoveryLogs.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery logs failed. Id:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryLog;
    }

    private ProtectObjectBo convertToProtectObjectBo(ProtectObject protectObject, String pgName, String standbyHostIp) {
        ProtectObjectBo protectObjectBo = new ProtectObjectBo();
        ObjectConvert.convert((Object)protectObject, (Object)protectObjectBo);
        logger.trace((Object)("pgName is:" + pgName));
        protectObjectBo.setPgName(pgName);
        protectObjectBo.setStandbyHostIp(standbyHostIp);
        return protectObjectBo;
    }

    private void getRecoverySetting(RecoveryPlan recoveryPlan, Session session) {
        if (null == recoveryPlan || null == session) {
            logger.trace((Object)"param is null");
            return;
        }
        String queryHQL = "from RecoverySetting rs where rs.recoveryPlan.planId=:planId";
        Query query = session.createQuery(queryHQL);
        query.setString("planId", recoveryPlan.getPlanId());
        List recoverySettings = query.list();
        HashSet<RecoverySetting> settings = new HashSet<RecoverySetting>();
        if (null != recoverySettings && !recoverySettings.isEmpty()) {
            for (Object obj : recoverySettings) {
                settings.add((RecoverySetting)obj);
            }
        }
        recoveryPlan.setRecoverySettings(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryPlan getRecoveryPlan(String recoveryPlanId, boolean isQueryRP, boolean isQueryPoRep) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return null;
        }
        RecoveryPlan recoveryPlan = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHQL = "from RecoveryPlan rp where rp.planId=:planId";
            Query query = session.createQuery(queryHQL);
            query.setString("planId", recoveryPlanId);
            List recoveryPlans = query.list();
            if (null != recoveryPlans && !recoveryPlans.isEmpty()) {
                recoveryPlan = (RecoveryPlan)recoveryPlans.get(0);
                Set protectGroups = recoveryPlan.getProtectGroups();
                if (!VerifyUtil.isEmpty((Collection)protectGroups) && isQueryPoRep) {
                    this.loadPoReplica(protectGroups);
                }
                this.getRecoverySetting(recoveryPlan, session);
                if (isQueryRP) {
                    Set<RecoveryProcessDefinition> processes = this.getRecoveryProcesses(recoveryPlan.getPlanId(), null, session);
                    recoveryPlan.setRecoveryProcesses(processes);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery plan failed. Id:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryPlan;
    }

    public RecoveryPlan getRecoveryPlan(String recoveryPlanId, boolean isQueryRP) {
        return this.getRecoveryPlan(recoveryPlanId, isQueryRP, true);
    }

    private void loadPoReplica(Set<ProtectGroup> protectGroups) {
        for (ProtectGroup pg : protectGroups) {
            Set replicaList = pg.getReplicaList();
            if (VerifyUtil.isEmpty((Collection)replicaList)) continue;
            for (ProtectGroupReplica pgReplica : replicaList) {
                Hibernate.initialize((Object)pgReplica.getReplicas());
            }
        }
    }

    private List<RecoveryPlan> filterAppTypeCondition(List<RecoveryPlan> allRps, String appType) {
        ArrayList<RecoveryPlan> matchedRps = new ArrayList<RecoveryPlan>();
        for (RecoveryPlan rp : allRps) {
            Set<ProtectGroup> pgs = this.getProtectGroupsByPlanId(rp.getPlanId(), false);
            ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement(pgs);
            if (VerifyUtil.isEmpty((Object)pg) || NumberUtil.convertToInteger((Object)appType).intValue() != pg.getPoType()) continue;
            matchedRps.add(rp);
        }
        return matchedRps;
    }

    private void fillRecoveryPlanProgress(List<?> recoveryPlans) {
        if (VerifyUtil.isEmpty(recoveryPlans)) {
            logger.trace((Object)"recoveryPlans is null");
            return;
        }
        Map<Site, List<String>> siteAndPlansMap = this.constructSiteAndPlansMap(recoveryPlans);
        Map<String, Map<String, Object>> planProgressMap = this.queryRecoveryProgressFromRemote(siteAndPlansMap);
        if (VerifyUtil.isEmpty(planProgressMap)) {
            return;
        }
        for (Object obj : recoveryPlans) {
            Map<String, Object> planInfos;
            RecoveryPlan plan = (RecoveryPlan)obj;
            if (plan.getPlanProgress() > 0 || VerifyUtil.isEmpty(planInfos = planProgressMap.get(plan.getPlanId()))) continue;
            Object planProgress = planInfos.get("planProgress");
            Object planStatus = planInfos.get("planStatus");
            if (null != planProgress) {
                plan.setPlanProgress(((Integer)planProgress).intValue());
            }
            if (null == planStatus) continue;
            plan.setPlanStatus(((Integer)planStatus).intValue());
        }
    }

    private Map<Site, List<String>> constructSiteAndPlansMap(List<?> recoveryPlans) {
        HashMap<Site, List<String>> siteAndPlansMap = new HashMap<Site, List<String>>();
        for (Object object : recoveryPlans) {
            ArrayList<String> planIds;
            RecoveryPlan plan = (RecoveryPlan)object;
            logger.trace((Object)("recoveryPlans is: " + plan.getPlanId()));
            plan.setProtectGroups(this.getProtectGroupsByPlanId(plan.getPlanId(), false));
            plan.setGlobalSettings(this.getRecoveryGlobalSettings(plan.getPlanId()));
            Site remoteDisasterSite = RecoveryServiceUtil.getRemoteDisasterSite(plan);
            if (null == remoteDisasterSite) {
                String isReconfigSuccess = (String)plan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
                if (!String.valueOf(DrmEnumDefine.RECOVERY_EXTEND_ATTRIBUTES.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(isReconfigSuccess)) continue;
                ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
                String productSiteId = RecoveryServiceUtil.getProductSiteId(plan);
                remoteDisasterSite = siteService.getSiteById(productSiteId);
            }
            if (null == (planIds = (ArrayList<String>)siteAndPlansMap.get(remoteDisasterSite))) {
                planIds = new ArrayList<String>();
                siteAndPlansMap.put(remoteDisasterSite, planIds);
            }
            planIds.add(plan.getPlanId());
        }
        return siteAndPlansMap;
    }

    private Map<String, Map<String, Object>> queryRecoveryProgressFromRemote(Map<Site, List<String>> siteAndPlansMap) {
        HashMap<String, Map<String, Object>> planProgressMap = new HashMap<String, Map<String, Object>>();
        Set<Map.Entry<Site, List<String>>> entrySet = siteAndPlansMap.entrySet();
        for (Map.Entry<Site, List<String>> entry : entrySet) {
            Site remoteSite = entry.getKey();
            List<String> planIds = entry.getValue();
            if (0 == remoteSite.getSiteType()) continue;
            try {
                RestClient client = SiteUtil.initClient(remoteSite);
                Map result = (Map)client.postSerializableObj(planIds, "/ws/recoveryplans/getRecoveryPlanProgress", Map.class);
                if (VerifyUtil.isEmpty((Map)result)) continue;
                Set set = result.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry obj;
                    Map.Entry planAndProgressEntry = obj = iterator.next();
                    Map planInfos = (Map)planAndProgressEntry.getValue();
                    String planId = String.valueOf(planAndProgressEntry.getKey());
                    Integer progress = Integer.valueOf(String.valueOf(planInfos.get("planProgress")));
                    Integer status = Integer.valueOf(String.valueOf(planInfos.get("planStatus")));
                    HashMap<String, Integer> infos = new HashMap<String, Integer>();
                    infos.put("planProgress", progress);
                    infos.put("planStatus", status);
                    planProgressMap.put(planId, infos);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Getting plan progress failed. SiteName:" + remoteSite.getName() + ",Ip:" + remoteSite.getSiteId() + ",PlanIds:" + planIds.toString()), 90160758784001L);
            }
        }
        return planProgressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBackRunningRecoveryTaskNum() {
        int count = 0;
        Session session = null;
        try {
            Object obj;
            session = this.getHibernateSession();
            StringBuffer querySQL = new StringBuffer();
            querySQL.append("select count(*) from ti_recoveryplan where PLANSTATUS in (");
            querySQL.append(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING.getValue() + ",");
            querySQL.append(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING.getValue() + ",");
            querySQL.append(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING.getValue() + ",");
            querySQL.append(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING.getValue() + ",");
            querySQL.append(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING.getValue() + ",");
            querySQL.append(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING.getValue());
            querySQL.append(')');
            NativeQuery query = session.createSQLQuery(querySQL.toString());
            List recoveryPlans = query.list();
            if (null != recoveryPlans && !recoveryPlans.isEmpty() && (obj = recoveryPlans.get(0)) instanceof BigInteger) {
                count = ((BigInteger)obj).intValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Checking back recovery task count failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return count;
    }

    private boolean isNeedQueryFromDisaster(String productSiteId, String disasterSiteId) {
        if (VerifyUtil.isEmpty((String)productSiteId) || VerifyUtil.isEmpty((String)disasterSiteId)) {
            logger.trace((Object)"param is null");
            return false;
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site disasterSite = siteService.getSiteById(disasterSiteId);
        Site productSite = siteService.getSiteById(productSiteId);
        List localSites = siteService.getAllLocalSites();
        return localSites.contains(productSite) && !localSites.contains(disasterSite);
    }

    private void notifyListener(MessageEvent event) {
        this.listeners.forEach(listener -> listener.notify(event));
    }
}

