/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CreateRecoveryPlanBackTask
extends AbstractBackTask {
    private Set<ProtectGroup> protectGroups;
    private String recoveryPlanName;
    private long userId;

    public CreateRecoveryPlanBackTask(long userId, String recoveryPlanName, Set<ProtectGroup> protectGroups) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)recoveryPlanName, (String)"ism.drm.recovery.createrecoveryplan.task.name", (String)"System", (String)"", null), true);
        this.userId = userId;
        this.recoveryPlanName = recoveryPlanName;
        this.protectGroups = protectGroups;
    }

    protected void doWork() {
        if (VerifyUtil.isEmpty(this.protectGroups)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.constructRecoveryPlanEntity(this.recoveryPlanName);
        recoveryPlan.setProtectGroups(this.protectGroups);
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        Iterator<ProtectGroup> iterator = this.protectGroups.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = iterator.next();
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        licenseControl.checkEnablePgCount(protectGroup);
        recoveryPlan.setPlanType(planService.getSuitablePlanType(protectGroup).getValue());
        planService.createRecoveryPlan(this.userId, recoveryPlan);
    }

    private RecoveryPlan constructRecoveryPlanEntity(String planName) {
        RecoveryPlan recoveryPlan = new RecoveryPlan();
        recoveryPlan.setName(planName);
        recoveryPlan.setRecoverySettings(new HashSet());
        recoveryPlan.setGlobalSettings(new HashMap());
        return recoveryPlan;
    }
}

