/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.manager;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.protection.checker.manager.AbRateConfigBaseService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.service.IRateConfigService;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;

@ServiceBoundInfo(methodName="onBind", targetBeanName="rateConfigServiceMgr", properties="type:0##3_1##5_1")
public class RateConfigByPosiServiceImpl
extends AbRateConfigBaseService
implements IRateConfigService {
    private static Log logger = LogFactory.getInstance(RateConfigByPosiServiceImpl.class);

    public void modifyRate(DmEnumDefine.SPEED_LEVEL_E speedLevel, ProtectGroup pg, int protectionLocation) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)"pg or protectionLocation is empty");
            throw new LegoCheckedException(1073947393L);
        }
        int times1 = 0;
        while (true) {
            if (times1 >= 3) {
                AlarmReporter.sendAlarm(52625438L, pg.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.MINOR, pg.getUuid(), pg.getName());
                break;
            }
            try {
                this.syncRateByReplicationPair(speedLevel, pg);
                AlarmReporter.restoreAlarm(52625438L, pg.getUuid(), pg.getName());
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("cannot alter ArrayRate..." + pg.getName()), e.getErrorCode());
                ++times1;
                CommonUtil.sleep((long)60000L);
                continue;
            }
            break;
        }
    }

    private void syncRateByReplicationPair(DmEnumDefine.SPEED_LEVEL_E speedLevel, ProtectGroup pg) {
    }
}

