/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.manager;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.protection.checker.manager.AbRateConfigBaseService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.service.IRateConfigService;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;

@ServiceBoundInfo(methodName="onBind", targetBeanName="rateConfigServiceMgr", properties="type:1##3##4##5##6##18##20##23##24##30##31##32##33##35##36")
public class RateConfigByReplicaServiceImpl
extends AbRateConfigBaseService
implements IRateConfigService {
    private static Log logger = LogFactory.getInstance(RateConfigByReplicaServiceImpl.class);

    public void modifyRate(DmEnumDefine.SPEED_LEVEL_E speedLevel, ProtectGroup pg, int protectionLocation) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)"pg or protectionLocation is empty");
            throw new LegoCheckedException(1073947393L);
        }
        int times2 = 0;
        while (true) {
            if (times2 >= 3) {
                AlarmReporter.sendAlarm(52625438L, pg.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.MINOR, pg.getUuid(), pg.getName());
                break;
            }
            try {
                this.syncRateByReplicationRelationBo(speedLevel, pg, protectionLocation);
                AlarmReporter.restoreAlarm(52625438L, pg.getUuid(), pg.getName());
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"cannot alter ArrayRate...", (Throwable)e);
                ++times2;
                CommonUtil.sleep((long)60000L);
                continue;
            }
            break;
        }
    }

    private void syncRateByReplicationRelationBo(DmEnumDefine.SPEED_LEVEL_E speedLevel, ProtectGroup pg, int protectionLocation) {
    }
}

