/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.OppoField;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.action.service.IProtectAction;
import com.huawei.ism.drm.protection.framework.engine.bean.SnapShotAssociateProtectObject;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractBaseProtectAction
implements IProtectAction,
Cloneable {
    protected static final long MAX_TIME_OUT = 0x6DDD00L;
    private static final String IGNORE_FAILURE = "Frame_Action_Ignore_Failure";
    private static Log logger = LogFactory.getInstance(AbstractBaseProtectAction.class);
    @OppoField(fieldName="actionId")
    private String actionId = UUIDGenerator.getUUID();
    @OppoField(fieldName="protectGroupId")
    private String protectGroupId;
    @OppoField(fieldName="actionType")
    private String actionType = "Ordinary";
    @OppoField(fieldName="protectLocation", fieldType=int.class)
    private int protectLocation;
    @OppoField(fieldName="editable", fieldType=boolean.class)
    private boolean editable = false;
    @OppoField(fieldName="enable", fieldType=boolean.class)
    private boolean enable = true;
    @OppoField(fieldName="preAction")
    private String preAction;
    @OppoField(fieldName="nextAction")
    private String nextAction;
    @OppoField(fieldName="params", fieldType=Map.class)
    private Map<String, String> params = new HashMap<String, String>();
    @OppoField(fieldName="name")
    private String name;
    @OppoField(fieldName="nameParams")
    private String nameParams = "";
    @OppoField(fieldName="detail")
    private String detail = "--";
    @OppoField(fieldName="detailParams")
    private String detailParams = "";
    @OppoField(fieldName="protectedType", fieldType=Integer.class)
    private Integer protectedType;

    protected Set<ProtectObject> combineProtectObjectByType(Set<ProtectObject> poSet, ProtectGroup pg) {
        if (null == poSet || poSet.isEmpty()) {
            return new HashSet<ProtectObject>();
        }
        int poType = pg.getPoType();
        IApplicationManager appManager = ApplicationAdapterProxy.getInstance().getAppManager(poType);
        if (appManager == null) {
            logger.error((Object)("appManager is null.poType:" + poType));
            throw new LegoCheckedException(1073947394L);
        }
        return appManager.combineProtectObject(poSet);
    }

    public void preExcute(ActionContext context) {
        logger.trace((Object)"preExcute");
    }

    public abstract boolean doExecute(ActionContext var1);

    public void postExcute(ActionContext context) {
        logger.trace((Object)"postExcute");
    }

    public void callBack(ActionContext context) {
        logger.trace((Object)"callBack");
    }

    protected List<ReplicationRelationBo> getReplicationRelationBos(ActionContext context) {
        logger.trace((Object)"getReplicationRelationBos");
        Set poReplicas = (Set)context.getObject("PO_REPLICA_ENTITY");
        if (VerifyUtil.isEmpty((Collection)poReplicas)) {
            logger.error((Object)"poReplicas is empty.");
            return null;
        }
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(pg.getTemplate().getType())) {
            return this.getReplicationRelationBosFromPg(context);
        }
        List<ReplicationRelationBo> rrbs = this.getReplicationRelationBos(context, poReplicas);
        context.addObject("PO_GROUP_MAP", rrbs);
        return rrbs;
    }

    protected List<ReplicationRelationBo> getReplicationRelationBos(ActionContext context, Set<ProtectObjectReplica> poReplicas) {
        logger.trace((Object)"getReplicationRelationBos");
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        List rrbs = pg.getReplicationRelationBos(poReplicas);
        return rrbs;
    }

    protected ProtectGroupLogDetail initActionLog(ActionContext context, ProtectGroupLog historyLog) {
        logger.trace((Object)"initActionLog");
        Date startTime = new Date();
        ProtectGroupLogDetail historyDetailLog = ProtectionJobUtil.getInstance().createActionLog("", this.getName(), startTime);
        historyLog.getPgHistoryLogDetails().add(historyDetailLog);
        historyDetailLog.setLogId(historyLog.getHistoryLogId());
        return historyDetailLog;
    }

    public boolean isAppConsistent(ActionContext context) {
        Schedule schedule = this.getSchedule(context);
        if (null == schedule) {
            logger.warn((Object)"Protetion task schedule is null");
            return false;
        }
        Boolean isAppConsistent = schedule.isAppConsistent();
        logger.debug((Object)("App Consistent is " + isAppConsistent));
        return null == isAppConsistent ? false : isAppConsistent;
    }

    public Object clone() throws CloneNotSupportedException {
        logger.trace((Object)"clone");
        Object obj = super.clone();
        if (null != obj) {
            AbstractBaseProtectAction action = (AbstractBaseProtectAction)obj;
            action.setActionId(UUIDGenerator.getUUID());
            action.setParams(new ConcurrentHashMap<String, String>(this.params));
        }
        return obj;
    }

    public String getActionId() {
        logger.trace((Object)"getActionId");
        return this.actionId;
    }

    public void setActionId(String actionId) {
        logger.trace((Object)"setActionId");
        this.actionId = actionId;
    }

    public boolean equals(Object paramObject) {
        logger.trace((Object)"equals");
        if (null == paramObject) {
            return false;
        }
        if (paramObject instanceof AbstractBaseProtectAction) {
            AbstractBaseProtectAction action = (AbstractBaseProtectAction)paramObject;
            return action.getActionId().equals(this.actionId);
        }
        return false;
    }

    public int hashCode() {
        logger.trace((Object)"hashCode");
        return this.actionId.hashCode();
    }

    public final boolean execute(ActionContext context) {
        logger.trace((Object)"execute");
        if (this.enable) {
            return this.doExecute(context);
        }
        return true;
    }

    public Schedule getSchedule(ActionContext context) {
        ProtectionTask task = (ProtectionTask)context.getObject("TASK_ENTITY", ProtectionTask.class);
        if (null == task) {
            logger.warn((Object)"Cannot get protection task from actionContext by key:TASK_ENTITY");
            return null;
        }
        return task.getSchedule();
    }

    protected int getResult(boolean flag) {
        logger.trace((Object)"getResult");
        if (flag) {
            return 1;
        }
        return 0;
    }

    public final String constructParams(String[] param) {
        if (null == param) {
            logger.debug((Object)"param in empty");
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < param.length; ++i) {
            buf.append(param[i]);
            if (i >= param.length - 1) continue;
            buf.append(';');
        }
        return buf.toString();
    }

    public void checkParams(Map<String, String> param) {
        logger.trace((Object)"checkParams");
    }

    public String getProtectGroupId() {
        logger.trace((Object)"getProtectGroupId");
        return this.protectGroupId;
    }

    public void setProtectGroupId(String protectGroupId) {
        logger.trace((Object)"setProtectGroupId");
        this.protectGroupId = protectGroupId;
    }

    public String getActionType() {
        logger.trace((Object)"getActionType");
        return this.actionType;
    }

    public void setActionType(String actionType) {
        logger.trace((Object)"setActionType");
        this.actionType = actionType;
    }

    public int getProtectLocation() {
        logger.trace((Object)"getProtectLocation");
        return this.protectLocation;
    }

    public void setProtectLocation(int protectLocation) {
        logger.trace((Object)"setProtectLocation");
        this.protectLocation = protectLocation;
    }

    public boolean isEditable() {
        logger.trace((Object)"isEditable");
        return this.editable;
    }

    public void setEditable(boolean editable) {
        logger.trace((Object)"setEditable");
        this.editable = editable;
    }

    public String getPreAction() {
        logger.trace((Object)"getPreAction");
        return this.preAction;
    }

    public void setPreAction(String preAction) {
        logger.trace((Object)"setPreAction");
        this.preAction = preAction;
    }

    public String getNextAction() {
        logger.trace((Object)"getNextAction");
        return this.nextAction;
    }

    public void setNextAction(String nextAction) {
        logger.trace((Object)"setNextAction");
        this.nextAction = nextAction;
    }

    public String getName() {
        return VerifyUtil.isEmpty((String)this.name) ? this.getClass().getName() : this.name;
    }

    public String getNameParams() {
        logger.trace((Object)"getNameParams");
        return this.nameParams;
    }

    public String getDetail() {
        logger.trace((Object)"getDetail");
        return VerifyUtil.isEmpty((String)this.detail) ? "--" : this.detail;
    }

    public void setDetail(String detail) {
        logger.trace((Object)"setDetail");
        this.detail = detail;
    }

    public String getDetailParams() {
        logger.trace((Object)"getDetailParams");
        return this.detailParams;
    }

    public void setDetailParams(String detailParams) {
        logger.trace((Object)"setDetailParams");
        this.detailParams = detailParams;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Map<String, String> getParams() {
        logger.trace((Object)"getParams");
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        logger.trace((Object)"setParams");
        this.params = params;
    }

    public void setName(String name) {
        logger.trace((Object)"setName");
        this.name = name;
    }

    public void setNameParams(String nameParams) {
        logger.trace((Object)"setNameParams");
        this.nameParams = nameParams;
    }

    public Integer getProtectedType() {
        return this.protectedType;
    }

    public void setProtectedType(Integer protectedType) {
        this.protectedType = protectedType;
    }

    private int detectLunExecutionProgress(ReplicationTargetLun target) {
        if (null == target) {
            logger.warn((Object)"Current lun object is null, set progress is 100.", 1073948462L);
            return 0;
        }
        Integer pairStatus = target.getPairStatus();
        logger.debug((Object)("Lun(" + target.getName() + ") pair status is " + pairStatus + ", and progress is " + target.getProgressRatio()), 90160758786876L);
        if (null == pairStatus) {
            logger.warn((Object)("Retrieve lun pair status is null, lun -> " + target.getName()), 1073948462L);
            return 100;
        }
        Integer progress = target.getProgressRatio();
        if (null == progress) {
            logger.warn((Object)("Retrieve lun progress ratio is null, lun -> " + target.getName()), 1073948462L);
            return 100;
        }
        return progress;
    }

    public void setIgnoreFailure(Boolean ingoreFailue) {
        this.params.put(IGNORE_FAILURE, String.valueOf(ingoreFailue));
    }

    public Boolean getIngoreFailure() {
        String ignoreFailureStr = this.params.get(IGNORE_FAILURE);
        logger.debug((Object)("ignoreFailureStr" + ignoreFailureStr));
        if (VerifyUtil.isEmpty((String)ignoreFailureStr)) {
            return false;
        }
        return Boolean.valueOf(ignoreFailureStr);
    }

    protected final String getRecoverSiteIdBySchedule(int location, ProtectGroup pg) {
        String result = "";
        for (Schedule schedule : pg.getTemplate().getSchedules()) {
            String targetSiteId = schedule.getTargetSiteId();
            if (schedule.getProtectLocation() != location || VerifyUtil.isEmpty((String)targetSiteId)) continue;
            return targetSiteId;
        }
        return result;
    }

    protected final boolean isNeedSnpshot(ProtectGroup protectGroup) {
        JSONObject prJsonObj;
        PolicyTemplate template = protectGroup.getTemplate();
        String cloneSplitCofig = (String)template.getProps().get("CLONE_SPLIT");
        String createSnap = "";
        if (null != cloneSplitCofig && !cloneSplitCofig.isEmpty() && (prJsonObj = JSONObject.fromObject((Object)cloneSplitCofig)).containsKey((Object)"create_snap")) {
            createSnap = prJsonObj.getString("create_snap");
        }
        return Boolean.valueOf(createSnap);
    }

    private List<ReplicationRelationBo> getReplicationRelationBosFromPg(ActionContext context) {
        logger.trace((Object)"getReplicationRelationBos");
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        Set protectGroupReplicas = pg.getReplicaList();
        HashSet<ProtectObjectReplica> poReplicas = new HashSet<ProtectObjectReplica>();
        if (!VerifyUtil.isEmpty((Collection)protectGroupReplicas)) {
            for (ProtectGroupReplica replica : protectGroupReplicas) {
                if (ProtectGroupUtil.isLocalStorageReplica(replica)) continue;
                poReplicas.addAll(replica.getReplicas());
            }
        }
        List<ReplicationRelationBo> rrbs = this.getReplicationRelationBos(context, poReplicas);
        return rrbs;
    }

    protected void setBackScriptParams(ActionContext context, Map<String, String> scriptParams, String key) {
        JSONObject scriptJsonParams = JSONObject.fromObject((Object)scriptParams.get(key));
        SnapShotAssociateProtectObject apo = (SnapShotAssociateProtectObject)context.getObject("PO_GROUP_MAP");
        Map<String, String> snapshotInfo = apo.getSnapshotInfo();
        StringBuilder srcLunIds = new StringBuilder();
        StringBuilder snapshotIds = new StringBuilder();
        StringBuilder srcLunWwns = new StringBuilder();
        if (!VerifyUtil.isEmpty(snapshotInfo)) {
            for (Map.Entry<String, String> info : snapshotInfo.entrySet()) {
                srcLunIds.append(info.getKey() + ",");
                snapshotIds.append(info.getValue() + ",");
            }
            if (!VerifyUtil.isEmpty((Object)srcLunIds)) {
                srcLunIds.setLength(srcLunIds.length() - 1);
            }
            if (!VerifyUtil.isEmpty((Object)snapshotIds)) {
                snapshotIds.setLength(snapshotIds.length() - 1);
            }
        }
        String srcProviderSn = apo.getSrcStorageProviderSN();
        List<ProtectObjectStorageInfo> allProtectObjectStorageInfo = this.getAllProtectObjectStorageInfo(context);
        if (!VerifyUtil.isEmpty((Object)srcLunIds) && !VerifyUtil.isEmpty(allProtectObjectStorageInfo)) {
            String[] srcLunIdArr;
            for (String lunId : srcLunIdArr = srcLunIds.toString().split(",")) {
                for (ProtectObjectStorageInfo protectObjectStorageInfo : allProtectObjectStorageInfo) {
                    if (!lunId.equals(protectObjectStorageInfo.getResourceId())) continue;
                    srcLunWwns.append(protectObjectStorageInfo.getLunWWN() + ",");
                }
            }
        }
        if (!VerifyUtil.isEmpty((Object)srcLunWwns)) {
            srcLunWwns.setLength(srcLunWwns.length() - 1);
        }
        scriptJsonParams.put((Object)"SrcLunIds", (Object)srcLunIds.toString());
        scriptJsonParams.put((Object)"SnapshotIds", (Object)snapshotIds.toString());
        scriptJsonParams.put((Object)"SrcLunWWNs", (Object)srcLunWwns.toString());
        scriptJsonParams.put((Object)"SrcProviderSN", (Object)srcProviderSn);
        scriptParams.put(key, scriptJsonParams.toString());
    }

    protected List<ProtectObjectStorageInfo> getAllProtectObjectStorageInfo(ActionContext context) {
        ArrayList<ProtectObjectStorageInfo> protectObjectStorageInfoList = new ArrayList<ProtectObjectStorageInfo>();
        Set pos = (Set)context.getObject("PO_ENTITY");
        for (ProtectObject po : pos) {
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo protectObjectStorageInfo : usedStorageResourceSet) {
                protectObjectStorageInfoList.add(protectObjectStorageInfo);
            }
        }
        return protectObjectStorageInfoList;
    }

    protected void setTimeStamp(ActionContext context) {
        Map map = (Map)context.getObject("EXCUTE_PARAMETER_MAP");
        String timeStamp = null;
        if (null != map) {
            timeStamp = (String)map.get("REPLICA_TIMESTANP");
        }
        context.addObject("REPLICA_TIMESTANP", (Object)(VerifyUtil.isEmpty(timeStamp) ? String.valueOf(new Date().getTime()) : timeStamp));
    }

    static class ReplicationProgress {
        private boolean completed;
        private Integer progress;

        ReplicationProgress() {
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public ReplicationProgress setCompleted(boolean isCompletedParam) {
            this.completed = isCompletedParam;
            return this;
        }

        public Integer getProgress() {
            return this.progress;
        }

        public ReplicationProgress setProgress(Integer progressParam) {
            this.progress = progressParam;
            return this;
        }
    }
}

