/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.executor;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.executor.FixedProtectionThreadPool;
import com.huawei.ism.drm.protection.framework.engine.executor.ProtectionExecutor;
import com.huawei.ism.drm.protection.framework.engine.executor.ProtectionExecutorCallable;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionLogManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ProtectionConcurrentExecutor
extends ProtectionExecutor {
    private static final Log logger = LogFactory.getInstance(ProtectionConcurrentExecutor.class);
    private List<AbstractBaseProtectAction> protectActions = new ArrayList<AbstractBaseProtectAction>();
    private CountDownLatch completedSignal;
    private String actionId;
    private String pgId;
    private boolean isNeedAllActionSuccessed;

    private ProtectionConcurrentExecutor() {
    }

    private static ProtectionConcurrentExecutor createExecutor(List<? extends AbstractBaseProtectAction> actions, String pgId, String actionId, boolean isNeedAllActionSuccessed) {
        if (VerifyUtil.isEmpty(actions)) {
            logger.error((Object)"Actions is empty.", 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        ProtectionConcurrentExecutor executor = new ProtectionConcurrentExecutor();
        executor.protectActions.addAll(actions);
        executor.actionId = actionId;
        executor.pgId = pgId;
        executor.isNeedAllActionSuccessed = isNeedAllActionSuccessed;
        return executor;
    }

    public static ProtectionConcurrentExecutor createExecutor(List<? extends AbstractBaseProtectAction> actions, String pgId, String actionId) {
        return ProtectionConcurrentExecutor.createExecutor(actions, pgId, actionId, true);
    }

    private boolean waitAllProcessorComplete() {
        try {
            boolean inTime = this.completedSignal.await(1L, TimeUnit.DAYS);
            if (!inTime) {
                logger.error((Object)"WaitAllProcessorComplete overTime.", 90160758784001L);
            }
            return inTime;
        }
        catch (InterruptedException e) {
            logger.error((Object)"WaitAllProcessorComplete failed.", (Throwable)e, 90160758784001L);
            return false;
        }
    }

    private boolean calcProcessResult(List<Future<Boolean>> results, ProtectGroupLogDetail historyDetailLog) {
        if (!this.waitAllProcessorComplete()) {
            historyDetailLog.setInfo("lego.err.1073947433");
            return false;
        }
        boolean actionResult = true;
        for (Future<Boolean> result : results) {
            boolean tempResult = this.getProcessResult(result);
            if (!this.isNeedAllActionSuccessed || tempResult) continue;
            actionResult = false;
            break;
        }
        return actionResult;
    }

    private boolean getProcessResult(Future<Boolean> result) {
        Boolean actionResult;
        try {
            actionResult = result.get();
        }
        catch (Exception e) {
            logger.error((Object)("Getting result failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            actionResult = false;
        }
        return actionResult;
    }

    @Override
    public boolean execute(ActionContext context) {
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
        ProtectGroupLogDetail historyDetailLog = ProtectActionLogManager.getInstance().getActionLogDetail(this.pgId, this.actionId);
        if (historyDetailLog == null) {
            logger.error((Object)"historyDetailLog is null");
            throw new LegoCheckedException(1073947394L);
        }
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        ProtectionConcurrentExecutor.getActionmanager().initActions(this.protectActions, protectGroup, context, 0);
        this.completedSignal = new CountDownLatch(ProtectionConcurrentExecutor.getActionSize(this.protectActions));
        ProtectionConcurrentExecutor.getLogmanager().initRunningChildDetail(((ProtectGroupLog)context.getObject("PG_LOG_ENTITY")).getHistoryLogId(), historyDetailLog, this.protectActions, true);
        for (AbstractBaseProtectAction action : this.protectActions) {
            if (null == action || !action.isEnable()) continue;
            ProtectionExecutorCallable actionCallable = new ProtectionExecutorCallable(action, context, this.completedSignal, this.getSpecificChildDetail(historyDetailLog, action.getActionId()));
            Future<Boolean> result = FixedProtectionThreadPool.submit(actionCallable);
            results.add(result);
        }
        return this.calcProcessResult(results, historyDetailLog);
    }

    private static int getActionSize(List<? extends AbstractBaseProtectAction> actions) {
        int num = 0;
        for (AbstractBaseProtectAction abstractBaseProtectAction : actions) {
            if (abstractBaseProtectAction == null || !abstractBaseProtectAction.isEnable()) continue;
            ++num;
        }
        return num;
    }
}

