/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.executor;

import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.executor.FixedProtectionThreadPool;
import com.huawei.ism.drm.protection.framework.engine.executor.ProtectionActionMonitorCallable;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionLogManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ProtectionExecutorCallable
implements Callable<Boolean> {
    private static final Log logger = LogFactory.getInstance(ProtectionExecutorCallable.class);
    private ActionContext context;
    private AbstractBaseProtectAction action;
    private CountDownLatch doneSignal;
    private ProtectGroupLogDetail detail;

    public ProtectionExecutorCallable(AbstractBaseProtectAction action, ActionContext context, CountDownLatch doneSignal, ProtectGroupLogDetail historyDetailLog) {
        this.action = action;
        this.context = context;
        this.doneSignal = doneSignal;
        this.detail = historyDetailLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        boolean executeResult;
        block19: {
            executeResult = true;
            try {
                Date currentDate;
                block18: {
                    ProtectionActionMonitorCallable monitorCallable = new ProtectionActionMonitorCallable(this.action, true, this.detail);
                    Future<Boolean> monitorResult = null;
                    try {
                        currentDate = new Date();
                        this.detail.setStartTime(String.valueOf(currentDate.getTime()));
                        this.detail.setResult(2L);
                        ProtectActionLogManager.getInstance().saveOrUpdateProtectGroupLogDetail(this.detail);
                        monitorResult = FixedProtectionThreadPool.submit(FixedProtectionThreadPool.FixedProtectionThreadPoolEnum.PROTECT_MONITOR_EXECUTOR, monitorCallable);
                        executeResult = this.action.execute(this.context);
                    }
                    catch (LegoCheckedException e) {
                        logger.error((Object)"action execute failed!", (Throwable)e, e.getErrorCode());
                        executeResult = false;
                    }
                    catch (Exception e) {
                        logger.error((Object)("action execute failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
                        executeResult = false;
                    }
                    try {
                        this.action.postExcute(this.context);
                    }
                    catch (Exception e) {
                        logger.error((Object)("action post execute failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
                    }
                    try {
                        if (!executeResult) {
                            this.callbackAction(this.action);
                        }
                        monitorCallable.setUpdate(false);
                        if (null == monitorResult) break block18;
                    }
                    catch (Exception e) {
                        block20: {
                            try {
                                logger.error((Object)("action callback execute failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
                                monitorCallable.setUpdate(false);
                                if (null == monitorResult) break block20;
                            }
                            catch (Throwable throwable) {
                                monitorCallable.setUpdate(false);
                                if (null != monitorResult) {
                                    monitorResult.get(1L, TimeUnit.MINUTES);
                                }
                                Date currentDate2 = new Date();
                                this.detail.setEndTime(String.valueOf(currentDate2.getTime()));
                                this.detail.setInfo(this.action.getDetail());
                                this.detail.setInfoParams(this.action.getDetailParams());
                                this.detail.setResult(executeResult ? 1L : 0L);
                                ProtectActionLogManager.getInstance().saveOrUpdateProtectGroupLogDetail(this.detail);
                                throw throwable;
                            }
                            monitorResult.get(1L, TimeUnit.MINUTES);
                        }
                        Date currentDate3 = new Date();
                        this.detail.setEndTime(String.valueOf(currentDate3.getTime()));
                        this.detail.setInfo(this.action.getDetail());
                        this.detail.setInfoParams(this.action.getDetailParams());
                        this.detail.setResult(executeResult ? 1L : 0L);
                        ProtectActionLogManager.getInstance().saveOrUpdateProtectGroupLogDetail(this.detail);
                        break block19;
                    }
                    monitorResult.get(1L, TimeUnit.MINUTES);
                }
                currentDate = new Date();
                this.detail.setEndTime(String.valueOf(currentDate.getTime()));
                this.detail.setInfo(this.action.getDetail());
                this.detail.setInfoParams(this.action.getDetailParams());
                this.detail.setResult(executeResult ? 1L : 0L);
                ProtectActionLogManager.getInstance().saveOrUpdateProtectGroupLogDetail(this.detail);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"action execute failed!", (Throwable)e, e.getErrorCode());
            }
            catch (Exception e) {
                logger.error((Object)("action execute failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), 1073947440L);
            }
            finally {
                this.doneSignal.countDown();
            }
        }
        return executeResult;
    }

    private void callbackAction(AbstractBaseProtectAction actionParam) {
        try {
            actionParam.callBack(this.context);
        }
        catch (Exception e) {
            logger.error((Object)("post Execute error!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
        }
    }
}

