/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.job;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectionTaskExecutor;
import com.huawei.ism.drm.protection.framework.service.task.ProtectionBackTaskHandler;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Optional;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.quartz.Trigger;

public class ProtectionJob
implements StatefulJob {
    private static Log logger = LogFactory.getInstance(ProtectionJob.class);
    private ProtectionTask task;
    private Trigger quartzTrigger;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.quartzTrigger = jobExecutionContext.getTrigger();
        this.task = (ProtectionTask)this.quartzTrigger.getJobDataMap().get((Object)"TASK");
        String uuid = this.task.getProtectGroup().getUuid();
        if (!VerifyUtil.isEmpty((String)uuid)) {
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(uuid, false);
            Schedule schedule = Optional.ofNullable(pg.getTemplate().getSchedules().stream().filter(a -> a.getScheduleId().equals(this.task.getSchedule().getScheduleId())).findFirst()).get().orElse(null);
            this.task.setSchedule(schedule);
        }
        ProtectionTaskExecutor backTask = new ProtectionTaskExecutor(this.task);
        ProtectionBackTaskHandler.getInstance().submitTask(backTask);
    }

    public static String getClassName() {
        logger.trace((Object)"getClassName");
        String className = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            Object[] element = e.getStackTrace();
            if (!VerifyUtil.isEmpty((Object[])element)) {
                className = ((StackTraceElement)element[0]).getClassName();
            }
            return className;
        }
    }
}

