/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmObjectSerializableUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.action.model.ProtectActionVo;
import com.huawei.ism.drm.protection.action.model.ProtectPathActionLogs;
import com.huawei.ism.drm.protection.action.model.ProtectPathActions;
import com.huawei.ism.drm.protection.action.service.IProtectActionService;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.action.ProtectActionFlowDefine;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionConvert;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionLogManager;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service(Name="com.huawei.ism.drm.protection.action.service.IProtectActionService", Desc="", Interface=IProtectActionService.class)
public class ProtectActionFlowDefineMgr
extends BaseService
implements IProtectActionService {
    private static Log logger = LogFactory.getInstance(ProtectActionFlowDefineMgr.class);
    private static ProtectActionFlowDefineMgr instance = new ProtectActionFlowDefineMgr();
    private Map<String, ProtectActionFlowDefine> protectActionFlowDefineTemplates = new ConcurrentHashMap<String, ProtectActionFlowDefine>();
    private Map<String, List<AbstractBaseProtectAction>> protectActionCache = new ConcurrentHashMap<String, List<AbstractBaseProtectAction>>();

    private ProtectActionFlowDefineMgr() {
    }

    public static ProtectActionFlowDefineMgr getInstance() {
        return instance;
    }

    public void registerProtectActionFlowDefines(List<ProtectActionFlowDefine> templates) {
        if (null == templates || templates.isEmpty()) {
            logger.info((Object)"templates is null or empty,not register ProtectActionFlowDefines.");
            return;
        }
        for (ProtectActionFlowDefine template : templates) {
            this.protectActionFlowDefineTemplates.put(ProtectActionFlowDefine.generateTemplateKey(template.getTemplateType(), template.getAppType(), template.getCurrentIndex()), template);
        }
    }

    private List<AbstractBaseProtectAction> createProtectFlowDef(String key) {
        List<AbstractBaseProtectAction> actionList = this.protectActionCache.get(key);
        if (null != actionList && !actionList.isEmpty()) {
            return this.cloneProtectAction(actionList);
        }
        ProtectActionFlowDefine template = this.queryActionFlowDefineTemplate(key);
        if (null == template) {
            return new ArrayList<AbstractBaseProtectAction>();
        }
        ArrayList<AbstractBaseProtectAction> flowActionList = new ArrayList<AbstractBaseProtectAction>();
        for (ProtectActionVo vo : template.getActionList()) {
            AbstractBaseProtectAction action = this.createProtectActionFlow(template, vo);
            flowActionList.add(action);
        }
        this.joinActionList(flowActionList);
        this.protectActionCache.put(key, flowActionList);
        return this.cloneProtectAction(flowActionList);
    }

    private ProtectActionFlowDefine queryActionFlowDefineTemplate(String key) {
        if (key.endsWith(":")) {
            for (Map.Entry<String, ProtectActionFlowDefine> entry : this.protectActionFlowDefineTemplates.entrySet()) {
                if (!entry.getKey().startsWith(key)) continue;
                return entry.getValue();
            }
            return null;
        }
        return this.protectActionFlowDefineTemplates.get(key);
    }

    private AbstractBaseProtectAction createProtectActionFlow(ProtectActionFlowDefine template, ProtectActionVo vo) {
        AbstractBaseProtectAction protectAction = null;
        try {
            ClassLoader clsLoader = DrmObjectSerializableUtil.getGlobalClassLoader();
            protectAction = (AbstractBaseProtectAction)Class.forName(vo.getName(), true, clsLoader).newInstance();
            this.buildBaseProtectAction(protectAction, template, vo);
        }
        catch (Exception e) {
            logger.error((Object)("get AbstractBaseProtectAction error" + vo.getName()));
            ExceptionUtil.rethrowException((Throwable)e, (String)("Creating protect action failed. Name:" + vo.getName()), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return protectAction;
    }

    private List<AbstractBaseProtectAction> cloneProtectAction(List<AbstractBaseProtectAction> actions) {
        ArrayList<AbstractBaseProtectAction> protectActions = new ArrayList<AbstractBaseProtectAction>();
        if (null == actions || actions.isEmpty()) {
            return protectActions;
        }
        try {
            for (AbstractBaseProtectAction action : actions) {
                AbstractBaseProtectAction newAction = (AbstractBaseProtectAction)action.clone();
                protectActions.add(newAction);
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Cloning RecoveryProcessors failed.", (Throwable)e, 90160758784001L);
            protectActions.clear();
        }
        this.joinActionList(protectActions);
        return protectActions;
    }

    private void buildBaseProtectAction(AbstractBaseProtectAction action, ProtectActionFlowDefine template, ProtectActionVo vo) {
        logger.trace((Object)"buildBaseProtectAction");
        action.setActionType(vo.getActionType());
        action.setEditable(vo.isEditable());
        action.setEnable(vo.isEnable());
        action.setProtectLocation(template.getCurrentIndex());
        action.setProtectedType(template.getTemplateType());
    }

    private void joinActionList(List<AbstractBaseProtectAction> actionList) {
        logger.trace((Object)"joinActionList");
        for (int i = 0; i < actionList.size(); ++i) {
            if (i > 0) {
                actionList.get(i).setPreAction(actionList.get(i - 1).getActionId());
            }
            if (i >= actionList.size() - 1) continue;
            actionList.get(i).setNextAction(actionList.get(i + 1).getActionId());
        }
    }

    private List<AbstractBaseProtectAction> sortActionList(List<AbstractBaseProtectAction> actionList, int templateType) {
        logger.trace((Object)"sortActionList");
        ArrayList<AbstractBaseProtectAction> sortAction = new ArrayList<AbstractBaseProtectAction>();
        AbstractBaseProtectAction firstAction = actionList.get(0);
        for (AbstractBaseProtectAction action2 : actionList) {
            if (!VerifyUtil.isEmpty((String)action2.getPreAction())) continue;
            firstAction = action2;
            break;
        }
        sortAction.add(firstAction);
        while (!VerifyUtil.isEmpty((String)firstAction.getNextAction()) && null != (firstAction = this.getConcreteAction(firstAction.getNextAction(), actionList))) {
            sortAction.add(firstAction);
        }
        sortAction.forEach(action -> action.setProtectedType(templateType));
        return sortAction;
    }

    private AbstractBaseProtectAction getConcreteAction(String actionId, List<AbstractBaseProtectAction> actionList) {
        logger.trace((Object)"getConcreteAction");
        AbstractBaseProtectAction result = null;
        for (AbstractBaseProtectAction action : actionList) {
            if (!action.getActionId().equals(actionId)) continue;
            result = action;
            break;
        }
        return result;
    }

    public List<AbstractBaseProtectAction> getProtectActions(String pgId, int templateType, int appType, int protectLocation, int protectedType) {
        logger.trace((Object)"getProtectActions");
        ProtectGroup pg = ProtectGroupUtil.getInstance().getProtectGroupForActions(pgId);
        if (null == pg) {
            logger.error((Object)("The pg is null: " + pgId), 90160758786893L);
            throw new LegoCheckedException(1073947394L);
        }
        List<AbstractBaseProtectAction> result = this.getProtectActionsByType(pgId, protectedType, appType, protectLocation);
        if (VerifyUtil.isEmpty(result)) {
            result = this.getProtectActionsByType(pgId, templateType, appType, protectLocation);
        }
        if (!VerifyUtil.isEmpty(result)) {
            result.forEach(action -> action.setProtectedType(protectedType));
        }
        return result;
    }

    private List<AbstractBaseProtectAction> getProtectActionsByType(String pgId, int templateType, int appType, int protectLocation) {
        logger.trace((Object)"getProtectActions");
        List<AbstractBaseProtectAction> result = this.getActionsFromDB(pgId, protectLocation, templateType);
        if (!VerifyUtil.isEmpty(result)) {
            return this.sortActionList(result, templateType);
        }
        result = this.getActionsFromXml(pgId, templateType, appType, protectLocation);
        if (!VerifyUtil.isEmpty(result)) {
            this.saveOrUpdateActions(result);
        }
        return result;
    }

    public List<AbstractBaseProtectAction> getActionsFromXml(String pgId, int templateType, int appType, int protectLocation) {
        logger.trace((Object)"getActionsFromXml");
        ProtectGroup pg = ProtectGroupUtil.getInstance().getProtectGroupForActions(pgId);
        if (null == pg) {
            logger.error((Object)("The pg is null: " + pgId), 90160758786893L);
            throw new LegoCheckedException(1073947394L);
        }
        String templateKey = ProtectActionFlowDefine.generateTemplateKey(templateType, appType, protectLocation);
        List<AbstractBaseProtectAction> actions = this.createProtectFlowDef(templateKey);
        for (AbstractBaseProtectAction action : actions) {
            action.setProtectGroupId(pgId);
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<AbstractBaseProtectAction> getActionsFromDB(String pgId, int protectLocation, Integer templateType) {
        List list;
        Session session = null;
        try {
            List list2;
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(AbstractBaseProtectAction.class);
            criteria.add((Criterion)Restrictions.eq((String)"protectGroupId", (Object)pgId));
            if (protectLocation != -1) {
                criteria.add((Criterion)Restrictions.eq((String)"protectLocation", (Object)protectLocation));
            }
            if (null != templateType) {
                criteria.add((Criterion)Restrictions.eq((String)"protectedType", (Object)templateType));
            }
            list = list2 = criteria.list();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("query protect actions from db error!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
            return null;
        }
        DBOperationUtil.closeSession(session);
        return list;
    }

    private void saveOrUpdateActions(List<AbstractBaseProtectAction> actions) {
        logger.trace((Object)"saveOrUpdateActions");
        SaveOrUpdateActionsTransaction transation = new SaveOrUpdateActionsTransaction(actions);
        CommonDAOLocator.getBaseDao().getTransactionTemplate().execute((TransactionCallback)transation);
    }

    public List<ProtectPathActionLogs> getActionLogs(String pgId) {
        ProtectGroup pg = ProtectGroupUtil.getInstance().getProtectGroupForActions(pgId);
        if (null == pg) {
            logger.error((Object)("The pg is null: " + pgId), 90160758786893L);
            throw new LegoCheckedException(1073947394L);
        }
        if (!pg.isPrimary()) {
            try {
                RestClient client = SiteUtil.initClient(pg.getProductSiteId());
                HashMap<String, String> uriVariables = new HashMap<String, String>();
                uriVariables.put("protectGroupId", pg.getUuid());
                String result = client.invoke("/ws/protectgroups/{protectGroupId}/actions/logs", uriVariables, HttpMethod.GET);
                return ProtectGroupUtil.getInstance().transJsonToPathLogs(result);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"query action logs from remote site error", (Throwable)e, 90160758787071L);
                throw e;
            }
        }
        ArrayList<ProtectPathActionLogs> result = new ArrayList<ProtectPathActionLogs>();
        List<ProtectPathActions> allActions = this.getActions(pg);
        for (ProtectPathActions paths : allActions) {
            this.filterEnableActions(paths.getActions());
        }
        for (ProtectPathActions paths : allActions) {
            ProtectPathActionLogs logs = new ProtectPathActionLogs();
            logs.setPath(paths.getPath());
            logs.setProtectionLogDetails(this.createQuiescentDetail(paths.getActions()));
            result.add(logs);
        }
        int status = pg.getStatus();
        if (status == DrmEnumDefine.PROTECT_GROUP_STATUS.RUNNING.getStatus()) {
            this.fillRunningDetail(pgId, result);
        }
        return result;
    }

    private void fillRunningDetail(String pgId, List<ProtectPathActionLogs> result) {
        logger.trace((Object)"fillRunningDetail");
        for (ProtectPathActionLogs entry : result) {
            List details = entry.getProtectionLogDetails();
            for (int i = 0; i < details.size(); ++i) {
                ProtectGroupLogDetail logDetail = ProtectActionLogManager.getInstance().getActionLogDetail(pgId, ((ProtectGroupLogDetail)details.get(i)).getActionId());
                if (VerifyUtil.isEmpty((Object)logDetail)) continue;
                details.set(i, logDetail);
            }
        }
    }

    public List<ProtectPathActions> getActions(String pgId) {
        ProtectGroup pg = ProtectGroupUtil.getInstance().getProtectGroupForActions(pgId);
        if (null == pg) {
            logger.error((Object)("The pg is null: " + pgId), 90160758786893L);
            throw new LegoCheckedException(1073947394L);
        }
        if (!pg.isPrimary()) {
            throw new LegoCheckedException(1073948184L);
        }
        ProtectGroupHelper.getInstance().checkOptStatus(ProtectGroupHelper.PROTECT_GROUP_OPT.MOFIFY.getStatus(), pg.getStatus());
        return this.getActions(pg);
    }

    private List<ProtectPathActions> getActions(ProtectGroup pg) {
        logger.trace((Object)"getActions");
        PolicyTemplate template = pg.getTemplate();
        int templateType = template.getType();
        boolean ingoreLocationType = false;
        if (PolicyTemplateTools.getInstance().ingoreLocationType(templateType)) {
            ingoreLocationType = true;
        }
        ArrayList<Schedule> scheduleList = new ArrayList<Schedule>(template.getSchedules());
        scheduleList.sort(Comparator.comparingInt(Schedule::getProtectLocation));
        int appType = pg.getPoType();
        ArrayList<ProtectPathActions> actions = new ArrayList<ProtectPathActions>();
        for (Schedule schedule : scheduleList) {
            List<AbstractBaseProtectAction> allActions;
            int protectLocation = schedule.getProtectLocation();
            int protectedType = schedule.getProtectedType();
            if (ingoreLocationType) {
                protectLocation = -1;
            }
            if (VerifyUtil.isEmpty(allActions = this.getProtectActions(pg.getUuid(), templateType, appType, protectLocation, protectedType))) continue;
            ProtectLocationPath tmpPath = new ProtectLocationPath();
            tmpPath.setProtectLocation(protectLocation);
            this.fillProtectLocationPath(schedule, tmpPath);
            ProtectPathActions action = new ProtectPathActions();
            ActionContext context = this.initActionContext(pg, schedule);
            this.initActions(allActions, pg, context, protectLocation);
            action.setPath(tmpPath);
            action.setActions(this.convertActionVo(allActions));
            actions.add(action);
        }
        return actions;
    }

    private ActionContext initActionContext(ProtectGroup protectGroup, Schedule schedule) {
        ProtectionTask task = new ProtectionTask();
        task.setSchedule(schedule);
        ActionContext context = new ActionContext();
        context.addObject("PG_ENTITY", (Object)protectGroup);
        context.addObject("TASK_ENTITY", (Object)task);
        context.addObject("PG_EXECUTE_LOCATION", (Object)schedule.getProtectLocation());
        return context;
    }

    public void initActions(List<AbstractBaseProtectAction> actions, ProtectGroup pg, ActionContext context, int protectLocation) {
        if (null == context) {
            context = new ActionContext();
            context.addObject("PG_ENTITY", (Object)pg);
            context.addObject("PG_EXECUTE_LOCATION", (Object)protectLocation);
        }
        for (AbstractBaseProtectAction action : actions) {
            try {
                action.preExcute(context);
            }
            catch (Exception e) {
                logger.error((Object)("init action failed,action " + action.getClass().getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 0x300001L);
            }
        }
    }

    private void filterEnableActions(List<ProtectActionVo> actions) {
        logger.trace((Object)"filterEnableActions");
        ArrayList<ProtectActionVo> toDelete = new ArrayList<ProtectActionVo>();
        for (ProtectActionVo action : actions) {
            if (action.isEnable()) continue;
            toDelete.add(action);
        }
        actions.removeAll(toDelete);
    }

    private List<ProtectGroupLogDetail> createQuiescentDetail(List<ProtectActionVo> actions) {
        logger.trace((Object)"createQuiescentDetail");
        ArrayList<ProtectGroupLogDetail> allDetail = new ArrayList<ProtectGroupLogDetail>();
        for (ProtectActionVo action : actions) {
            if (!action.isEnable()) continue;
            ProtectGroupLogDetail detail = new ProtectGroupLogDetail();
            detail.setTitle(action.getName());
            detail.setTitleParams(action.getNameParams());
            detail.setActionId(action.getActionId());
            detail.setDetailId(UUIDGenerator.getUUID());
            detail.setResult(3L);
            detail.setStartTime("--");
            detail.setEndTime("--");
            detail.setInfo("--");
            detail.setInfoParams("");
            detail.setProtectionLogDetails(new HashSet());
            detail.setProtectedType(action.getProtectedType());
            allDetail.add(detail);
        }
        return allDetail;
    }

    private void fillProtectLocationPath(Schedule schedule, ProtectLocationPath path) {
        logger.trace((Object)"fillProtectLocationPath");
        String fromSiteId = schedule.getSourceSiteId();
        String toSiteId = schedule.getTargetSiteId();
        if (!VerifyUtil.isEmpty((String)fromSiteId)) {
            path.setProtectedSiteId(fromSiteId);
            Site fromSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getCombinaSiteById(fromSiteId, ":");
            if (fromSite == null) {
                logger.error((Object)"Site is null.");
                throw new LegoCheckedException(2117645L);
            }
            path.setProtectedSiteName(fromSite.getName());
        }
        if (!VerifyUtil.isEmpty((String)toSiteId)) {
            path.setRecoverySiteId(toSiteId);
            Site toSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getCombinaSiteById(toSiteId, ":");
            if (toSite == null) {
                logger.error((Object)"Site is null");
                throw new LegoCheckedException(2117645L);
            }
            path.setRecoverySiteName(toSite.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBaseProtectAction queryProtectActionFromDB(String pgId, String actionId) {
        AbstractBaseProtectAction abstractBaseProtectAction;
        List actions;
        Session session;
        block6: {
            session = null;
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(AbstractBaseProtectAction.class);
            if (!VerifyUtil.isEmpty((String)pgId)) {
                criteria.add((Criterion)Restrictions.eq((String)"protectGroupId", (Object)pgId));
            }
            criteria.add((Criterion)Restrictions.eq((String)"actionId", (Object)actionId));
            actions = criteria.list();
            if (!VerifyUtil.isEmpty((Collection)actions)) break block6;
            AbstractBaseProtectAction abstractBaseProtectAction2 = null;
            DBOperationUtil.closeSession(session);
            return abstractBaseProtectAction2;
        }
        try {
            abstractBaseProtectAction = (AbstractBaseProtectAction)actions.get(0);
        }
        catch (Exception e) {
            AbstractBaseProtectAction abstractBaseProtectAction3;
            try {
                logger.error((Object)(pgId + " queryProtectActionFromDB error " + actionId + ExceptionUtil.getErrorMessage((Throwable)e)));
                abstractBaseProtectAction3 = null;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
            return abstractBaseProtectAction3;
        }
        DBOperationUtil.closeSession(session);
        return abstractBaseProtectAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProtectGroupAndReplica() {
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Date currentDate = new Date();
            String sql = "UPDATE ti_protectgrouplogdetail SET RESULT = :failed , ENDTIME = :currentTime, INFO = :info where RESULT = :running";
            NativeQuery query = session.createSQLQuery(sql);
            query.setInteger("running", 2);
            query.setInteger("failed", 0);
            query.setString("currentTime", String.valueOf(currentDate.getTime()));
            query.setString("info", "lego.err.1073947452");
            sql = "UPDATE ti_protectgroupreplica SET MOUNTSTATUS = :mountFailed WHERE MOUNTSTATUS = :mounting";
            NativeQuery mouting2Mountfailed = session.createSQLQuery(sql);
            mouting2Mountfailed.setInteger("mountFailed", ReplicaMountStatus.MOUNT_FAILED.getStatus());
            mouting2Mountfailed.setInteger("mounting", ReplicaMountStatus.MOUNTING.getStatus());
            sql = "UPDATE ti_protectgroupreplica SET MOUNTSTATUS = :unmountFailed WHERE MOUNTSTATUS = :unmounting";
            NativeQuery unmounting2Unmountfailed = session.createSQLQuery(sql);
            unmounting2Unmountfailed.setInteger("unmountFailed", ReplicaMountStatus.UMOUNT_FAILED.getStatus());
            unmounting2Unmountfailed.setInteger("unmounting", ReplicaMountStatus.UMOUNTING.getStatus());
            session.beginTransaction();
            query.executeUpdate();
            mouting2Mountfailed.executeUpdate();
            unmounting2Unmountfailed.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            try {
                logger.error((Object)" resetProtectActionsResult error ");
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"resetProtectActionsResult failed!", (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProtectActions(String pgId) {
        this.deleteProtectActionParams(pgId);
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String sql = "DELETE FROM ti_protectaction where PGID = :pgId";
            NativeQuery query = session.createSQLQuery(sql);
            query.setString("pgId", pgId);
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            try {
                logger.error((Object)("Delete protectGroupAction by id failed! pgId" + pgId + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758786989L);
                DBOperationUtil.rollbackSession(session);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProtectActionParams(String pgId) {
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String sql = "DELETE FROM ti_protectaction_param where ACTIONID IN (SELECT ACTIONID FROM ti_protectaction WHERE PGID = :pgId)";
            NativeQuery query = session.createSQLQuery(sql);
            query.setString("pgId", pgId);
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            try {
                logger.error((Object)("Delete protectGroupActionParams by id failed! pgId" + pgId + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758786989L);
                DBOperationUtil.rollbackSession(session);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    public ProtectActionVo queryProtectAction(String pgId, String actionId) {
        return this.convertActionVo(this.queryProtectActionFromDB(pgId, actionId));
    }

    private ProtectActionVo convertActionVo(AbstractBaseProtectAction action) {
        ProtectActionVo vo = new ProtectActionVo();
        if (action == null) {
            logger.error((Object)"action is null!");
            return null;
        }
        ProtectActionConvert.actionConvert(action, vo);
        return vo;
    }

    private List<ProtectActionVo> convertActionVo(List<AbstractBaseProtectAction> actionList) {
        ArrayList<ProtectActionVo> result = new ArrayList<ProtectActionVo>();
        for (AbstractBaseProtectAction action : actionList) {
            result.add(this.convertActionVo(action));
        }
        return result;
    }

    private void checkActionOpt(int optValue, String protectGroupId, AbstractBaseProtectAction action) {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        if (null == pg || !pg.isPrimary() || !action.isEditable()) {
            logger.error((Object)"failed to operate protectGroup", 90160758786989L);
            throw new LegoCheckedException(1073948184L);
        }
        ProtectGroupHelper.getInstance().checkOptStatus(optValue, pg.getStatus());
    }

    static class SaveOrUpdateActionsTransaction
    implements TransactionCallback {
        private List<AbstractBaseProtectAction> actions;

        public SaveOrUpdateActionsTransaction(List<AbstractBaseProtectAction> actionsParam) {
            this.actions = actionsParam;
        }

        public Object doInTransaction(TransactionStatus tstatus) {
            try {
                HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
                for (AbstractBaseProtectAction action : this.actions) {
                    template.saveOrUpdate((Object)action);
                }
            }
            catch (Exception t) {
                logger.error((Object)"SaveOrUpdateActionsTransaction error");
                if (tstatus != null) {
                    tstatus.setRollbackOnly();
                }
                ExceptionUtil.rethrowException((Throwable)t, (String)"failed to saveorupdate actions!", (long)-1L, (String[])new String[0], (Log)logger);
            }
            return null;
        }
    }
}

