/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;

public class AbnormalProtectGroupHandler {

    static class QueryAbnormalProtectGroup
    implements HibernateCallback {
        QueryAbnormalProtectGroup() {
        }

        public Object doInHibernate(Session session) {
            String hql = "select distinct pgId from ProtectGroupLog where flag = 0";
            List list = session.createQuery(hql).list();
            if (VerifyUtil.isEmpty((Collection)list)) {
                return list;
            }
            hql = "select pgId, startTime from ProtectGroupLog where pgId in(:a)";
            Query query = session.createQuery(hql);
            query.setParameterList("a", (Collection)list);
            list = query.list();
            HashMap<String, Long> times = new HashMap<String, Long>();
            for (Object item : list) {
                Object[] data = (Object[])item;
                if (data == null || data.length < 2) continue;
                String key = (String)data[0];
                Long old = (Long)times.get(key);
                Long time = NumberUtil.convertToLong((Object)((String)data[1]));
                time = old == null || old < time ? time : old;
                if (time == null) continue;
                times.put(key, time);
            }
            ArrayList<Object[]> results = new ArrayList<Object[]>();
            for (Map.Entry entry : times.entrySet()) {
                results.add(new Object[]{entry.getKey(), entry.getValue()});
            }
            return results;
        }
    }

    static class UpdateAbnormalProtectGroup
    implements HibernateCallback {
        private List<?> list;

        public UpdateAbnormalProtectGroup(List<?> list) {
            this.list = list;
        }

        public Object doInHibernate(Session session) {
            String hql = "update ProtectGroup set lastExecTime = :time, lastExecResult = 0 where pgId = :pgid";
            for (Object item : this.list) {
                Object[] data = (Object[])item;
                if (data == null || data.length < 2) continue;
                Query query = session.createQuery(hql);
                query.setParameter("pgid", data[0]);
                query.setParameter("time", data[1]);
                query.executeUpdate();
            }
            return null;
        }
    }

    static class UpdateAbnormalLog
    implements HibernateCallback {
        private String endTime;

        public UpdateAbnormalLog(String endTime) {
            this.endTime = endTime;
        }

        public Object doInHibernate(Session session) {
            String hql = "update ProtectGroupLog set endTime = :t, result = :r, flag = 1 where flag = 0";
            Query query = session.createQuery(hql);
            query.setParameter("t", (Object)this.endTime);
            query.setParameter("r", (Object)0L);
            return query.executeUpdate();
        }
    }

    static class UpdateAbnormalLogDetail
    implements HibernateCallback {
        private String endTime;

        public UpdateAbnormalLogDetail(String endTime) {
            this.endTime = endTime;
        }

        public Object doInHibernate(Session session) {
            String hql = "select pgld.detailId from ProtectGroupLogDetail pgld, ProtectGroupLog pgl where pgld.endTime = null and pgld.logId=pgl.historyLogId and pgl.flag = 0";
            List list = session.createQuery(hql).list();
            if (VerifyUtil.isEmpty((Collection)list)) {
                return 0;
            }
            hql = "update ProtectGroupLogDetail set endTime = :a, result = :b, info = :c where detailId in(:d)";
            Query query = session.createQuery(hql);
            query.setParameter("a", (Object)this.endTime);
            query.setParameter("b", (Object)0L);
            query.setParameter("c", (Object)"lego.err.1073947452");
            query.setParameterList("d", (Collection)list);
            return query.executeUpdate();
        }
    }
}

