/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.AbstractProtectionRecoveryService;
import com.huawei.ism.drm.base.service.IConfigSyncRateService;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionFlowDefineMgr;
import com.huawei.ism.drm.protection.framework.service.group.AbnormalProtectGroupHandler;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.BaseProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.UpdateProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public abstract class AbstractProtectGroupService
extends AbstractProtectionRecoveryService
implements IProtectGroupService {
    protected static final long USER_ADMIN = 1L;
    private static final List<Integer> SYNC_RATE_TEMPLATE_TYPE_LIST = Arrays.asList(0, 1, 4, 3, 6, 5, 18, 23, 20, 24, 35, 36, 33);
    private static Log logger = LogFactory.getInstance(AbstractProtectGroupService.class);
    private static final String QUERY_PG_LOGDETAILS_SQL = "WITH RECURSIVE r AS (SELECT * FROM TI_PROTECTGROUPLOGDETAIL WHERE historylogId = :logId  union ALL SELECT tree.* FROM TI_PROTECTGROUPLOGDETAIL tree, r WHERE tree.RELATEDDETAILID = r.DETAILID) select DISTINCT DETAILID,TITLE,TITLEPARAMS,INFO,INFOPARAMS,STARTTIME,ENDTIME,RESULT,RELATEDDETAILID,HISTORYLOGID,PREDETAILID,NEXTDETAILID from r";
    private BaseProtectGroupRefineService baseProtectGroupRefineService = new BaseProtectGroupRefineService();
    private IConfigSyncRateService configSyncRateService;
    private IMoDao moDao;
    private ISiteService siteService;
    private IReplicaRetentionStrategyManager retentionManager;
    private List<IObjectObserver> observerList = new ArrayList<IObjectObserver>();

    public List<IObjectObserver> getObserverList() {
        return this.observerList;
    }

    public void removeObserver(IObjectObserver observer, Map<?, ?> properties) {
        logger.trace((Object)"removeObserver");
        this.observerList.remove(observer);
    }

    public void addObserver(IObjectObserver observer, Map<?, ?> properties) {
        logger.trace((Object)"addObserver");
        if (ProtectGroup.class.getName().equals(observer.getObserverType())) {
            this.observerList.add(observer);
        }
    }

    public IConfigSyncRateService getConfigSyncRateService() {
        return this.configSyncRateService;
    }

    public void setConfigSyncRateService(IConfigSyncRateService configSyncRateService) {
        this.configSyncRateService = configSyncRateService;
    }

    public IMoDao getMoDao() {
        logger.trace((Object)"getMoDao");
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        logger.trace((Object)"setMoDao");
        this.moDao = moDao;
    }

    public ISiteService getSiteService() {
        logger.trace((Object)"getSiteService");
        return this.siteService;
    }

    public void setSiteService(ISiteService siteService) {
        logger.trace((Object)"setSiteService");
        this.siteService = siteService;
    }

    public IReplicaRetentionStrategyManager getRetentionManager() {
        logger.trace((Object)"getRetentionManager");
        return this.retentionManager;
    }

    public void setRetentionManager(IReplicaRetentionStrategyManager retentionManager) {
        logger.trace((Object)"setRetentionManager");
        this.retentionManager = retentionManager;
    }

    public void initialize() {
        this.initLogStatus();
        List<ProtectGroup> protectGroups = QueryProtectGroupRefineService.getInstance().getProtectGroups();
        if (VerifyUtil.isEmpty(protectGroups)) {
            return;
        }
        ProtectActionFlowDefineMgr.getInstance().resetProtectGroupAndReplica();
        for (ProtectGroup protectGroup : protectGroups) {
            try {
                if (protectGroup.isLocked()) {
                    protectGroup.setStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL.getStatus());
                }
                if (protectGroup.isRunning()) {
                    protectGroup.setStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL.getStatus());
                    protectGroup.setLockTime(null);
                    protectGroup.setLastExecResult(Integer.valueOf(0));
                }
                ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
                UpdateProtectGroupRefineService.getInstance().updateProtectGroup(protectGroup);
                PolicyTemplate template = protectGroup.getTemplate();
                if (null != template && null != template.getSchedules()) {
                    template.getSchedules().forEach(schedule -> schedule.setPolicyTemplate(template));
                }
                this.updateSchedule(protectGroup, protectGroup.getTemplate());
                this.updatePoRecoveryStatus(protectGroup);
                this.updateSyncRatePolicy(protectGroup);
                this.retentionManager.createRetentionTask(protectGroup);
            }
            catch (Exception e) {
                logger.error((Object)("Resetting protect group status failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786897L);
            }
        }
    }

    private void updateSyncRatePolicy(ProtectGroup protectGroup) {
        logger.trace((Object)"updateSyncRatePolicy");
        PolicyTemplate pt = protectGroup.getTemplate();
        if (SYNC_RATE_TEMPLATE_TYPE_LIST.contains(pt.getType()) && protectGroup.isPrimary()) {
            protectGroup = this.getProtectGroupByID(protectGroup.getUuid());
            List<ProtectGroupSyncRatePolicy> pgSyncRates = ProtectGroupUtil.convertToSyncRatePolicy(pt);
            this.configSyncRateService.createSyncRateTask(protectGroup, pgSyncRates);
            this.configSyncRateService.runAtOnce(protectGroup, pgSyncRates, true);
        }
    }

    private void initLogStatus() {
        logger.trace((Object)"initLogStatus");
        String endTime = String.valueOf(new Date().getTime());
        HibernateTemplate template = this.getBaseDao().getHibernateTemplate();
        List list = (List)template.execute((HibernateCallback)new AbnormalProtectGroupHandler.QueryAbnormalProtectGroup());
        if (VerifyUtil.isEmpty((Collection)list)) {
            return;
        }
        this.execute("log detail", template, new AbnormalProtectGroupHandler.UpdateAbnormalLogDetail(endTime));
        this.execute("log", template, new AbnormalProtectGroupHandler.UpdateAbnormalLog(endTime));
        this.execute("protect group status", template, new AbnormalProtectGroupHandler.UpdateAbnormalProtectGroup(list));
    }

    private void execute(String name, HibernateTemplate template, HibernateCallback action) {
        try {
            template.execute(action);
        }
        catch (Exception e) {
            logger.error((Object)("Fail to update " + name + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    private void updatePoRecoveryStatus(ProtectGroup protectGroup) {
        logger.trace((Object)"updatePoRecoveryStatus");
        ArrayList<ProtectObject> pos = new ArrayList<ProtectObject>();
        for (ProtectObject po : protectGroup.getPolist()) {
            if (DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E.RUNNING.getValue() != po.getPoRecoveryStatus()) continue;
            po.setPoRecoveryStatus(DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E.FAILED.getValue());
            pos.add(po);
        }
        this.updateProtectObjects(protectGroup.getUuid(), pos);
    }

    public boolean checkGroupName(String protectGroupId, String groupName) {
        logger.trace((Object)("protectGroupId:" + protectGroupId + ", groupName:" + groupName));
        return CreateProtectGroupRefineService.getInstance().checkGroupName(protectGroupId, groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdateProtectGroupProps(String pgId, Map<String, String> props) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(props)) {
            return;
        }
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String strUpdateSQL = "UPDATE ti_protectgroup_prop SET propvalue=? where exists (select count(*) as value from ti_protectgroup_prop WHERE propname=? and pgid=?) and propname=? and pgid=?";
            String strInsertSQL = "INSERT INTO ti_protectgroup_prop(pgid,propvalue,propname) select ?, ?, ? from dual where not exists (SELECT * FROM ti_protectgroup_prop WHERE propname=? and pgid=?)";
            session.beginTransaction();
            Set<Map.Entry<String, String>> entrySet = props.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                NativeQuery updateQuery = session.createSQLQuery(strUpdateSQL);
                updateQuery.setString(0, entry.getValue());
                updateQuery.setString(1, entry.getKey());
                updateQuery.setString(2, pgId);
                updateQuery.setString(3, entry.getKey());
                updateQuery.setString(4, pgId);
                NativeQuery insertQuery = session.createSQLQuery(strInsertSQL);
                insertQuery.setString(0, pgId);
                insertQuery.setString(1, entry.getValue());
                insertQuery.setString(2, entry.getKey());
                insertQuery.setString(3, entry.getKey());
                insertQuery.setString(4, pgId);
                updateQuery.executeUpdate();
                insertQuery.executeUpdate();
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"saveOrUpdateProtectGroupProps error");
                ExceptionUtil.rethrowException((Throwable)e, (String)"", (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkGroupNameForUpdate(String protectGroupId, String groupName) {
        boolean bl;
        Session session;
        block6: {
            boolean bl2;
            session = null;
            try {
                session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String sql = "select PGID from ti_protectgroup where PGNAME=:pgName and ISPRIMARY=:primary";
                NativeQuery query = session.createSQLQuery(sql);
                query.setString("pgName", groupName);
                query.setBoolean("primary", true);
                List results = query.list();
                for (int i = 0; i < results.size(); ++i) {
                    String pgid = (String)results.get(i);
                    if (pgid.equals(protectGroupId)) continue;
                    bl = false;
                    break block6;
                }
                bl2 = true;
            }
            catch (DataAccessException e) {
                try {
                    logger.error((Object)"failed to check GroupName because of query error.", (Throwable)e, 90160758786894L);
                    throw new LegoCheckedException(-1L, (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
            }
            DBOperationUtil.closeSession(session);
            return bl2;
        }
        DBOperationUtil.closeSession(session);
        return bl;
    }

    protected void addOrder(StringBuilder hql, String field, boolean asc) {
        logger.trace((Object)"addOrder");
        if (field != null && field.matches("\\w+")) {
            hql.append(" order by ").append(field).append(asc ? " asc" : " desc");
        }
    }

    protected boolean appendUserBizCondition(StringBuilder hql, List<Object> params, Long userId, boolean flag) {
        logger.trace((Object)"appendUserBizCondition");
        IUserMgr usermgr = this.getUserMgr();
        if (usermgr == null || usermgr.checkUserIsAdmin(userId.longValue()).booleanValue()) {
            return false;
        }
        List<String> objects = this.getUserObjects(userId);
        if (VerifyUtil.isEmpty(objects)) {
            hql.append(flag ? " and " : " where ").append("1 = 0");
            return true;
        }
        hql.append(flag ? " and " : " where ").append("uuid in(");
        for (int i = 0; i < objects.size(); ++i) {
            if (i != 0) {
                hql.append(',');
            }
            hql.append('?');
        }
        hql.append(')');
        params.addAll(objects);
        return true;
    }

    protected IUserMgr getUserMgr() {
        IUserMgr userMgr = (IUserMgr)ServiceContext.getInstance().lookup("user/usermgr");
        if (userMgr == null) {
            logger.error((Object)"can not get user/usermgr service", 90160758784001L);
        }
        return userMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getUserObjects(Long userId) {
        logger.trace((Object)"getUserObjects");
        ArrayList<String> result = new ArrayList();
        Session session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            String hql = "select objectId from UserBizObject where userId = ? ";
            Query query = session.createQuery(hql);
            query.setParameter(0, (Object)userId);
            result = query.list();
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Query user objects failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return result;
    }

    protected Map<String, Map<String, String>> groupPropItems(List<?> props) {
        logger.trace((Object)"groupPropItems");
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Object prop : props) {
            String id;
            HashMap<String, String> attrs;
            int i = 0;
            Object[] items = (Object[])prop;
            if (items == null || items.length < 3) continue;
            if ((attrs = (HashMap<String, String>)map.get(id = (String)items[i++])) == null) {
                attrs = new HashMap<String, String>();
                map.put(id, attrs);
            }
            attrs.put((String)items[i++], (String)items[i]);
        }
        return map;
    }

    protected <E> List<E> getColumnData(List<?> items, int column) {
        logger.info((Object)"getColumnData");
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object each : items) {
            Object[] item = (Object[])each;
            if (column < 0) {
                column += item.length;
            }
            if (column < 0 || column >= item.length) continue;
            list.add(item[column]);
        }
        return list;
    }

    protected List<?> executeNativeSql(String sql, String name, Object value) {
        logger.trace((Object)"executeNativeSql");
        return this.executeNativeSql(sql, new String[]{name}, new Object[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<?> executeNativeSql(String sql, String[] names, Object[] values) {
        if (names.length != values.length) {
            throw new LegoCheckedException(-1L, "Skimble-scamble length");
        }
        Session session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            NativeQuery query = session.createSQLQuery(sql);
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                Object value = values[i];
                if (value instanceof Object[]) {
                    query.setParameterList(name, (Object[])value);
                    continue;
                }
                if (value instanceof Collection) {
                    query.setParameterList(name, (Collection)value);
                    continue;
                }
                query.setParameter(name, value);
            }
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            logger.error((Object)"executeNativeSql error");
            ExceptionUtil.rethrowException((Throwable)e, (String)"Execute native sql failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return null;
    }

    public boolean isHostGroupUsedByProtectGroup(String hostGroupId) {
        String hql = "from ProtectGroup as pg where pg.poProviderSN = ? order by pg.pgId";
        List result = null;
        try {
            result = this.getBaseDao().getHibernateTemplate().find(hql, new Object[]{hostGroupId});
        }
        catch (DataAccessException e) {
            logger.error((Object)"failed to query potectgroup.", (Throwable)e, 90160758786894L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return !VerifyUtil.isEmpty((Collection)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectGroupLogDetail> queryHistoryLogDetail(String historyLogId) {
        Session session;
        List<ProtectGroupLogDetail> details;
        block5: {
            if (VerifyUtil.isEmpty((String)historyLogId)) {
                logger.error((Object)"object not exsit", 90160758784001L);
                throw new LegoCheckedException(1073947394L);
            }
            details = new ArrayList<ProtectGroupLogDetail>();
            session = null;
            try {
                session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                NativeQuery query = session.createSQLQuery(QUERY_PG_LOGDETAILS_SQL);
                query.setInteger("logId", Integer.parseInt(historyLogId));
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block5;
                Set<ProtectGroupLogDetail> allDetails = ProtectGroupUtil.getInstance().constructProtectGroupDetails(results);
                details = ProtectGroupUtil.getInstance().groupProtectGroupLogDetails(allDetails);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting pg log details failed. Id:" + historyLogId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return details;
    }

    public ProtectGroup getProtectGroupBasicInfo(String protectGroupId, boolean isQueryPos) {
        logger.trace((Object)("protectGroupId:" + protectGroupId));
        ProtectGroup protectGroup = QueryProtectGroupRefineService.getInstance().getProtectGroupBasicInfo(protectGroupId, isQueryPos);
        if (protectGroup == null) {
            logger.error((Object)"ProtectGroup is null\uff0cprotectGroupId\uff1a%s", new Object[]{protectGroupId});
            throw new LegoCheckedException(2117645L);
        }
        PolicyTemplate template = protectGroup.getTemplate();
        if (null != template && null != template.getSchedules()) {
            template.getSchedules().forEach(schedule -> schedule.setPolicyTemplate(template));
        }
        this.updateSchedule(protectGroup, protectGroup.getTemplate());
        return protectGroup;
    }

    public void updateProtectObjects(String protectGroupId, List<ProtectObject> protectObjectList) {
        if (null == protectGroupId) {
            logger.error((Object)"parameter is error", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(protectObjectList)) {
            return;
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
        Set dbProtectGroupList = protectGroup.getPolist();
        for (ProtectObject po : protectObjectList) {
            ProtectObject o = null;
            for (ProtectObject oo : dbProtectGroupList) {
                if (!oo.getUuid().equals(po.getUuid())) continue;
                o = oo;
                break;
            }
            if (null == o) {
                logger.error((Object)"failed to update ProtectObjects because of po is not exist.", 90160758786989L);
                throw new LegoCheckedException(-1L);
            }
            o.setPoRecoveryStatus(po.getPoRecoveryStatus());
        }
        try {
            for (ProtectObject po : protectGroup.getPolist()) {
                this.getBaseDao().getHibernateTemplate().update((Object)po);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"failed to update protectobject because of saving error.", (Throwable)e, 90160758786898L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExist(String protectGroupId) {
        Session session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select count(pgId) from ProtectGroup where pgId = :protectGroupId");
            query.setString("protectGroupId", protectGroupId);
            Object result = query.uniqueResult();
            if (result instanceof Long && ((Long)result).intValue() != 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)("isExist error " + protectGroupId));
            ExceptionUtil.rethrowException((Throwable)e, (String)"Query infomation for ProtectGroup failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return false;
    }

    public void restoreAlarmById(String protectGroupId) {
        logger.trace((Object)"restoreAlarmById");
        AlarmReporter.restoreAllAlarm(protectGroupId);
    }

    protected void updateProviderName(ProtectGroup protectGroup) {
        logger.trace((Object)"updateProviderName");
        String providerName = "--";
        Map props = protectGroup.getProps();
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(protectGroup.getPoProviderSN());
        if (null != resource) {
            props.put("providerName", resource.getName());
            return;
        }
        protectGroup.getProps().put("providerName", providerName);
    }

    protected void grantProtectGroupToUser(ProtectGroup protectGroup) {
        logger.trace((Object)"grantProtectGroupToUser");
        ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).addObject(protectGroup.getOwnerId(), new String[]{protectGroup.getUuid()});
    }

    protected ProtectGroupLog getRunningProtectGroupLog(String protectGroupId) {
        logger.trace((Object)"getRunningProtectGroupLog");
        ProtectGroupLog protectGroupLog = null;
        List<ProtectGroupLog> logs = this.queryProtectGroupLogs(protectGroupId, 0, "starttime", false);
        if (!VerifyUtil.isEmpty(logs)) {
            protectGroupLog = logs.iterator().next();
        }
        return protectGroupLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ProtectGroupLog> queryProtectGroupLogs(String pgId, int flag, String orderBy, boolean isAsc) {
        Session session;
        List<ProtectGroupLog> protectGroupLogs;
        block12: {
            protectGroupLogs = new ArrayList<ProtectGroupLog>();
            session = null;
            try {
                session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                StringBuilder strSQL = new StringBuilder();
                strSQL.append("select HISTORYLOGID, INFO, STARTTIME, ENDTIME, RESULT, replicaId, PGID ");
                strSQL.append("from ti_protectgrouplog where PGID=:pgId and FLAG=:flag order by ");
                if ("result".equalsIgnoreCase(orderBy)) {
                    strSQL.append("result");
                } else if ("starttime".equalsIgnoreCase(orderBy)) {
                    strSQL.append("starttime");
                } else if ("endtime".equalsIgnoreCase(orderBy)) {
                    strSQL.append("endtime");
                } else {
                    throw new LegoCheckedException(1073947393L);
                }
                if (isAsc) {
                    strSQL.append(" asc");
                } else {
                    strSQL.append(" desc");
                }
                NativeQuery query = session.createSQLQuery(strSQL.toString());
                query.setString("pgId", pgId);
                query.setInteger("flag", flag);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block12;
                protectGroupLogs = this.constructProtectGroupLogs(results);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting pg log failed. id:" + pgId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return protectGroupLogs;
    }

    protected List<ProtectGroupLog> constructProtectGroupLogs(List<?> results) {
        logger.trace((Object)"constructProtectGroupLogs");
        ArrayList<ProtectGroupLog> pgLogs = new ArrayList<ProtectGroupLog>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 7 != (values = (Object[])object).length) continue;
            ProtectGroupLog pgLog = new ProtectGroupLog();
            pgLog.setHistoryLogId(CommUtil.convertToInteger((Object)values[0]));
            pgLog.setInfo(CommUtil.convertToString((Object)values[1]));
            pgLog.setStartTime(CommUtil.convertToString((Object)values[2]));
            pgLog.setEndTime(CommUtil.convertToString((Object)values[3]));
            pgLog.setResult(CommUtil.convertToLong((Object)values[4]).longValue());
            pgLog.setReplicaId(CommUtil.convertToString((Object)values[5]));
            pgLog.setPgId(CommUtil.convertToString((Object)values[6]));
            pgLogs.add(pgLog);
        }
        return pgLogs;
    }

    protected void updateSchedule(ProtectGroup protectGroup, PolicyTemplate template) {
        if (null == protectGroup || null == template) {
            logger.error((Object)"Update schedule failed, because protectGroup or template is null");
            return;
        }
        if (PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(template.getType())) {
            logger.debug((Object)("no need update schedule for:" + protectGroup.getName()));
            return;
        }
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            logger.warn((Object)"Update schedule failed, because protect object is null");
            return;
        }
        boolean needUpdate = false;
        Set scheduleSet = template.getSchedules();
        if (VerifyUtil.isEmpty((Collection)scheduleSet)) {
            logger.info((Object)"Update schedule failed, Schedule is not exists in the template");
            return;
        }
        for (Schedule schedule2 : scheduleSet) {
            if (null != schedule2.getSourceSiteId() && null != schedule2.getTargetSiteId()) continue;
            needUpdate = true;
            break;
        }
        if (!needUpdate) {
            return;
        }
        List<ProtectLocationPath> localProtectionPathList = this.initLocalProtectLocationPath(protectGroup);
        List<ProtectLocationPath> remoteProtectionPathList = this.initRemoteProtectLocationPath(protectGroup);
        this.resetLocalProtectPath(localProtectionPathList, remoteProtectionPathList);
        ArrayList<ProtectLocationPath> paths = new ArrayList<ProtectLocationPath>();
        paths.addAll(remoteProtectionPathList);
        paths.addAll(localProtectionPathList);
        for (ProtectLocationPath path : paths) {
            List<Schedule> tempScheduleSet = scheduleSet.stream().filter(schedule -> schedule.getProtectLocation() == path.getProtectLocation()).collect(Collectors.toList());
            tempScheduleSet.forEach(schedule -> {
                schedule.setSourceSiteId(path.getProtectedSiteId());
                schedule.setTargetSiteId(path.getRecoverySiteId());
                schedule.setSourceSn(path.getProtectedStorageSN());
                schedule.setTargetSn(path.getRecoveryStorageSN());
                if (schedule.getProtectedType() == -1) {
                    schedule.setProtectedType(template.getType());
                }
                if (ScheduleProtectedType.getAllProtectedTypes().contains(schedule.getProtectedType()) && schedule.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.A_B.getValue()) {
                    schedule.setSourceSiteId(path.getRecoverySiteId());
                    schedule.setSourceSn(path.getRecoveryStorageSN());
                }
                schedule.setPolicyTemplate(template);
                schedule.setRetentionPolicy(schedule.getRetentionPolicy());
                schedule.setAppConsistent(schedule.isAppConsistent());
                schedule.setExpectedRPO(schedule.getExpectedRPO());
                schedule.setEnableRpoCheck(schedule.isEnableRpoCheck());
                schedule.setReplicationSpeedPolicies(schedule.getReplicationSpeedPolicies());
                schedule.setExtParameters(schedule.getExtParameters());
            });
        }
        this.getBaseDao().update((Object)template);
    }

    protected void updateSchedule(String protectGroupId, PolicyTemplate template) {
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, true);
        this.updateSchedule(protectGroup, template);
    }

    private void resetLocalProtectPath(List<ProtectLocationPath> localProtectionPathList, List<ProtectLocationPath> remoteProtectionPathList) {
        if (VerifyUtil.isEmpty(remoteProtectionPathList)) {
            return;
        }
        boolean isReplicationSource = false;
        for (ProtectLocationPath locationPath : localProtectionPathList) {
            ProtectLocationPath path = null;
            for (ProtectLocationPath remotePath : remoteProtectionPathList) {
                if (null == locationPath.getProtectedSiteId() || !locationPath.getProtectedSiteId().equals(remotePath.getProtectedSiteId())) continue;
                isReplicationSource = true;
                path = remotePath;
                break;
            }
            if (!isReplicationSource || null == path) continue;
            this.resetLocalProtectionPath(locationPath, path);
        }
    }

    private List<ProtectLocationPath> initRemoteProtectLocationPath(ProtectGroup protectGroup) {
        ArrayList<ProtectLocationPath> remoteProtectionPathList = new ArrayList<ProtectLocationPath>();
        List allReplicaList = protectGroup.listAllReplicatonRepica();
        if (VerifyUtil.isEmpty((Collection)allReplicaList)) {
            return remoteProtectionPathList;
        }
        for (ProtectGroupReplica replica : allReplicaList) {
            int protectionLocation = replica.getProtectLocation();
            String jsonString = replica.getProperty("hyper-dr-ring-used-resources");
            if (!VerifyUtil.isEmpty((String)jsonString)) {
                ProtectLocationPath path = this.buildProtectionPath(protectionLocation, jsonString);
                if (null == path) continue;
                remoteProtectionPathList.add(path);
                continue;
            }
            String srcDeviceSN = replica.getProductArray();
            String tgtDeviceSN = replica.getRecoveryArray();
            ProtectLocationPath path = this.buildProtectionPath(srcDeviceSN, tgtDeviceSN, protectionLocation);
            remoteProtectionPathList.add(path);
        }
        return remoteProtectionPathList;
    }

    private ProtectLocationPath buildProtectionPath(int protectionLocation, String jsonString) {
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.fromObject((Object)jsonString);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Cannot convert hyper-dr-ring-used-resources[%s] json string to JSONObject.", new Object[]{jsonString});
            return null;
        }
        if (null == jsonObject) {
            return null;
        }
        String reg = "[\\[\\]\"]";
        JSONArray productSites = jsonObject.getJSONArray("product.site");
        JSONArray recoverySites = jsonObject.getJSONArray("recovery.site");
        if (null == productSites || null == recoverySites) {
            logger.warn((Object)"Product site or Recovery site is null");
            return null;
        }
        ProtectLocationPath path = new ProtectLocationPath();
        path.setProtectLocation(protectionLocation);
        path.setProtectedSiteId(productSites.toString().replaceAll(reg, "").replaceAll(",", ":"));
        path.setRecoverySiteId(recoverySites.toString().replaceAll(reg, "").replaceAll(",", ":"));
        JSONArray productStorages = jsonObject.getJSONArray("product.storage");
        JSONArray recoveryStorages = jsonObject.getJSONArray("recovery.storage");
        if (null != productStorages && null != recoveryStorages) {
            path.setProtectedStorageSN(productStorages.toString().replaceAll(reg, "").replaceAll(",", ":"));
            path.setRecoveryStorageSN(recoveryStorages.toString().replaceAll(reg, "").replaceAll(",", ":"));
        }
        return path;
    }

    private List<ProtectLocationPath> initLocalProtectLocationPath(ProtectGroup protectGroup) {
        List storageInfoList = protectGroup.distinctStorageInfo();
        if (VerifyUtil.isEmpty((Collection)storageInfoList)) {
            return new ArrayList<ProtectLocationPath>();
        }
        ArrayList lunList = new ArrayList();
        ArrayList<ProtectLocationPath> localProtectionPathList = new ArrayList<ProtectLocationPath>();
        int index = 1;
        for (StorageResource storageResource : lunList) {
            ProtectLocationPath path = new ProtectLocationPath();
            path.setProtectedSiteId(protectGroup.getProductSiteId());
            path.setRecoverySiteId(protectGroup.getProductSiteId());
            int protectionLocation = DrmEnumDefine.PROTECT_LOCATION.A.getValue();
            if (index == 2) {
                protectionLocation = DrmEnumDefine.PROTECT_LOCATION.B.getValue();
            }
            path = this.buildProtectionPath(storageResource.getDevSn(), storageResource.getDevSn(), protectionLocation);
            localProtectionPathList.add(path);
            ++index;
        }
        return localProtectionPathList;
    }

    private void resetLocalProtectionPath(ProtectLocationPath locationPath, ProtectLocationPath path) {
        if (DrmEnumDefine.PROTECT_LOCATION.A_B.getValue() == path.getProtectLocation()) {
            locationPath.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.A.getValue());
        }
        if (DrmEnumDefine.PROTECT_LOCATION.A_C.getValue() == path.getProtectLocation()) {
            locationPath.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.B.getValue());
        }
    }

    private ProtectLocationPath buildProtectionPath(String srcDevSN, String tgtDevSN, int protectionLocation) {
        Site tgtSite;
        ProtectLocationPath path = new ProtectLocationPath();
        path.setProtectLocation(protectionLocation);
        path.setProtectedStorageSN(srcDevSN);
        path.setRecoveryStorageSN(tgtDevSN);
        Site srcSite = this.siteService.getSiteByDeviceSn(srcDevSN);
        if (null != srcSite) {
            path.setProtectedSiteId(srcSite.getSiteId());
        }
        if (null != (tgtSite = this.siteService.getSiteByDeviceSn(tgtDevSN))) {
            path.setRecoverySiteId(tgtSite.getSiteId());
        }
        return path;
    }

    public void notifyObserver(MessageEvent event, Runnable runnable) {
        this.baseProtectGroupRefineService.notifyObserver(event, runnable);
    }

    void notifyObserverList(MessageEvent event, String notifyType) {
        this.baseProtectGroupRefineService.notifyObserverList(event, notifyType);
    }
}

