/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.SynProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class CreateProtectGroupTransaction
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(CreateProtectGroupTransaction.class);
    private CreateProtectGroupRefineService service = null;
    private ProtectGroup protectGroup = null;

    public CreateProtectGroupTransaction(CreateProtectGroupRefineService service, ProtectGroup protectGroup) {
        this.service = service;
        this.protectGroup = protectGroup;
    }

    public Object doInTransaction(TransactionStatus tstatus) {
        try {
            ProtectGroupHelper.getInstance().checkAndBuildReplica(this.protectGroup);
            this.protectGroup.setPrimary(true);
            this.checkSiteExist();
            if (!this.service.checkGroupName(null, this.protectGroup.getName())) {
                logger.error((Object)"Protect group name repeated!", 90160758787071L);
                throw new LegoCheckedException(1073947392L);
            }
            this.saveProtectLocationPath();
            CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)this.protectGroup);
            this.service.getRetentionManager().createRetentionTask(this.protectGroup);
            SynProtectGroupRefineService.getInstance().syncProtectGroupToRemoteSite(this.protectGroup, "/ws/protectgroups/action/createSyncProtectGroupInfo");
            this.grantProtectGroupToUser(this.protectGroup);
            ((IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class)).createTask(this.protectGroup);
            this.createSyncRate();
        }
        catch (LegoCheckedException le) {
            if (tstatus != null) {
                tstatus.setRollbackOnly();
            }
            ExceptionUtil.rethrowException((Throwable)le, (String)("failed to create protectgroup!" + this.protectGroup.getName()), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
        }
        catch (Exception t) {
            if (tstatus != null) {
                tstatus.setRollbackOnly();
            }
            ExceptionUtil.rethrowException((Throwable)t, (String)("failed to create protectgroup!" + this.protectGroup.getName()), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return null;
    }

    private void createSyncRate() {
        try {
            PolicyTemplate policyTemplate = this.protectGroup.getTemplate();
            List<ProtectGroupSyncRatePolicy> pgsrps = ProtectGroupUtil.convertToSyncRatePolicy(policyTemplate);
            this.service.getConfigSyncRateService().createSyncRateTask(this.protectGroup, pgsrps);
            this.service.getConfigSyncRateService().runAtOnce(this.protectGroup, pgsrps, false);
        }
        catch (Exception e) {
            logger.error((Object)("create sync rate task failed!" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private void checkSiteExist() {
        Set replicas = this.protectGroup.getReplicaList();
        List<Site> allLocalSite = this.getAllLocalSite();
        for (ProtectGroupReplica replica : replicas) {
            String recoverySiteId = replica.getRecoverySite();
            if (this.isSiteExistInAll(allLocalSite, recoverySiteId)) continue;
            Site recoverSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
            if (VerifyUtil.isEmpty((Object)recoverSite)) {
                logger.error((Object)"Recovery Site is not exsit", 90160758786989L);
                throw new LegoCheckedException(1073948692L);
            }
            if (1 != recoverSite.getSiteType()) continue;
            this.localSiteCheck(recoverSite, allLocalSite);
            break;
        }
    }

    private void localSiteCheck(Site recoverSite, List<Site> allLocalSite) {
        Site targetLocalSite = new Site();
        try {
            RestClient client = SiteUtil.initClient(recoverSite);
            List allRemoteSite = client.getForObjects("/ws/sites", null, Site.class);
            Iterator<Site> iterator = allLocalSite.iterator();
            while (iterator.hasNext()) {
                Site localSite;
                targetLocalSite = localSite = iterator.next();
                if (VerifyUtil.isEmpty((Object)localSite)) {
                    logger.error((Object)("local Site is not exsit,id:" + localSite.getSiteId()), 90160758786989L);
                    throw new LegoCheckedException(1073948692L);
                }
                if (this.isSiteExistInAll(allRemoteSite, localSite.getSiteId())) continue;
                throw new LegoCheckedException(1073948209L, new String[]{localSite.getName(), recoverSite.getName()});
            }
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073948209L) {
                logger.error((Object)("there is no local site,name:" + targetLocalSite.getName() + " in remote site,name:" + recoverSite.getName()), 90160758787071L);
            } else {
                logger.error((Object)"to get remote site error!", 90160758787071L);
            }
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "find Protect Group,name: " + this.protectGroup.getName() + " in remote site,name: " + recoverSite.getName() + " ,id: " + recoverSite.getSiteId() + " error";
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948209L, (String[])new String[]{targetLocalSite.getName(), recoverSite.getName()}, (Log)logger);
        }
    }

    private List<Site> getAllLocalSite() {
        ArrayList<Site> allLocalSite = new ArrayList<Site>();
        Site productSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(this.protectGroup.getProductSiteId());
        if (VerifyUtil.isEmpty((Object)productSite)) {
            logger.error((Object)"product Site is not exsit", 90160758786989L);
            throw new LegoCheckedException(1073948692L);
        }
        allLocalSite.add(productSite);
        for (ProtectGroupReplica replica : this.protectGroup.getReplicaList()) {
            String recoverySiteId = replica.getRecoverySite();
            if (VerifyUtil.isEmpty((String)recoverySiteId)) {
                logger.error((Object)("Recovery Site is not exsit,id:" + recoverySiteId), 90160758786989L);
                throw new LegoCheckedException(1073948692L);
            }
            Site recoverSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
            if (VerifyUtil.isEmpty((Object)recoverSite)) {
                logger.error((Object)("Recovery Site is not exsit,id:" + recoverySiteId), 90160758786989L);
                throw new LegoCheckedException(1073948692L);
            }
            if (0 != recoverSite.getSiteType() || allLocalSite.contains(recoverSite)) continue;
            allLocalSite.add(recoverSite);
        }
        return allLocalSite;
    }

    private boolean isSiteExistInAll(List<Site> allSite, String siteId) {
        if (VerifyUtil.isEmpty(allSite)) {
            return false;
        }
        for (Site localSite : allSite) {
            if (localSite.getSiteType() != 1 || !localSite.getSiteId().equals(siteId)) continue;
            return true;
        }
        return false;
    }

    private void grantProtectGroupToUser(ProtectGroup protectGroupParam) {
        logger.trace((Object)"grantProtectGroupToUser");
        ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).addObject(protectGroupParam.getOwnerId(), new String[]{protectGroupParam.getUuid()});
    }

    private void saveProtectLocationPath() {
        TemplateFilterManager manager = TemplateFilterManager.getInstance();
        IPolicyTemplateFilter filter = manager.getTemplateFilterByType(this.protectGroup.getTemplate().getType());
        if (null == filter) {
            logger.error((Object)("The policyTemplateFilter is null! PtType = " + this.protectGroup.getTemplate().getType()), 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        List paths = filter.getProtectLocationPaths(new ArrayList(this.protectGroup.getPolist()));
        this.protectGroup.getProps().put("PROTECTGROUP_PROTECTLOCATIONPATH", JSONArray.fromObject((Object)paths).toString());
    }
}

