/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProtectCustomStepHelper {
    private static Log logger = LogFactory.getInstance(ProtectCustomStepHelper.class);

    public static void checkScriptParams(Schedule schedule) {
        if (null == schedule) {
            return;
        }
        Map props = schedule.getExtParameters();
        String isUserDefined = (String)props.get("isUserDefined");
        if ("1".equals(isUserDefined)) {
            logger.info((Object)"user use user-defined scripts.");
            ScriptParamsUtils.validateUserDefinedParams((String)((String)props.get("userFreezeParam")));
            ScriptParamsUtils.validateUserDefinedParams((String)((String)props.get("userUnfreezeParam")));
            ScriptParamsUtils.validateUserDefinedParams((String)((String)props.get("userQueryParam")));
            return;
        }
        String schemeId = (String)props.get("scriptSchemeId");
        if (VerifyUtil.isEmpty((String)schemeId)) {
            return;
        }
        Map paramValidation = ((IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class)).getParamValidation(schemeId);
        if (VerifyUtil.isEmpty((Map)props)) {
            logger.error((Object)"props is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        ScriptParamsUtils.validateSchemeScriptParams((Map)paramValidation, (String)((String)props.get("publicParam")));
        ScriptParamsUtils.validateSchemeScriptParams((Map)paramValidation, (String)((String)props.get("freezeParams")));
        ScriptParamsUtils.validateSchemeScriptParams((Map)paramValidation, (String)((String)props.get("unfreezeParam")));
        ScriptParamsUtils.validateSchemeScriptParams((Map)paramValidation, (String)((String)props.get("queryParam")));
    }

    public static boolean isParamChanged(JSONObject news, JSONObject olds) {
        if (news == null) {
            return false;
        }
        if (olds == null) {
            return !news.isEmpty();
        }
        for (Object obj : news.entrySet()) {
            Object oldValue;
            Map.Entry entry = (Map.Entry)obj;
            Object newValue = entry.getValue();
            if (Objects.equals(newValue, oldValue = olds.get(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkSchemeIdConsistency(String protectGroupId, String schemeId) {
        PolicyTemplate template = ProtectGroupServiceImpl.queryPolicyTemplateByProtectGroup(protectGroupId);
        String a = (String)template.getProps().get("scriptSchemeId");
        return Objects.equals(a, schemeId);
    }

    public static void checkScriptParams(Schedule schedule, List<AbstractBaseProtectAction> actions) {
        if (null == schedule || ScheduleProtectedType.SNAPSHOT.getValue() != schedule.getProtectedType()) {
            logger.error((Object)"schedule is null.");
            return;
        }
        logger.info((Object)("check schedule params, id:" + schedule.getScheduleId() + ", name: " + schedule.getName()));
        Map props = schedule.getExtParameters();
        String isUserDefined = (String)props.get("isUserDefined");
        if (!"0".equals(isUserDefined)) {
            logger.info((Object)"current user has not selected a script scheme");
            return;
        }
        String schemeId = (String)props.get("scriptSchemeId");
        if (VerifyUtil.isEmpty((String)schemeId)) {
            logger.error((Object)"script scheme id is empty");
            return;
        }
        logger.info((Object)("user use script scheme, id: " + schemeId));
        String params = "";
        String scriptScheme = (String)props.get("scriptScheme");
        for (AbstractBaseProtectAction action : actions) {
            if (action.getParams().containsKey("isEnableFlag") && "false".equals(action.getParams().get("isEnableFlag"))) continue;
            String actionClassName = action.getClass().getName();
            if ("com.huawei.ism.drm.host.protection.action.PreProcessScriptAction".equals(actionClassName)) {
                params = (String)props.get("beforeParam");
            } else if ("com.huawei.ism.drm.host.protection.action.PostProcessScriptAction".equals(actionClassName)) {
                params = (String)props.get("afterParam");
            }
            if (VerifyUtil.isEmpty((String)params)) continue;
            JSONObject jsonParams = JSONObject.fromObject((Object)params);
            Map paramValidation = ((IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class)).getParamValidation(schemeId);
            jsonParams.put((Object)"scriptScheme", (Object)scriptScheme);
            ScriptParamsUtils.checkParamsNullable((Map)paramValidation, (String)jsonParams.toString());
        }
    }
}

