/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.action.model.ProtectActionVo;
import com.huawei.ism.drm.protection.action.model.ProtectPathActionLogs;
import com.huawei.ism.drm.protection.action.model.ProtectPathActions;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupSynchronizer;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplicationAlarmInfo;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.ReplicationSpeedPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ReplicaUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TryCatchThrowable;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class ProtectGroupUtil {
    private static Log logger = LogFactory.getInstance(ProtectGroupHelper.class);
    private static ProtectGroupUtil instance = new ProtectGroupUtil();
    private static List<Integer> asynReplicationRelatedTemplateTypeList = Arrays.asList(20, 4, 3, 6, 5, 18, 1, 30, 31, 32, 35, 36);

    public static ProtectGroupUtil getInstance() {
        return instance;
    }

    public long invokeProductSiteMethod(String productSiteId, String url, String message, Map<String, String> uriVariables, HttpMethod method) {
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productSiteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)"Recovery Site is not exsit", 90160758786989L);
            throw new LegoCheckedException(1073947440L);
        }
        String errorMsg = "To invoke product site method failed, name: " + site.getName() + " ,id: " + site.getSiteId() + " error";
        String responseStr = ProtectGroupSynchronizer.getInstance().protectGroupInvokeMethod(site, url, message, uriVariables, method, errorMsg);
        return this.extractTaskId(responseStr);
    }

    private long extractTaskId(String responseStr) {
        if (responseStr == null) {
            LegoCheckedException err = new LegoCheckedException(-1L);
            logger.error((Object)"extract taskId failed!", (Throwable)err, 90160758787071L);
            throw err;
        }
        JSONObject object = JSONObject.fromObject((Object)responseStr);
        Object taskId = object.get("taskId");
        if (taskId == null) {
            LegoCheckedException err = new LegoCheckedException(-1L);
            logger.error((Object)"taskId is null!", (Throwable)err, 90160758787071L);
            throw err;
        }
        try {
            long backtaskId = Long.parseLong(taskId.toString());
            return backtaskId;
        }
        catch (NumberFormatException e) {
            logger.error((Object)"string type format to long type error!", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException("string type format to long type error!", (Throwable)e);
        }
    }

    public int getProtectGroupObjectCount(List<?> counts, String id) {
        logger.trace((Object)"getProtectGroupObjectCount");
        Object[] item = this.getItemByPgId(counts, id);
        if (item == null || item.length <= 1) {
            return 0;
        }
        Object count = item[1];
        if (null != count) {
            return ((Long)count).intValue();
        }
        return 0;
    }

    public Object[] getItemByPgId(List<?> items, String value) {
        logger.trace((Object)"getItemByPgId");
        return this.getItemByColumnData(items, 0, value);
    }

    private Object[] getItemByColumnData(List<?> items, int column, String value) {
        logger.trace((Object)"getItemByColumnData");
        Object[] ret = null;
        for (Object each : items) {
            Object[] item = (Object[])each;
            if (item == null || item.length <= column) continue;
            Object data = item[column];
            if (value != null && value.equals(data)) {
                ret = item;
                break;
            }
            if (null != value || null != data) continue;
            ret = item;
            break;
        }
        return ret;
    }

    public List<ProtectGroupLogDetail> groupProtectGroupLogDetails(Set<ProtectGroupLogDetail> allDetails) {
        logger.trace((Object)"groupProtectGroupLogDetails");
        ArrayList<ProtectGroupLogDetail> details = new ArrayList<ProtectGroupLogDetail>();
        if (VerifyUtil.isEmpty(allDetails)) {
            return details;
        }
        HashMap groupLogDetails = new HashMap();
        for (ProtectGroupLogDetail logDetail : allDetails) {
            ArrayList subDetails = (ArrayList)groupLogDetails.get(logDetail.getDetailId());
            if (null == subDetails) {
                subDetails = new ArrayList();
                groupLogDetails.put(logDetail.getDetailId(), subDetails);
            }
            logDetail.setChildDetails((List)subDetails);
            if (VerifyUtil.isEmpty((String)logDetail.getParentDetailId())) {
                details.add(logDetail);
                continue;
            }
            ArrayList<ProtectGroupLogDetail> parentSubDetails = (ArrayList<ProtectGroupLogDetail>)groupLogDetails.get(logDetail.getParentDetailId());
            if (null == parentSubDetails) {
                parentSubDetails = new ArrayList<ProtectGroupLogDetail>();
                groupLogDetails.put(logDetail.getParentDetailId(), parentSubDetails);
            }
            parentSubDetails.add(logDetail);
        }
        this.sortProtectGroupLogDetails(details, new LogDetailComparator());
        return details;
    }

    private void sortProtectGroupLogDetails(List<ProtectGroupLogDetail> details, Comparator<ProtectGroupLogDetail> comparator) {
        logger.trace((Object)"sortProtectGroupLogDetails");
        if (VerifyUtil.isEmpty(details)) {
            return;
        }
        if (this.isSortLogDetailByTime(details)) {
            Collections.sort(details, comparator);
        } else {
            this.sortProtectGroupLogDetailsByIndex(details);
        }
        for (ProtectGroupLogDetail detail : details) {
            this.sortProtectGroupLogDetails(detail.getChildDetails(), comparator);
        }
    }

    private void sortProtectGroupLogDetailsByIndex(List<ProtectGroupLogDetail> details) {
        ArrayList<ProtectGroupLogDetail> sortDetails = new ArrayList<ProtectGroupLogDetail>();
        ProtectGroupLogDetail firstDetail = details.get(0);
        for (ProtectGroupLogDetail detail : details) {
            if (!VerifyUtil.isEmpty((String)detail.getPreDetailId())) continue;
            firstDetail = detail;
            sortDetails.add(firstDetail);
            break;
        }
        while (!VerifyUtil.isEmpty((Object)firstDetail) && !VerifyUtil.isEmpty((String)firstDetail.getNextDetailId())) {
            if (null == (firstDetail = this.getConcreteDetail(firstDetail.getNextDetailId(), details))) continue;
            sortDetails.add(firstDetail);
        }
        if (sortDetails.size() == details.size()) {
            details.clear();
            details.addAll(sortDetails);
        }
    }

    public Set<ProtectGroupLogDetail> constructProtectGroupDetails(List<?> results) {
        logger.trace((Object)"constructProtectGroupDetails");
        HashSet<ProtectGroupLogDetail> pgLogDetails = new HashSet<ProtectGroupLogDetail>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 12 != (values = (Object[])object).length) continue;
            ProtectGroupLogDetail pgLogDetail = new ProtectGroupLogDetail();
            pgLogDetail.setDetailId(CommUtil.convertToString((Object)values[0]));
            pgLogDetail.setTitle(CommUtil.convertToString((Object)values[1]));
            pgLogDetail.setTitleParams(CommUtil.convertToString((Object)values[2]));
            pgLogDetail.setInfo(CommUtil.convertToString((Object)values[3]));
            pgLogDetail.setInfoParams(CommUtil.convertToString((Object)values[4]));
            pgLogDetail.setStartTime(CommUtil.convertToString((Object)values[5]));
            pgLogDetail.setEndTime(CommUtil.convertToString((Object)values[6]));
            pgLogDetail.setResult(CommUtil.convertToLong((Object)values[7]).longValue());
            pgLogDetail.setParentDetailId(CommUtil.convertToString((Object)values[8]));
            pgLogDetail.setLogId(CommUtil.convertToInteger((Object)values[9]));
            pgLogDetail.setPreDetailId(CommUtil.convertToString((Object)values[10]));
            pgLogDetail.setNextDetailId(CommUtil.convertToString((Object)values[11]));
            pgLogDetails.add(pgLogDetail);
        }
        return pgLogDetails;
    }

    private boolean isSortLogDetailByTime(List<ProtectGroupLogDetail> details) {
        logger.trace((Object)"isSortLogDetailByTime");
        for (ProtectGroupLogDetail detail : details) {
            if (VerifyUtil.isEmpty((String)detail.getNextDetailId()) && VerifyUtil.isEmpty((String)detail.getPreDetailId())) continue;
            return false;
        }
        return true;
    }

    private ProtectGroupLogDetail getConcreteDetail(String id, List<ProtectGroupLogDetail> details) {
        logger.trace((Object)"getConcreteDetail");
        for (ProtectGroupLogDetail detail : details) {
            if (!id.equals(detail.getDetailId())) continue;
            return detail;
        }
        return null;
    }

    public List<ProtectPathActions> transJsonToPathActions(String info) {
        ArrayList<ProtectPathActions> result = new ArrayList<ProtectPathActions>();
        JSONArray array = JSONArray.fromObject((Object)info);
        for (int i = 0; i < array.size(); ++i) {
            ProtectPathActions pathAction = new ProtectPathActions();
            try {
                this.transJosnToPathActions(array, i, pathAction);
                result.add(pathAction);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("get elements error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
        return result;
    }

    private void transJosnToPathActions(JSONArray array, int i, ProtectPathActions pathAction) {
        logger.trace((Object)"transJosnToPathActions");
        JSONObject obj = array.getJSONObject(i);
        ProtectLocationPath path = new ProtectLocationPath();
        path.setProtectLocation(Integer.parseInt(obj.getString("protectLocation")));
        if (obj.get("protectedSiteName") != null && obj.get("recoverySiteName") != null) {
            path.setProtectedSiteName(obj.getString("protectedSiteName"));
            path.setRecoverySiteName(obj.getString("recoverySiteName"));
        }
        pathAction.setPath(path);
        ArrayList<ProtectActionVo> actionVos = new ArrayList<ProtectActionVo>();
        if (obj.getJSONArray("actions") != null && obj.getJSONArray("actions").size() != 0) {
            JSONArray detailArray = obj.getJSONArray("actions");
            for (int j = 0; j < detailArray.size(); ++j) {
                ProtectActionVo actionVo = new ProtectActionVo();
                JSONObject actionObj = array.getJSONObject(i);
                actionVo.setActionId(actionObj.getString("uuid"));
                actionVo.setActionId(actionObj.getString("actionType"));
                actionVo.setName(actionObj.getString("name"));
                actionVo.setNameParams(actionObj.getString("nameParams"));
                actionVo.setEditable(actionObj.getBoolean("isEditable"));
                actionVo.setEnable(actionObj.getBoolean("enable"));
                actionVo.setParams((Map)actionObj.get("params"));
                actionVos.add(actionVo);
            }
        }
        pathAction.setActions(actionVos);
    }

    public List<ProtectPathActionLogs> transJsonToPathLogs(String info) {
        ArrayList<ProtectPathActionLogs> result = new ArrayList<ProtectPathActionLogs>();
        if (VerifyUtil.isEmpty((String)info)) {
            return result;
        }
        JSONArray array = JSONArray.fromObject((Object)info);
        for (int i = 0; i < array.size(); ++i) {
            ProtectPathActionLogs pathLog = new ProtectPathActionLogs();
            try {
                this.transJosnToPathLogs(array, i, pathLog);
                result.add(pathLog);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("get elements error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
        return result;
    }

    private void transJosnToPathLogs(JSONArray array, int i, ProtectPathActionLogs pathLog) {
        logger.trace((Object)"transJosnToPathLogs");
        JSONObject obj = array.getJSONObject(i);
        ProtectLocationPath path = new ProtectLocationPath();
        path.setProtectLocation(Integer.parseInt(obj.getString("protectLocation")));
        if (obj.get("protectedSiteName") != null && obj.get("recoverySiteName") != null) {
            path.setProtectedSiteName(obj.getString("protectedSiteName"));
            path.setRecoverySiteName(obj.getString("recoverySiteName"));
        }
        pathLog.setPath(path);
        if (obj.getJSONArray("protectGroupLogDetails") != null && obj.getJSONArray("protectGroupLogDetails").size() != 0) {
            JSONArray detailArray = obj.getJSONArray("protectGroupLogDetails");
            pathLog.setProtectionLogDetails(this.transJsonToLogDetail(detailArray.toString()));
        }
    }

    public List<ProtectGroupLogDetail> transJsonToLogDetail(String result) {
        ArrayList<ProtectGroupLogDetail> pgLogDetails = new ArrayList<ProtectGroupLogDetail>();
        JSONArray array = JSONArray.fromObject((Object)result);
        for (int i = 0; i < array.size(); ++i) {
            ProtectGroupLogDetail logDetail = new ProtectGroupLogDetail();
            try {
                this.transJsonToLogDetail(array, i, logDetail);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"get elements error", (Throwable)e, 90160758787071L);
                return pgLogDetails;
            }
            pgLogDetails.add(logDetail);
        }
        return pgLogDetails;
    }

    private void transJsonToLogDetail(JSONArray array, int i, ProtectGroupLogDetail logDetail) {
        logger.trace((Object)"transJsonToLogDetail");
        JSONObject obj = array.getJSONObject(i);
        logDetail.setDetailId(obj.getString("detailId"));
        logDetail.setTitle(obj.getString("title"));
        if (obj.get("titleParams") != null) {
            logDetail.setTitleParams(obj.getString("titleParams"));
        }
        logDetail.setInfo(obj.getString("info"));
        if (obj.get("infoParams") != null) {
            logDetail.setInfoParams(obj.getString("infoParams"));
        }
        logDetail.setStartTime(obj.getString("startTime"));
        logDetail.setEndTime(obj.getString("endTime"));
        logDetail.setResult(obj.getLong("result"));
        if (obj.getJSONArray("protectGroupLogDetails") != null && obj.getJSONArray("protectGroupLogDetails").size() != 0) {
            List details = JSONArray.toCollection((JSONArray)obj.getJSONArray("protectGroupLogDetails"), ProtectGroupLogDetail.class);
            logDetail.setChildDetails(details);
        }
    }

    public void validateProtectGroupObj(ProtectGroup protectGroup) {
        if (null == protectGroup || VerifyUtil.isEmpty((String)protectGroup.getUuid()) || VerifyUtil.isEmpty((String)protectGroup.getName())) {
            logger.error((Object)"failed to update protectGroup because of invalidity paramiter.", 90160758786898L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public Set<Integer> getAllPgProtectLocation(ProtectGroup pg) {
        logger.trace((Object)"getAllPgProtectLocation");
        TreeSet<Integer> allProtectLocation = new TreeSet<Integer>();
        for (Schedule schedule : pg.getTemplate().getSchedules()) {
            allProtectLocation.add(schedule.getProtectLocation());
        }
        return allProtectLocation;
    }

    public Set<Integer> getAllProtectedTypes(ProtectGroup pg, int location) {
        logger.trace((Object)"getAllPgProtectedTypes");
        TreeSet<Integer> allProtectedTypes = new TreeSet<Integer>();
        for (Schedule schedule : pg.getTemplate().getSchedules()) {
            if (location != schedule.getProtectLocation()) continue;
            allProtectedTypes.add(schedule.getProtectedType());
        }
        return allProtectedTypes;
    }

    public String constructReplicaIndexKey(int protectLocation) {
        logger.trace((Object)"constructReplicaIndexKey");
        return "DrmFrameWork_Pg_Replica_Inedx" + protectLocation;
    }

    public boolean is3DCPg(ProtectGroup pg) {
        logger.trace((Object)"is3DCPg");
        int templateType = pg.getTemplate().getType();
        return 4 == templateType || 6 == templateType || 3 == templateType || 5 == templateType;
    }

    public ProtectGroup getProtectGroupForActions(String pgId) {
        logger.trace((Object)"getProtectGroupForActions");
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(pgId, true);
        List pgReplicas = ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).queryProtectGroupReplicaByGroup(pgId, "TIME_STAMP", false);
        if (null == pg) {
            return pg;
        }
        pg.setReplicaList(new HashSet(pgReplicas));
        if (null == pg.getTemplate()) {
            pg.setTemplate(((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).getPtByUuid(pg.getTemplate().getUuid()));
        }
        return pg;
    }

    public static List<ProtectGroupSyncRatePolicy> convertToSyncRatePolicy(PolicyTemplate policyTemplate) {
        logger.trace((Object)"convertToSyncRatePolicy");
        ArrayList<ProtectGroupSyncRatePolicy> results = new ArrayList<ProtectGroupSyncRatePolicy>();
        if (null == policyTemplate) {
            return results;
        }
        Set schedules = policyTemplate.getSchedules();
        for (Schedule schedule : schedules) {
            List policies = schedule.getReplicationSpeedPolicies();
            if (VerifyUtil.isEmpty((Collection)policies)) continue;
            for (ReplicationSpeedPolicy policy : policies) {
                ProtectGroupSyncRatePolicy syncRatePolicy = new ProtectGroupSyncRatePolicy();
                syncRatePolicy.setStartTime(policy.getStartTime());
                syncRatePolicy.setEndTime(policy.getEndTime());
                syncRatePolicy.setProtectLocation(schedule.getProtectLocation());
                syncRatePolicy.setSyncRateLevel(policy.getSyncRateLevel());
                syncRatePolicy.setStorage(policy.getStorageSn());
                results.add(syncRatePolicy);
            }
        }
        return results;
    }

    public static boolean isReplicationTemplate(int type) {
        return asynReplicationRelatedTemplateTypeList.contains(type);
    }

    public static void saveRPOAndRTOResult(ProtectGroup protectGroup, Map<String, Object> results) {
        if (null == protectGroup || VerifyUtil.isEmpty(results)) {
            logger.debug((Object)"saveRPOAndRTOResult Invalid parameters", 90160758784001L);
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        Set<Map.Entry<String, Object>> entrySet = results.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            props.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("protectGroupId", protectGroup.getUuid());
        try {
            List<Site> remoteSites = RecoveryServiceUtil.getRemoteSites(protectGroup);
            for (Site remoteSite : remoteSites) {
                RestClient client = SiteUtil.initClient(remoteSite);
                JSONObject object = JSONObject.fromObject(props);
                client.put("/ws/protectgroups/{protectGroupId}/action/updateProtectGroupProps", object.toString(), uriVariables);
            }
        }
        catch (Exception e) {
            logger.error((Object)("fail to syncronize protectgroup props to remote site!. PgId:" + protectGroup.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        try {
            IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            protectGroupService.saveOrUpdateProtectGroupProps(protectGroup.getUuid(), props);
        }
        catch (Exception e) {
            logger.error((Object)("Saving checking result failed. " + protectGroup.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public static int getRateLevel(List<ProtectGroupSyncRatePolicy> pgSyncRatePolicys) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = format.format(date);
        String timeHourSub = time.substring(time.length() - 8, time.length() - 6);
        Integer timeHourSubInt = NumberUtil.parseInteger((Object)timeHourSub);
        String timeStr = "";
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < pgSyncRatePolicys.size(); ++i) {
            StringBuffer startTimeBuffer = new StringBuffer();
            startTimeBuffer.append(pgSyncRatePolicys.get(i).getStartTime());
            startTimeBuffer.replace(startTimeBuffer.length() - 3, startTimeBuffer.length(), "");
            StringBuffer endTimeBuffer = new StringBuffer();
            endTimeBuffer.append(pgSyncRatePolicys.get(i).getEndTime());
            hashSet.add(startTimeBuffer.toString().trim());
            endTimeBuffer.replace(endTimeBuffer.length() - 3, endTimeBuffer.length(), "");
            hashSet.add(endTimeBuffer.toString().trim());
        }
        ArrayList<Integer> lists = new ArrayList<Integer>();
        for (String value : hashSet) {
            lists.add(NumberUtil.parseInteger((Object)value));
        }
        Collections.sort(lists);
        for (int i = lists.size() - 1; i >= 0; --i) {
            if (timeHourSubInt < (Integer)lists.get(i)) continue;
            timeStr = String.valueOf(lists.get(i));
            break;
        }
        if (timeStr.length() == 1) {
            timeStr = "0" + timeStr;
        }
        for (int j = 0; j < pgSyncRatePolicys.size(); ++j) {
            hashMap.put(pgSyncRatePolicys.get(j).getStartTime(), String.valueOf(pgSyncRatePolicys.get(j).getSyncRateLevel()));
            if (j + 1 >= pgSyncRatePolicys.size() || pgSyncRatePolicys.get(j).getEndTime().equals(pgSyncRatePolicys.get(j + 1).getStartTime())) continue;
            hashMap.put(pgSyncRatePolicys.get(j).getEndTime(), "2");
        }
        int rateLevel = NumberUtil.parseInteger(hashMap.get(timeStr + ":00"));
        logger.debug((Object)("getRateLevel end. rateLevel:" + rateLevel));
        return rateLevel;
    }

    public static boolean isLocalStorageReplica(ProtectGroupReplica replica) {
        return ReplicaUtil.isLocalStorageReplica((ProtectGroupReplica)replica);
    }

    private static boolean isEqualRemoteReplicaInGroup(ProtectGroupReplica newReplica, ProtectGroupReplica oldReplica) {
        if (null == newReplica) {
            return false;
        }
        if (null == oldReplica) {
            return false;
        }
        return newReplica.isStorageReplicationReplica() && oldReplica.isStorageReplicationReplica() && newReplica.getProtectLocation() == oldReplica.getProtectLocation();
    }

    public static void fillBackRemoteReplicasStatus(Set<ProtectGroupReplica> oldReplicaList, Set<ProtectGroupReplica> replicaList) {
        if (VerifyUtil.isEmpty(oldReplicaList) || VerifyUtil.isEmpty(replicaList)) {
            return;
        }
        block0: for (ProtectGroupReplica newReplica : replicaList) {
            for (ProtectGroupReplica oldReplica : oldReplicaList) {
                boolean isDRRingDowngrade;
                boolean isEqual = ProtectGroupUtil.isEqualRemoteReplicaInGroup(newReplica, oldReplica);
                boolean isUpdateDRRing = newReplica.isStorageReplicationReplica() && oldReplica.isStorageReplicationReplica() && newReplica.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.C.getValue() && (oldReplica.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.B_C.getValue() || oldReplica.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.A_C.getValue());
                boolean bl = isDRRingDowngrade = newReplica.isStorageReplicationReplica() && oldReplica.isStorageReplicationReplica() && (newReplica.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.B_C.getValue() || newReplica.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.A_C.getValue()) && oldReplica.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.C.getValue();
                if (!isEqual && !isUpdateDRRing && !isDRRingDowngrade) continue;
                newReplica.setStatus(oldReplica.getStatus());
                newReplica.setTimeStamp(oldReplica.getTimeStamp());
                newReplica.setId(oldReplica.getId());
                continue block0;
            }
        }
    }

    public static void clearRemoteReplicas(Set<ProtectGroupReplica> replicas) {
        if (VerifyUtil.isEmpty(replicas)) {
            return;
        }
        Iterator<ProtectGroupReplica> iterator = replicas.iterator();
        while (iterator.hasNext()) {
            ProtectGroupReplica replica = iterator.next();
            if (ProtectGroupUtil.isLocalStorageReplica(replica)) continue;
            iterator.remove();
            CommonDAOLocator.getBaseDao().getHibernateTemplate().evict((Object)replica);
        }
    }

    public static boolean isReplicaMounted(Set<ProtectGroupReplica> replicas) {
        if (VerifyUtil.isEmpty(replicas)) {
            return false;
        }
        for (ProtectGroupReplica replica : replicas) {
            List<Integer> status = Arrays.asList(ReplicaMountStatus.MOUNTED.getStatus(), ReplicaMountStatus.MOUNT_FAILED.getStatus(), ReplicaMountStatus.MOUNTING.getStatus(), ReplicaMountStatus.UMOUNTING.getStatus(), ReplicaMountStatus.UMOUNT_FAILED.getStatus());
            if (!status.contains(replica.getMountStatus())) continue;
            return true;
        }
        return false;
    }

    public static <K, V> void putObjectToMap(Map<K, List<V>> map, K k, V v) {
        List<V> list = map.get(k);
        if (null == list) {
            list = new ArrayList<V>();
        }
        if (!list.contains(v)) {
            list.add(v);
        }
        map.put(k, list);
    }

    public static boolean refreshProtectGroupReplicas(String protectGroupUuid) {
        if (VerifyUtil.isEmpty((String)protectGroupUuid)) {
            logger.error((Object)"protectGroupUuid is empty.");
            return false;
        }
        IProtectGroupService service = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        final ProtectGroup pg = service.getProtectGroupByID(protectGroupUuid);
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)("pg is empty. protectGroupUuid : " + protectGroupUuid));
            return false;
        }
        final HashSet pgReplicationAlarmInfos = new HashSet();
        final AtomicBoolean refreshResult = new AtomicBoolean(true);
        new TryCatchThrowable(){

            public void doTry() {
                ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
                IReplicaBuilder builder = factory.getTemplateByType(pg.getTemplate().getType());
                if (builder != null) {
                    Collection tempPgReplicaAlarmInfos = builder.refreshProtectGroupReplicas(pg);
                    if (VerifyUtil.isEmpty((Collection)tempPgReplicaAlarmInfos)) {
                        return;
                    }
                    pgReplicationAlarmInfos.addAll(tempPgReplicaAlarmInfos);
                }
            }

            protected void doCatch(Throwable e) {
                refreshResult.set(false);
                logger.error((Object)("refreshProtectGroupReplicas error. " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }.run();
        if (!refreshResult.get()) {
            return false;
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)pg);
        try {
            service.syncProtectGroupToRemoteSite(pg, "/ws/protectgroups/action/syncProtectGroupInfo");
        }
        catch (LegoCheckedException le) {
            logger.error((Object)le, 90160758787071L);
        }
        for (ProtectGroupReplicationAlarmInfo info : pgReplicationAlarmInfos) {
            if (info.needSendAlarm()) {
                AlarmReporter.sendNoRepeatAlarm(52625498L, protectGroupUuid, FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.MAJOR, info.getProtectGroupReplicaId(), info.getProtectGroupName(), info.getProtectGroupReplicaName(), ProtectGroupUtil.collectionToString((Collection)info.getParams().get(1)), ProtectGroupUtil.collectionToString((Collection)info.getParams().get(2)), info.getDeviceIp());
                continue;
            }
            AlarmReporter.restoreAlarm(52625498L, info.getProtectGroupReplicaId());
        }
        return true;
    }

    private static String collectionToString(Collection<String> elements) {
        if (VerifyUtil.isEmpty(elements)) {
            return "None";
        }
        StringBuilder temp = new StringBuilder("");
        for (String e : elements) {
            temp.append(e).append(",");
        }
        return temp.substring(0, temp.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, String>> getAllPgProps() {
        Session session = null;
        HashMap<String, Map<String, String>> pgPropsMap = new HashMap<String, Map<String, String>>();
        String sql = "select PGID,PROPNAME,PROPVALUE from ti_protectgroup_prop";
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createNativeQuery(sql);
            List results = query.list();
            results.stream().forEach(ele -> {
                if (ele instanceof Object[]) {
                    Object[] values = (Object[])ele;
                    String pgId = (String)values[0];
                    String propName = (String)values[1];
                    String propValue = (String)values[2];
                    HashMap<String, String> propMap = (HashMap<String, String>)pgPropsMap.get(pgId);
                    if (null == propMap) {
                        propMap = new HashMap<String, String>();
                        pgPropsMap.put(pgId, propMap);
                    }
                    propMap.put(propName, propValue);
                }
            });
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Getting pgId and ptId failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return pgPropsMap;
    }

    static class LogDetailComparator
    implements Comparator<ProtectGroupLogDetail>,
    Serializable {
        private static final long serialVersionUID = -389413815742572295L;

        LogDetailComparator() {
        }

        @Override
        public int compare(ProtectGroupLogDetail pgLogDetail1, ProtectGroupLogDetail pgLogDetail2) {
            long detail2ST;
            long detail1ST = NumberUtil.convertToLong((Object)pgLogDetail1.getStartTime());
            if (detail1ST == (detail2ST = NumberUtil.convertToLong((Object)pgLogDetail2.getStartTime()).longValue())) {
                long detail2ET;
                if (VerifyUtil.isEmpty((String)pgLogDetail1.getEndTime())) {
                    return -1;
                }
                if (VerifyUtil.isEmpty((String)pgLogDetail2.getEndTime())) {
                    return 1;
                }
                long detail1ET = NumberUtil.convertToLong((Object)pgLogDetail1.getEndTime());
                return detail1ET < (detail2ET = NumberUtil.convertToLong((Object)pgLogDetail2.getEndTime()).longValue()) ? -1 : 1;
            }
            if (detail1ST < detail2ST) {
                return -1;
            }
            return 1;
        }
    }
}

