/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.bean.AlarmParameter;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionFlowDefineMgr;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionLogManager;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectCustomStepHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyManager;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaTools;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.CloneConsistentGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.system.plugin.DrmBaseApplication;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.ism.drm.task.sdk.model.ITask;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class ProtectionTaskExecutor
extends AbstractBackTask {
    private static Log logger = LogFactory.getInstance(ProtectionTaskExecutor.class);
    private static final int DEFAULT_TIMEOUT = 1209600000;
    private ActionContext actionContext;
    private ProtectGroupLog historyLog;
    private ProtectActionLogManager logManager = ProtectActionLogManager.getInstance();
    private ProtectActionFlowDefineMgr actionManager = ProtectActionFlowDefineMgr.getInstance();
    private ProtectionTask task;
    private ProtectGroup protectGroup;
    private Schedule schedule;
    private boolean executeResult = false;
    private List<AbstractBaseProtectAction> actions;
    private Date startTime;
    private Map<String, Object> parameter;
    private int executionMode;
    private boolean mergeAction = false;

    public ProtectionTaskExecutor(ProtectionTask task) {
        this(task, null, 0);
    }

    public ProtectionTaskExecutor(ProtectionTask task, Map<String, Object> parameter) {
        this(task, parameter, 1);
    }

    private ProtectionTaskExecutor(ProtectionTask task, Map<String, Object> parameter, int executionMode) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)task.getProtectGroup().getName(), (String)"", (String)"System", (String)"", null), 1209600000, false);
        this.task = task;
        this.schedule = task.getSchedule();
        this.protectGroup = task.getProtectGroup();
        this.schedule.setPolicyTemplate(this.protectGroup.getTemplate());
        this.actionContext = new ActionContext();
        this.historyLog = new ProtectGroupLog();
        this.parameter = parameter;
        this.executionMode = executionMode;
        if (null != parameter && "true".equals(parameter.get("MergeProtectAction"))) {
            this.mergeAction = true;
        }
    }

    public ProtectionTask getTask() {
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        this.lockProtectGroup();
        try {
            this.preExecute();
            this.execute();
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            logger.error((Object)("Execute the task failed,pgId:" + this.protectGroup.getUuid() + " name:" + this.protectGroup.getName()), (Throwable)e, e.getErrorCode());
            throw new LegoCheckedException(errorCode, (Throwable)e);
        }
        catch (Exception e) {
            String errorMsg = "Execute the task failed,pgId:" + this.protectGroup.getUuid() + " name:" + this.protectGroup.getName();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            this.postExecute();
            ProtectionJobUtil.getInstance().releaseLockPg(this.protectGroup.getUuid());
        }
    }

    private void preExecute() {
        this.initEffectiveData();
        this.checkProtectGroupStatus();
        this.checkRemoteGroupStatus();
    }

    private void initEffectiveData() {
        String pgId = this.task.getProtectGroup().getUuid();
        try {
            IProtectGroupService pgService = ProtectionJobUtil.getInstance().getProtectGroupService();
            if (pgService == null) {
                logger.error((Object)("can not get IProtectGroupService:" + pgId));
                throw new LegoCheckedException(1073947394L);
            }
            this.protectGroup = pgService.getProtectGroupByID(pgId);
        }
        catch (Exception e) {
            logger.error((Object)("can not get pg:" + pgId));
            ExceptionUtil.rethrowException((Throwable)e, (String)("ProtectGroup(" + pgId + ") not exist"), (long)1073948446L, (String[])new String[0], (Log)logger);
        }
        this.actionContext.addObject("PG_ENTITY", (Object)this.protectGroup);
        this.actionContext.addObject("TASK_ENTITY", (Object)this.task);
        this.actionContext.addObject("EXCUTE_PARAMETER_MAP", this.parameter);
    }

    private void checkProtectGroupStatus() {
        if (!ProtectionJobUtil.getInstance().isStatusAvailable(this.protectGroup)) {
            logger.error((Object)"status unavailable");
            throw new LegoCheckedException(1073948178L);
        }
    }

    private void checkRemoteGroupStatus() {
        Set<String> disasterSites = RecoveryServiceUtil.getDisasterSiteIds(this.protectGroup);
        if (null == disasterSites || disasterSites.isEmpty()) {
            return;
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("protectGroupId", this.protectGroup.getUuid());
        String url = "/ws/protectgroups/{protectGroupId}";
        for (String recoverySiteId : disasterSites) {
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
            if (site.getSiteType() != 1) continue;
            RestClient client = SiteUtil.initClient(site);
            String str = client.invoke(url, uriVariables, HttpMethod.GET);
            JSONObject jSONObject = JSONObject.fromObject((Object)str);
            Integer remoteStatus = null;
            if (jSONObject.containsKey((Object)"status")) {
                remoteStatus = jSONObject.getInt("status");
            }
            if (null == remoteStatus) {
                logger.error((Object)"remote status unavailable");
                throw new LegoCheckedException(1073948178L);
            }
            ProtectGroup pg = new ProtectGroup();
            pg.setStatus(remoteStatus.intValue());
            if (ProtectionJobUtil.getInstance().isStatusAvailable(pg)) continue;
            logger.error((Object)"remote status unavailable");
            throw new LegoCheckedException(1073948178L);
        }
    }

    private void execute() {
        this.updateStartStatus();
        this.actions = this.getExecuteActions();
        if (this.protectGroup.getPoType() == 11 && this.protectGroup.getTemplate().getType() == 2) {
            ProtectCustomStepHelper.checkScriptParams(this.schedule, this.actions);
        }
        this.createProtectLog();
        this.executeActions(this.actions);
        this.handleExecutedReplica();
        this.dealReplicaBySnapshotCount();
        this.handleExecuteResult();
    }

    private void postExecute() {
        try {
            this.updateFinishStatus();
        }
        catch (Exception e) {
            String errorMsg = "Execute the task failed,pgId:" + this.protectGroup.getUuid() + " name:" + this.protectGroup.getName();
            logger.error((Object)(errorMsg + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            this.logManager.unregisterRunningLog(this.protectGroup.getUuid());
        }
    }

    private void dealReplicaBySnapshotCount() {
        ProtectGroup pg = (ProtectGroup)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroup.class, (Serializable)((Object)this.protectGroup.getUuid()));
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)String.format("pg is null. the uuid of pg is %s", this.protectGroup.getUuid()));
            throw new LegoCheckedException(1073947394L);
        }
        PolicyTemplate template = pg.getTemplate();
        if (null != template && null != template.getSchedules()) {
            template.getSchedules().forEach(sc -> sc.setPolicyTemplate(template));
        }
        ((IReplicaRetentionStrategyManager)ServiceLocator.getInstance().getService(IReplicaRetentionStrategyManager.class)).executeStrategy(pg);
    }

    private void handleExecuteResult() {
        if (this.executeResult) {
            AlarmReporter.restoreAlarm(52625416L, this.protectGroup.getUuid());
        } else {
            AlarmParameter alarm = ProtectionJobUtil.getInstance().createAlarm(this.actionContext, this.protectGroup);
            ProtectionJobUtil.getInstance().genetateAlarm(alarm);
        }
        this.sendNotification(this.executeResult);
    }

    private void updateFinishStatus() {
        try {
            logger.info((Object)"begin to update finish status", 90160758784000L);
            if (null != this.protectGroup && this.protectGroup.getStatus() == DrmEnumDefine.PROTECT_GROUP_STATUS.RUNNING.getStatus()) {
                this.protectGroup.setStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL.getStatus());
                ProtectionJobUtil.getInstance().updateProtectGroupEndStatus(this.protectGroup);
            }
            if (null != this.task) {
                ITaskManager protectionTaskManager = (ITaskManager)ServiceLocator.getInstance().getService(ITaskManager.class);
                Date nextExecTime = protectionTaskManager.getNextExecTime((ITask)this.task, false);
                this.task.setStatus(1);
                this.task.setLastExecTime(String.valueOf(this.startTime.getTime()));
                this.task.setNextExecTime(null == nextExecTime ? null : String.valueOf(nextExecTime.getTime()));
                ((IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class)).updateTask(this.task);
            }
            if (null != this.historyLog) {
                this.historyLog.setFlag(Integer.valueOf(1));
                this.logManager.saveOrUpdateProtectGroupLog(this.historyLog);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Finally update status failed,pgId:" + this.protectGroup.getUuid() + " name:" + this.protectGroup.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    private void lockProtectGroup() {
        String pgId = this.protectGroup.getUuid();
        try {
            ProtectionJobUtil.getInstance().checkIsNeedLock(pgId);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("ProtectGroup(" + pgId + ") not exist"), (long)1073948446L, (String[])new String[0], (Log)logger);
        }
        logger.info((Object)("lock pg success,pgId:" + pgId), 90160758784001L);
    }

    private void updateStartStatus() {
        this.task.setStatus(3);
        this.setStartTime();
        ((IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class)).updateTask(this.task);
        this.protectGroup.setStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.RUNNING.getStatus());
        this.protectGroup.setLastExecTime(Long.valueOf(this.startTime.getTime()));
        ProtectionJobUtil.getInstance().updateProtectGroupStartStatus(this.protectGroup);
    }

    private void setStartTime() {
        long nextExecTime;
        this.schedule = this.task.getSchedule();
        Date currentTime = new Date();
        logger.info((Object)("job begin  time : " + currentTime.getTime()), 90160767696896L);
        long l = nextExecTime = VerifyUtil.isEmpty((String)this.task.getNextExecTime()) ? 0L : NumberUtil.convertToLong((Object)this.task.getNextExecTime());
        if (nextExecTime > currentTime.getTime() && this.schedule.getScheduleMode() == 0 && 1 != this.executionMode) {
            logger.info((Object)"nextExecTime is bigger than currentTime", 90160767696896L);
            this.startTime = new Date(nextExecTime);
            this.actionContext.addObject("PG_EXECUTE_START_TIME", (Object)this.startTime);
        } else {
            this.startTime = currentTime;
            this.actionContext.addObject("PG_EXECUTE_START_TIME", (Object)currentTime);
        }
        ITaskManager protectionTaskManager = (ITaskManager)ServiceLocator.getInstance().getService(ITaskManager.class);
        Date date = protectionTaskManager.getNextExecTime((ITask)this.task, false);
        if (!VerifyUtil.isEmpty((Object)date)) {
            this.actionContext.addObject("PG_NEXT_FIRE_TIME", (Object)date.getTime());
        }
        if (1 == this.executionMode) {
            return;
        }
        if (!ProtectionJobUtil.getInstance().isTimeAvailable(this.task)) {
            logger.error((Object)"time unavailable");
            throw new LegoCheckedException(1073948179L);
        }
        if (!ProtectionJobUtil.getInstance().isTimeInRange((ISchedule)this.schedule, this.startTime)) {
            protectionTaskManager.resetNextExecuteTime((ITask)this.task, this.startTime);
        }
    }

    private void createProtectLog() {
        this.historyLog.setPgId(this.protectGroup.getUuid());
        this.historyLog.setFlag(Integer.valueOf(0));
        this.historyLog.setInfo(this.protectGroup.getName() + "execute log");
        this.historyLog.setStartTime(String.valueOf(this.startTime.getTime()));
        this.protectGroup.getPgHistoryLogs().add(this.historyLog);
        this.actionContext.addObject("PG_LOG_ENTITY", (Object)this.historyLog);
        this.logManager.registerRunningLog(this.protectGroup.getUuid(), this.historyLog);
        this.logManager.saveOrUpdateProtectGroupLog(this.historyLog);
    }

    private List<AbstractBaseProtectAction> getJoinedManualActions(int templateType, int appType) {
        Set<Integer> allProtectLocation = ProtectGroupUtil.getInstance().getAllPgProtectLocation(this.protectGroup);
        ArrayList<AbstractBaseProtectAction> allActions = new ArrayList<AbstractBaseProtectAction>();
        for (Integer location : allProtectLocation) {
            allActions.addAll(this.actionManager.getProtectActions(this.protectGroup.getUuid(), templateType, appType, location, this.schedule.getProtectedType()));
            if (VerifyUtil.isEmpty(allActions)) continue;
            this.actionContext.addObject("PG_EXECUTE_LOCATION", (Object)location);
        }
        return allActions;
    }

    public static String getClassName() {
        logger.trace((Object)"getClassName");
        String className = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            Object[] element = e.getStackTrace();
            if (!VerifyUtil.isEmpty((Object[])element)) {
                className = ((StackTraceElement)element[0]).getClassName();
            }
            return className;
        }
    }

    private void executeActions(List<AbstractBaseProtectAction> actionList) {
        this.actionManager.initActions(actionList, this.protectGroup, this.actionContext, 0);
        this.logManager.initRunningDetail(this.protectGroup.getUuid(), actionList);
        this.executeResult = false;
        int index = 0;
        for (AbstractBaseProtectAction action : actionList) {
            if (!action.isEnable()) continue;
            this.recordStartLogDetail(action, index);
            this.executeResult = this.executeSingleAction(action);
            this.recordFinishLogDetail(action);
            ++index;
            if (this.executeResult) continue;
            this.protectGroup.setLastExecErrorDetail(action.getDetail());
            this.protectGroup.setLastExecParam(action.getDetailParams());
            this.callbackAction(action);
            if (!action.getIngoreFailure().booleanValue()) break;
            this.executeResult = true;
        }
        this.recordFinishProtectGroupLog();
    }

    private void callbackAction(AbstractBaseProtectAction action) {
        try {
            action.callBack(this.actionContext);
        }
        catch (Exception e) {
            logger.error((Object)("post Execute error!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
        }
    }

    private boolean executeSingleAction(AbstractBaseProtectAction action) {
        this.executeResult = false;
        try {
            action.preExcute(this.actionContext);
        }
        catch (Exception e) {
            logger.error((Object)("action execute error ,action " + action.getClass().getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 0x300001L);
        }
        try {
            this.executeResult = action.execute(this.actionContext);
        }
        catch (Throwable e) {
            logger.error((Object)("action execute error ,action " + action.getClass().getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 0x300001L);
            this.executeResult = false;
        }
        try {
            action.postExcute(this.actionContext);
        }
        catch (Exception e) {
            logger.error((Object)("action post execute error ,action " + action.getClass().getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 0x300001L);
        }
        return this.executeResult;
    }

    private void handleExecutedReplica() {
        try {
            List<ProtectGroupReplica> replicas = this.getExecutedReplica();
            if (VerifyUtil.isEmpty(replicas)) {
                logger.error((Object)"executed replica isEmpty");
                return;
            }
            int status = this.getReplicaStatus(this.executeResult);
            if (ExecuteReplicaManager.getInstance().getRealTimeReplicaPolicyType().contains(this.protectGroup.getTemplate().getType())) {
                this.handleReplicasByStatus(replicas, status);
            } else {
                for (ProtectGroupReplica replica : replicas) {
                    this.updateReplica(replica, status);
                    ProtectionJobUtil.getInstance().updatePrtectGroupReplicaStatus(replica);
                }
            }
            this.handleLogReplicaId(replicas, status);
            this.handleToDeleteProtectGroupReplica();
            logger.info((Object)("Update protectGroupReplica status,pgId:" + this.protectGroup.getUuid() + " name:" + this.protectGroup.getName()), 90160758786988L);
        }
        catch (Exception e) {
            logger.error((Object)("Update protectGroupReplica status failed, pgId:" + this.protectGroup.getUuid() + " name:" + this.protectGroup.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    private void handleReplicasByStatus(List<ProtectGroupReplica> replicas, int status) {
        block3: {
            block2: {
                if (1 != status) break block2;
                for (ProtectGroupReplica replica : replicas) {
                    this.updateReplica(replica, status);
                    replica.setPg(this.protectGroup);
                    this.saveExecutedReplica(replica);
                }
                break block3;
            }
            if (!this.isNeedCallBack()) break block3;
            for (ProtectGroupReplica replica : replicas) {
                replica.setDeleteMode(ProtectGroupReplica.DeleteMode.ASYNC);
                ExecuteReplicaManager.getInstance().callBackReplica(this.protectGroup.getTemplate().getType(), replica);
            }
        }
    }

    private boolean isNeedCallBack() {
        Boolean needCallBack = (Boolean)this.actionContext.getObject("REPLICA_NEED_CALLBACK");
        if (null == needCallBack) {
            return true;
        }
        return needCallBack;
    }

    private void handleToDeleteProtectGroupReplica() {
        ProtectGroupReplica oldPgReplica;
        if (this.executeResult && null != (oldPgReplica = (ProtectGroupReplica)this.actionContext.getObject("PROTECTGROUP_REPLICA_TO_DELETE"))) {
            logger.info((Object)("old replica need to delete." + oldPgReplica.getId()));
            CheckReplicaTools.updateProtectGroupReplicaStatus(oldPgReplica.getId(), DrmEnumDefine.REPLICA_STATUS.ERROR_STATUS.getValue());
        }
    }

    private void handleLogReplicaId(List<ProtectGroupReplica> replicas, int status) {
        if (1 == status) {
            StringBuffer logReplicaId = new StringBuffer();
            for (ProtectGroupReplica replica : replicas) {
                logReplicaId.append(replica.getId()).append(',');
            }
            String id = logReplicaId.toString().substring(0, logReplicaId.length() - 1);
            this.historyLog.setReplicaId(id);
        }
    }

    private List<ProtectGroupReplica> getExecutedReplica() {
        ArrayList<ProtectGroupReplica> result = new ArrayList<ProtectGroupReplica>();
        if (1 == this.executionMode && this.mergeAction) {
            ProtectGroupReplica oneStage = (ProtectGroupReplica)this.actionContext.getObject("FIRST_STAGE_REPLICA");
            ProtectGroupReplica twoStage = (ProtectGroupReplica)this.actionContext.getObject("SECOND_STAGE_REPLICA");
            result.add(oneStage);
            result.add(twoStage);
        } else {
            ProtectGroupReplica replica = (ProtectGroupReplica)this.actionContext.getObject("FIRST_STAGE_REPLICA");
            if (VerifyUtil.isEmpty((Object)replica)) {
                replica = (ProtectGroupReplica)this.actionContext.getObject("SECOND_STAGE_REPLICA");
            }
            if (VerifyUtil.isEmpty((Object)replica)) {
                replica = (ProtectGroupReplica)this.actionContext.getObject("PG_REPLICA_ENTITY");
            }
            result.add(replica);
        }
        return result;
    }

    private void updateReplica(ProtectGroupReplica toUpdateReplica, int status) {
        if (null == toUpdateReplica || VerifyUtil.isEmpty((String)toUpdateReplica.getId())) {
            logger.error((Object)"updateReplica is illegel.");
            return;
        }
        logger.debug((Object)("updateReplica" + toUpdateReplica.getId()));
        toUpdateReplica.setStatus(status);
        toUpdateReplica.setTimeStamp(this.getUpdateTimeStamp());
    }

    private String getUpdateTimeStamp() {
        String timeStamp = (String)this.actionContext.getObject("REPLICA_TIMESTANP");
        return VerifyUtil.isEmpty((String)timeStamp) ? String.valueOf(new Date().getTime()) : timeStamp;
    }

    private int getReplicaStatus(boolean jobResult) {
        int status = jobResult ? 1 : 3;
        logger.debug((Object)("getReplicaStatus" + status));
        return status;
    }

    private void recordStartLogDetail(AbstractBaseProtectAction action, int index) {
        logger.debug((Object)("start excute action,action id :" + action.getActionId() + " action name:" + action.getName()), 90160758786988L);
        ProtectGroupLogDetail detail = this.logManager.getActionLogDetail(this.protectGroup.getUuid(), action.getActionId());
        if (detail == null) {
            logger.error((Object)"detail is null!");
            throw new LegoCheckedException(1073947394L);
        }
        Date currentDate = index == 0 ? this.startTime : new Date();
        detail.setStartTime(String.valueOf(currentDate.getTime()));
        detail.setResult(2L);
        detail.setProtectedType(action.getProtectedType());
        this.logManager.saveOrUpdateProtectGroupLogDetail(detail);
    }

    private void recordFinishLogDetail(AbstractBaseProtectAction action) {
        logger.debug((Object)("end excute action,action id :" + action.getActionId() + " action name:" + action.getName()), 90160758786988L);
        ProtectGroupLogDetail detail = this.logManager.getActionLogDetail(this.protectGroup.getUuid(), action.getActionId());
        if (detail == null) {
            logger.error((Object)"detail is null!");
            throw new LegoCheckedException(1073947394L);
        }
        Date currentDate = new Date();
        detail.setEndTime(String.valueOf(currentDate.getTime()));
        detail.setInfo(action.getDetail());
        detail.setInfoParams(action.getDetailParams());
        detail.setResult(this.executeResult ? 1L : 0L);
        this.logManager.saveOrUpdateProtectGroupLogDetail(detail);
    }

    private void recordFinishProtectGroupLog() {
        Date execEndTime = new Date();
        this.historyLog.setResult(this.executeResult ? 1L : 0L);
        this.historyLog.setEndTime(String.valueOf(execEndTime.getTime()));
        this.protectGroup.setLastExecResult(Integer.valueOf(this.executeResult ? 1 : 0));
    }

    private void saveExecutedReplica(final ProtectGroupReplica replica) {
        TransactionCallback transactionCallback = new TransactionCallback(){

            public Object doInTransaction(TransactionStatus tstatus) {
                try {
                    CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)replica);
                    Object cloneCGObj = ProtectionTaskExecutor.this.actionContext.getObject("CloneCG");
                    if (null != cloneCGObj) {
                        CloneConsistentGroup cloneCG = (CloneConsistentGroup)cloneCGObj;
                        cloneCG.setPgReplicaId(replica.getId());
                        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)cloneCG);
                    }
                }
                catch (Exception e) {
                    if (null != tstatus) {
                        tstatus.setRollbackOnly();
                    }
                    if (ExceptionUtil.isSpecialException((Throwable)e)) {
                        logger.error((Object)("save new replica error,pgName: " + ProtectionTaskExecutor.this.protectGroup.getName() + "and message is " + ExceptionUtil.getErrorMessage((Throwable)e)));
                    }
                    logger.error((Object)("save new replica error,pgName: " + ProtectionTaskExecutor.this.protectGroup.getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                return null;
            }
        };
        CommonDAOLocator.getBaseDao().getTransactionTemplate().execute(transactionCallback);
    }

    private void sendNotification(boolean isSuccessful) {
        logger.debug((Object)("sendNotification " + isSuccessful));
        long cmdCode = isSuccessful ? 20001L : 20002L;
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(cmdCode);
        ProtectGroupReplica latestReplica = (ProtectGroupReplica)this.actionContext.getObject("PG_REPLICA_ENTITY", ProtectGroupReplica.class);
        HashedMap messageMap = new HashedMap();
        messageMap.put("MESSAGE_EXCUTE_PARAMETER_KEY", this.parameter);
        if (latestReplica == null) {
            logger.error((Object)"LatestReplica is null");
            throw new LegoCheckedException(2117645L);
        }
        messageMap.put("MESSAGE_EXCUTE_LATEST_REPLICA_ID", latestReplica.getId());
        mu.setObj((Object)messageMap);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(DrmBaseApplication.class.getName());
        ((IMessageCenter)ServiceLocator.getInstance().getService(IMessageCenter.class)).sendMessage(mu);
    }

    private List<AbstractBaseProtectAction> getExecuteActions() {
        List<AbstractBaseProtectAction> list = null;
        int templateType = this.protectGroup.getTemplate().getType();
        int appType = this.protectGroup.getPoType();
        if (this.mergeAction) {
            list = this.getJoinedManualActions(templateType, appType);
        } else {
            this.actionContext.addObject("PG_EXECUTE_LOCATION", (Object)this.schedule.getProtectLocation());
            int protectLocation = this.schedule.getProtectLocation();
            logger.info((Object)("execute pg location" + protectLocation));
            if (PolicyTemplateTools.getInstance().ingoreLocationType(this.protectGroup.getTemplate().getType())) {
                protectLocation = -1;
            }
            list = this.actionManager.getProtectActions(this.protectGroup.getUuid(), templateType, appType, protectLocation, this.schedule.getProtectedType());
        }
        if (VerifyUtil.isEmpty(list)) {
            logger.error((Object)("Task failed and pgId:" + this.protectGroup.getUuid() + " name:" + this.protectGroup.getName()), 90160758784001L);
            throw new LegoCheckedException(1073948446L);
        }
        return list;
    }
}

