/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class RefreshProtectGroupBackTask
extends AbstractBackTask
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(RefreshProtectGroupBackTask.class);
    private static List<Integer> supportPtTransferList = Arrays.asList(3, 5);
    private ProtectGroupServiceImpl service;
    private ProtectGroup protectGroup;

    public RefreshProtectGroupBackTask(ProtectGroupServiceImpl service, ProtectGroup protectGroup) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.pg.ref.log.motion", (String)"System", (String)"", null), true);
        this.service = service;
        this.protectGroup = protectGroup;
        String protectGroupId = protectGroup.getUuid();
        service.lockProtectGroup(protectGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        this.protectGroup = this.service.getProtectGroupByID(this.protectGroup.getUuid());
        Long errorCode = 0L;
        String protectGroupId = this.protectGroup.getUuid();
        int protectGroupStatus = this.protectGroup.getStatus();
        MessageEvent event = this.constructUpdateMessage();
        try {
            this.service.notifyObserverList(event, "before");
            this.service.getBaseDao().getTransactionTemplate().execute((TransactionCallback)this);
            this.service.notifyObserverList(event, "after");
        }
        catch (LegoCheckedException e) {
            errorCode = e.getErrorCode();
            if (0L == errorCode) {
                errorCode = -1L;
            }
            logger.error((Object)"failed to refresh protectobject.", (Throwable)e, errorCode.longValue());
            ExceptionUtil.rethrowException((Exception)((Object)e), (String)"failed to refresh protectobject!", (long)errorCode, (String[])e.getParameters());
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to refresh protectobject.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            this.doFinishWork(errorCode, protectGroupId, protectGroupStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinishWork(Long errorCode, String protectGroupId, int protectGroupStatus) {
        try {
            boolean refreshResult = ProtectGroupUtil.refreshProtectGroupReplicas(protectGroupId);
            if (DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus() == protectGroupStatus) {
                this.recoveryProtectGroupRelativeStatus(errorCode, protectGroupId, refreshResult);
            } else {
                this.refreshProtectGroupStatus(errorCode, protectGroupId, refreshResult);
            }
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
    }

    private void refreshProtectGroupStatus(Long errorCode, String protectGroupId, boolean refreshResult) {
        this.service.unlockProtectGroup(protectGroupId);
        if (0L == errorCode && refreshResult) {
            this.service.updateProtectGroupStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL, protectGroupId);
            return;
        }
        AlarmReporter.sendAlarm(52625421L, this.protectGroup.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.CRITICAL, this.protectGroup.getUuid(), this.protectGroup.getName(), this.protectGroup.getPoProviderSN());
        this.service.updateProtectGroupStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID, protectGroupId);
    }

    private void recoveryProtectGroupRelativeStatus(Long errorCode, String protectGroupId, boolean refreshResult) {
        if (0L == errorCode && refreshResult) {
            this.service.createProtectionTask(this.protectGroup);
            ITaskManager protectionTaskManager = (ITaskManager)ServiceLocator.getInstance().getService(ITaskManager.class);
            protectionTaskManager.resumeGroup(protectionTaskManager.getGroupName(this.protectGroup.getUuid()));
            AlarmReporter.restoreAlarm(52625421L, protectGroupId);
            this.service.updateProtectGroupStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL, protectGroupId);
        }
    }

    public Object doInTransaction(TransactionStatus status) {
        HibernateTemplate template = this.service.getBaseDao().getHibernateTemplate();
        try {
            this.service.getProtectObjectProvider(this.protectGroup.getPoType()).refreshProtectGroup(this.protectGroup);
            this.service.syncProtectGroupToRemoteSite(this.protectGroup, "/ws/protectgroups/action/syncProtectGroupInfo");
            if (supportPtTransferList.contains(this.protectGroup.getTemplate().getType())) {
                template.saveOrUpdate((Object)this.protectGroup.getTemplate());
            }
            template.saveOrUpdate((Object)this.protectGroup);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"failed to refresh protectobject.", (Throwable)le, le.getErrorCode());
            status.setRollbackOnly();
            ExceptionUtil.rethrowException((Exception)((Object)le), (String)"failed to refresh protectobject.", (long)le.getErrorCode(), (String[])le.getParameters());
        }
        catch (DataAccessException e) {
            logger.error((Object)"failed to refresh protectobject because of saving error.", (Throwable)e, -1L);
            status.setRollbackOnly();
            ExceptionUtil.rethrowException((Exception)((Object)e), (String)"failed to refresh protectobject because of saving error.", (long)-1L, (String[])new String[0]);
        }
        catch (Exception e) {
            status.setRollbackOnly();
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to refresh protectobject.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        return null;
    }

    private MessageEvent constructUpdateMessage() {
        MessageEvent event = new MessageEvent();
        event.setMessageType(1);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(this.protectGroup);
        event.setObjectList(objectList);
        return event;
    }
}

