/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.UpdatePolicyTemplateTransaction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import org.springframework.transaction.support.TransactionCallback;

public class UpdatePolicyTemplateBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(UpdatePolicyTemplateBackTask.class);
    private ProtectGroupServiceImpl service;
    private ProtectGroup protectGroup;
    private PolicyTemplate policyTemplate;

    public UpdatePolicyTemplateBackTask(ProtectGroupServiceImpl service, ProtectGroup protectGroup, PolicyTemplate policyTemplate) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.pg.updatePolicyTemplate", (String)"System", (String)"", null), true);
        this.service = service;
        this.protectGroup = protectGroup;
        this.policyTemplate = policyTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        String protectGroupId = this.protectGroup.getUuid();
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            logger.error((Object)("The pg is locked: " + protectGroupId), 90160758786893L);
            throw new LegoCheckedException(102401L);
        }
        try {
            this.protectGroup = this.service.getProtectGroupByID(protectGroupId);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.PROTECT_GROUP_OPT.UPDATE_TEMPLATE, this.protectGroup);
            PolicyTemplate olderPolicyTemplate = this.protectGroup.getTemplate();
            if (!olderPolicyTemplate.getUuid().equals(this.policyTemplate.getUuid())) {
                logger.error((Object)"old template uuid is not equal with new template uuid!");
                throw new LegoCheckedException(1073947394L);
            }
            UpdatePolicyTemplateTransaction callback = new UpdatePolicyTemplateTransaction(this.service, this.protectGroup, olderPolicyTemplate, this.policyTemplate);
            this.service.getBaseDao().getTransactionTemplate().execute((TransactionCallback)callback);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("failed to update ProtectGroup's Template(" + protectGroupId + ")."), (Throwable)e, e.getErrorCode());
            ExceptionUtil.rethrowException((Exception)((Object)e), (String)("failed to update ProtectGroup's Template(" + protectGroupId + ")."), (long)e.getErrorCode(), (String[])e.getParameters());
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to update ProtectGroup's Template(" + protectGroupId + ")."), (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
    }
}

