/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class UpdatePolicyTemplateTransaction
implements TransactionCallback {
    private static Log logger = LogFactory.getInstance(UpdatePolicyTemplateTransaction.class);
    private ProtectGroupServiceImpl service = null;
    private ProtectGroup protectGroup = null;
    private PolicyTemplate oldPolicyTemplate;
    private PolicyTemplate policyTemplate;
    private List<ProtectionTask> taskList;

    public UpdatePolicyTemplateTransaction(ProtectGroupServiceImpl service, ProtectGroup protectGroup, PolicyTemplate oldPolicyTemplate, PolicyTemplate policyTemplate) {
        this.service = service;
        this.oldPolicyTemplate = oldPolicyTemplate;
        this.policyTemplate = policyTemplate;
        this.protectGroup = protectGroup;
        if (null == protectGroup) {
            logger.error((Object)"protectgroup is null!");
            throw new LegoCheckedException(1073947393L);
        }
        this.taskList = service.getProtectionTaskService().getTasks(protectGroup.getUuid());
    }

    public Object doInTransaction(TransactionStatus tstatus) {
        try {
            this.protectGroup.setTemplate(this.policyTemplate);
            this.service.getProtectionTaskService().updateTasks(this.protectGroup, this.taskList, this.oldPolicyTemplate);
            this.service.getPolicyTemplateManager().updateTemplate(this.policyTemplate);
            this.service.syncProtectGroupToRemoteSite(this.protectGroup, "/ws/protectgroups/action/syncProtectGroupInfo");
            this.service.getBaseDao().getHibernateTemplate().update((Object)this.protectGroup);
        }
        catch (LegoCheckedException le) {
            tstatus.setRollbackOnly();
            ExceptionUtil.rethrowException((Throwable)le, (String)("Failed to modify protectgroup policy. " + this.protectGroup.getName()), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
        }
        catch (Exception e) {
            tstatus.setRollbackOnly();
            ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to create protectgroup. " + this.protectGroup.getName()), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return null;
    }
}

