/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

public class UpdateProtectGroupInfoTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(UpdateProtectGroupInfoTask.class);
    private static List<Integer> localPgType = new ArrayList<Integer>();
    private ProtectGroupServiceImpl service;
    private IBaseDao<?, ?> callBackBaseDao;
    private ProtectGroup protectGroup;

    public UpdateProtectGroupInfoTask(ProtectGroupServiceImpl service, ProtectGroup protectGroup) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.protect.group.modify", (String)"System", (String)"", null), true);
        this.service = service;
        this.callBackBaseDao = service.getBaseDao();
        this.protectGroup = protectGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doWork() {
        Session session;
        block7: {
            session = null;
            try {
                if (this.getTemplateType(this.protectGroup.getUuid()) && this.checkGroupIsPrimary()) {
                    this.syncInfo();
                }
                session = this.callBackBaseDao.getHibernateTemplate().getSessionFactory().openSession();
                session.beginTransaction();
                String sql = "UPDATE ti_protectgroup SET PGNAME=:pgName,PGDESC=:desc WHERE PGID=:pgid";
                NativeQuery query = session.createSQLQuery(sql);
                query.setString("pgName", this.protectGroup.getName());
                query.setString("desc", this.protectGroup.getDescription());
                query.setString("pgid", this.protectGroup.getUuid());
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (1 == updateResult) break block7;
                logger.error((Object)"Update protectGroup basic info failed!", 90160758786989L);
                throw new LegoCheckedException(-1L);
            }
            catch (LegoCheckedException e) {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Update protectGroup basic info failed!", e.getErrorCode());
                ExceptionUtil.rethrowException((Exception)((Object)e), (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters());
                DBOperationUtil.closeSession(session);
            }
            catch (Exception ex) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"Update protectGroup basic info failed!", (long)-1L, (String[])new String[0], (Log)logger);
                {
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void syncInfo() {
        block11: {
            Session session = null;
            try {
                PolicyTemplate template;
                ProtectGroup oldPg = QueryProtectGroupRefineService.getInstance().getProtectGroupBasicInfo(this.protectGroup.getUuid(), false);
                if (null != oldPg && null != (template = oldPg.getTemplate()) && 16 == template.getType()) {
                    logger.debug((Object)("the pg template type is array_hyper_clone, no need sync info to remote, type=" + template.getType()));
                    DBOperationUtil.closeSession(session);
                    return;
                }
                session = this.callBackBaseDao.getHibernateTemplate().getSessionFactory().openSession();
                String replicaSql = "SELECT DISTINCT RECSITEID FROM ti_protectgroupreplica WHERE PGID=:pgid";
                NativeQuery query = session.createSQLQuery(replicaSql);
                query.setString("pgid", this.protectGroup.getUuid());
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) {
                    logger.error((Object)"Get recoverySite from database failed!", 90160758786989L);
                    throw new LegoCheckedException(-1L);
                }
                ArrayList<String> recoverySiteIds = new ArrayList<String>();
                for (int i = 0; i < results.size(); ++i) {
                    Object obj = results.get(i);
                    if (!(obj instanceof String)) continue;
                    recoverySiteIds.add((String)obj);
                }
                ProtectGroup pg = new ProtectGroup();
                pg.setUuid(this.protectGroup.getUuid());
                pg.setName(this.protectGroup.getName());
                pg.setDescription(this.protectGroup.getDescription());
                this.service.syncUpdateProtectGroupInfoToRemoteSite(recoverySiteIds, pg);
                DBOperationUtil.closeSession(session);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Update protectGroup basic info failed!", e.getErrorCode());
                ExceptionUtil.rethrowException((Exception)((Object)e), (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters());
                DBOperationUtil.closeSession(session);
            }
            catch (Exception ex) {
                ExceptionUtil.rethrowException((Throwable)ex, (String)"Update protectGroup basic info failed!", (long)-1L, (String[])new String[0], (Log)logger);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DBOperationUtil.closeSession(session);
            }
        }
    }

    private boolean checkGroupIsPrimary() {
        boolean bl;
        Session session;
        block5: {
            session = null;
            session = this.callBackBaseDao.getHibernateTemplate().getSessionFactory().openSession();
            String sql = "select PGID from ti_protectgroup where ISPRIMARY=:primary and PGID=:pgid";
            NativeQuery query = session.createSQLQuery(sql);
            query.setBoolean("primary", true);
            query.setString("pgid", this.protectGroup.getUuid());
            List results = query.list();
            if (VerifyUtil.isEmpty((Collection)results)) break block5;
            boolean bl2 = true;
            DBOperationUtil.closeSession(session);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to check GroupName because of query error.", (Throwable)e, 90160758786894L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return bl;
    }

    private boolean getTemplateType(String id) {
        boolean bl;
        Session session = null;
        try {
            session = this.callBackBaseDao.getHibernateTemplate().getSessionFactory().openSession();
            String sql = "select pt.TYPE from ti_protectgroup pg, ti_policytemplate pt where pg.PGID=:id and pg.PTID=pt.PTID";
            NativeQuery query = session.createSQLQuery(sql);
            query.setString("id", id);
            List results = query.list();
            int type = 2;
            int i = 0;
            if (i < results.size()) {
                type = (Integer)results.get(i);
            }
            bl = !localPgType.contains(type);
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to getTemplateType because of database error.", (Throwable)e, 90160758786894L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return bl;
    }

    static {
        localPgType.add(15);
        localPgType.add(2);
        localPgType.add(14);
        localPgType.add(17);
        localPgType.add(28);
        localPgType.add(19);
        localPgType.add(25);
        localPgType.add(29);
        localPgType.add(30);
        localPgType.add(31);
        localPgType.add(32);
    }
}

