/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class UpdateScheduleTask
extends AbstractBackTask
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(UpdateScheduleTask.class);
    private ProtectGroupServiceImpl service;
    private ProtectGroup protectGroup;
    private Schedule schedule;
    private Schedule oldSchedule;

    UpdateScheduleTask(ProtectGroupServiceImpl service, ProtectGroup protectGroup, Schedule schedule, Schedule oldSchedule) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"protectedGroup_schedule_update_operateName", (String)"System", (String)"", null), true);
        this.service = service;
        this.protectGroup = protectGroup;
        this.schedule = schedule;
        this.oldSchedule = oldSchedule;
    }

    protected void doWork() {
        this.service.getBaseDao().getTransactionTemplate().execute((TransactionCallback)this);
    }

    public Object doInTransaction(TransactionStatus transactionStatus) {
        try {
            int messageType = 13;
            MessageEvent event = MessageEvent.createMessageEvent((int)messageType, (Object[])new Object[]{this.protectGroup, this.schedule});
            this.service.notifyObserverList(event, "before");
            String protectGroupId = this.protectGroup.getUuid();
            if (this.schedule.getScheduleMode() == 1 && this.oldSchedule.getScheduleMode() == 0 && this.oldSchedule.getPeriodType() != 5) {
                this.service.getProtectionTaskService().disableTask(protectGroupId, this.schedule.getScheduleId());
            }
            if (this.schedule.getScheduleMode() == 0 && this.schedule.getPeriodType() != 5 && this.oldSchedule.getScheduleMode() == 1) {
                this.service.getProtectionTaskService().updateTask(protectGroupId, this.schedule);
            }
            if (this.schedule.getScheduleMode() == 0 && this.oldSchedule.getScheduleMode() == 0 && this.oldSchedule.getPeriodType() != 5) {
                this.service.getProtectionTaskService().updateTask(protectGroupId, this.schedule);
            }
            if (this.oldSchedule.getScheduleMode() == 0 && this.oldSchedule.getPeriodType() == 5 && (this.schedule.getPeriodType() != this.oldSchedule.getPeriodType() || this.schedule.getScheduleMode() == 1)) {
                if (VerifyUtil.isEmpty((Object)this.service.getProtectionTaskService().getTask(protectGroupId, this.schedule.getScheduleId()))) {
                    this.service.getProtectionTaskService().addTask(this.protectGroup, this.schedule);
                } else {
                    this.service.getProtectionTaskService().updateTask(protectGroupId, this.schedule);
                }
            }
            IBaseDao baseDao = CommonDAOLocator.getBaseDao();
            baseDao.delete("delete from ti_ScheduleRangeTime where scheduleId=?", new Object[]{this.schedule.getScheduleId()});
            baseDao.flush();
            if (this.oldSchedule.getPeriodType() != 5 && this.schedule.getPeriodType() == 5) {
                this.service.getProtectionTaskService().deleteTask(protectGroupId, this.schedule.getScheduleId());
            }
            Schedule scheduleInDb = (Schedule)baseDao.getHibernateTemplate().get(Schedule.class, (Serializable)((Object)this.schedule.getScheduleId()));
            baseDao.evict((Object)scheduleInDb);
            baseDao.getHibernateTemplate().saveOrUpdate((Object)this.schedule);
            MessageEvent afterEvent = MessageEvent.createMessageEvent((int)messageType, (Object[])new Object[]{this.protectGroup, this.schedule});
            this.service.notifyObserverList(afterEvent, "after");
            this.updatePolicyTemplate(baseDao);
            IReplicaRetentionStrategyManager manager = (IReplicaRetentionStrategyManager)ServiceLocator.getInstance().getService(IReplicaRetentionStrategyManager.class);
            manager.executeStrategy(this.protectGroup);
        }
        catch (LegoCheckedException e) {
            String errorMsg = "update schedule[{0}] for protect group[{1}] failed.";
            errorMsg = MessageFormatUtil.format((String)errorMsg, (Object[])new Object[]{this.protectGroup.getUuid(), this.schedule.getScheduleId()});
            logger.error((Object)errorMsg);
            transactionStatus.setRollbackOnly();
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "update schedule[{0}] for protect group[{1}] failed.";
            errorMsg = MessageFormatUtil.format((String)errorMsg, (Object[])new Object[]{this.protectGroup.getUuid(), this.schedule.getScheduleId()});
            logger.error((Object)errorMsg);
            transactionStatus.setRollbackOnly();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
        return null;
    }

    private void updatePolicyTemplate(IBaseDao baseDao) {
        String oldScheduleSchemeId = (String)this.oldSchedule.getExtParameters().get("scriptSchemeId");
        String scheduleSchemeId = (String)this.schedule.getExtParameters().get("scriptSchemeId");
        PolicyTemplate policyTemplate = this.protectGroup.getTemplate();
        if (!VerifyUtil.isEmpty((String)oldScheduleSchemeId) && !oldScheduleSchemeId.equals(scheduleSchemeId)) {
            logger.info((Object)("schedule script scheme changed: " + oldScheduleSchemeId + " -> " + scheduleSchemeId + ", update policy template params, id: " + policyTemplate.getPtId()));
            policyTemplate.getProps().put("scriptSchemeId", scheduleSchemeId);
        }
        baseDao.getHibernateTemplate().merge((Object)policyTemplate);
    }
}

