/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.refinement;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.protection.framework.service.group.refinement.BaseProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleRangeTime;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class SynProtectGroupRefineService
extends BaseProtectGroupRefineService {
    private static final SynProtectGroupRefineService INSTANCE = new SynProtectGroupRefineService();
    private static Log logger = LogFactory.getInstance(SynProtectGroupRefineService.class);

    private SynProtectGroupRefineService() {
    }

    public static SynProtectGroupRefineService getInstance() {
        return INSTANCE;
    }

    public void syncProtectGroupToRemoteSite(ProtectGroup protectGroup, String url) {
        Set replicas = protectGroup.getReplicaList();
        HashSet<String> recoverSiteIds = new HashSet<String>();
        for (ProtectGroupReplica replica : replicas) {
            recoverSiteIds.add(replica.getRecoverySite());
        }
        if (VerifyUtil.isEmpty((Collection)replicas)) {
            return;
        }
        for (String recoverySiteId : recoverSiteIds) {
            if (VerifyUtil.isEmpty((String)recoverySiteId)) continue;
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
            if (VerifyUtil.isEmpty((Object)site)) {
                logger.error((Object)"Recovery Site is not exsit", 90160758786989L);
                throw new LegoCheckedException(1073947440L);
            }
            if (1 != site.getSiteType()) continue;
            RestClient client = SiteUtil.initClient(site);
            try {
                ProtectGroup clonePg = (ProtectGroup)protectGroup.clone();
                IProtectObjectProvider provider = this.getProtectObjectProvider(clonePg);
                provider.decryptPropreties(clonePg);
                client.postSerializableObj((Object)clonePg, url);
            }
            catch (LegoCheckedException le) {
                logger.error((Object)this.getErrorMsg(protectGroup, site), (Throwable)le);
                throw le;
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)("clone pg error. pg: " + protectGroup.getUuid()), 90160758786989L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)this.getErrorMsg(protectGroup, site), (long)1073947440L, (String[])new String[0], (Log)logger);
            }
        }
    }

    private String getErrorMsg(ProtectGroup protectGroup, Site site) {
        String errorMsg = "sync Protect Group,name: " + protectGroup.getName() + " to remote site,name: " + site.getName() + " ,id: " + site.getSiteId() + " error";
        return errorMsg;
    }

    public void syncProtectGroupToLocal(ProtectGroup protectGroup) {
        if (null == protectGroup || VerifyUtil.isEmpty((String)protectGroup.getUuid())) {
            logger.error((Object)"failed to sync protectGroup because of invalidity paramiter.", 90160758786892L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkProductSite(protectGroup.getProductSiteId());
        IProtectObjectProvider provider = this.getProtectObjectProvider(protectGroup);
        provider.encryptProperties(protectGroup);
        MessageEvent updateEvent = new MessageEvent();
        updateEvent.setMessageType(1);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(protectGroup);
        updateEvent.setObjectList(objectList);
        HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        try {
            this.notifyObserverList(updateEvent, "before");
            String uuid = protectGroup.getTemplate().getUuid();
            HashMap templateProps = new HashMap();
            templateProps.putAll(protectGroup.getTemplate().getProps());
            protectGroup.getTemplate().setProps(templateProps);
            IPolicyTemplateManager policyTemplateManager = (IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class);
            PolicyTemplate policyTemplate = policyTemplateManager.getPtByUuid(uuid);
            this.resetSchedule(protectGroup);
            if (null == policyTemplate) {
                policyTemplateManager.addTemplate(protectGroup.getTemplate());
            } else {
                ((IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class)).deleteTasks(protectGroup.getUuid());
                template.deleteAll((Collection)policyTemplate.getSchedules());
                template.saveOrUpdate((Object)protectGroup.getTemplate());
            }
            protectGroup.setPrimary(false);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("failed to sync protectGroup:" + protectGroup.getName()), e.getErrorCode());
            ExceptionUtil.rethrowException((Exception)((Object)e), (String)("failed to sync protectGroup:" + protectGroup.getName()), (long)e.getErrorCode(), (String[])e.getParameters());
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to sync protectGroup:" + protectGroup.getName()), (long)1073947440L, (String[])new String[0], (Log)logger);
        }
        try {
            ProtectGroup oldProtectGroup = QueryProtectGroupRefineService.getInstance().getProtectGroupByID(protectGroup.getUuid(), true);
            template.deleteAll((Collection)oldProtectGroup.getPolist());
            template.deleteAll((Collection)oldProtectGroup.getReplicaList());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("SyncProtectGroup old ProtectGroup(" + protectGroup.getUuid() + ") not exist"), 90160758784001L);
        }
        try {
            protectGroup.getPgHistoryLogs().clear();
            template.saveOrUpdate((Object)protectGroup);
            this.notifyObserverList(updateEvent, "after");
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to sync protectGroup:" + protectGroup.getName()), (long)1073947440L, (String[])new String[0], (Log)logger);
        }
    }

    private void resetSchedule(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Collection)protectGroup.getTemplate().getSchedules())) {
            return;
        }
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            if (VerifyUtil.isEmpty((Collection)schedule.getScheduleRanges())) continue;
            for (ScheduleRangeTime scheduleRangeTime : schedule.getScheduleRanges()) {
                scheduleRangeTime.setSchedule(schedule);
            }
        }
    }

    private IProtectObjectProvider getProtectObjectProvider(ProtectGroup protectGroup) {
        IProtectObjectProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        return provider;
    }

    private void checkProductSite(String siteId) {
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)"ProductSite is not exist.", 90160758786989L);
            throw new LegoCheckedException(1073947440L);
        }
    }
}

