/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.retention.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.protection.framework.service.replica.retention.bean.ReplicaRetentionStrategy;
import com.huawei.ism.drm.protection.framework.service.replica.retention.impl.ReplicaRetentionJob;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyHandler;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.triggers.CronTriggerImpl;

public class ReplicaRetentionStrategyManagerImpl
implements IReplicaRetentionStrategyManager {
    private static Log logger = LogFactory.getInstance(ReplicaRetentionStrategyManagerImpl.class);
    private ITaskManager protectionTaskManager;
    private Set<IReplicaRetentionStrategyHandler> handlerList = new HashSet<IReplicaRetentionStrategyHandler>();

    public void onBind(IReplicaRetentionStrategyHandler provider, Map<?, ?> properties) {
        this.handlerList.add(provider);
    }

    public void onUnbind(IReplicaRetentionStrategyHandler provider, Map<?, ?> properties) {
        this.handlerList.remove(provider);
    }

    @Override
    public void executeStrategy(ProtectGroup pg) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (null == handler) {
            logger.error((Object)("replica handler is null,name :" + pg.getName()));
            return;
        }
        handler.executeStrategy(pg);
    }

    @Override
    public Set<ReplicaRetentionStrategy> getReplicaRetentionStrategy(ProtectGroup pg) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (null == handler) {
            logger.error((Object)("replica handler is null,name :" + pg.getName()));
            return new HashSet<ReplicaRetentionStrategy>();
        }
        return handler.convertReplicaStrategy(pg);
    }

    @Override
    public boolean checkRetentionStrategy(ProtectGroup pg) {
        String strategyValue = (String)pg.getTemplate().getProps().get("ReplicaRetentionPolicy");
        if (VerifyUtil.isEmpty((String)strategyValue)) {
            logger.info((Object)"Retention strategy is empty");
            return true;
        }
        IReplicaRetentionStrategyHandler supportHandler = this.getSupportHandler(pg);
        if (null == supportHandler) {
            logger.error((Object)("not support any handler" + (String)pg.getTemplate().getProps().get("ReplicaRetentionPolicy")));
            throw new LegoCheckedException(1073947393L);
        }
        return true;
    }

    private IReplicaRetentionStrategyHandler getSupportHandler(ProtectGroup pg) {
        IReplicaRetentionStrategyHandler supportHandler = null;
        for (IReplicaRetentionStrategyHandler handler : this.handlerList) {
            try {
                if (!handler.checkReplicaStrategy(pg)) continue;
                supportHandler = handler;
                break;
            }
            catch (Exception e) {
                logger.error((Object)("not support handler" + handler.getClass().getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return supportHandler;
    }

    @Override
    public void createRetentionTask(ProtectGroup pg) {
        IReplicaRetentionStrategyHandler supportHandler = this.getSupportHandler(pg);
        if (null == supportHandler) {
            logger.error((Object)("not support any handler" + (String)pg.getTemplate().getProps().get("ReplicaRetentionPolicy")));
            return;
        }
        try {
            JobKey jobKey = new JobKey(this.getJobName(pg), this.getJobGroupName());
            JobDetail jobDetail = this.protectionTaskManager.getquartzScheduler().getJobDetail(jobKey);
            if (null != jobDetail) {
                this.protectionTaskManager.getquartzScheduler().deleteJob(jobKey);
            }
            this.protectionTaskManager.getquartzScheduler().scheduleJob(this.buildJobDeatil(pg), this.buildCronTrigger(pg));
            logger.info((Object)"schedule ReplicaRetentionJob success!", 90160758786988L);
        }
        catch (SchedulerException e) {
            logger.error((Object)"schedule ReplicaRetentionJob failed!", (Throwable)e);
            throw new LegoCheckedException(0x300001L, (Throwable)e);
        }
    }

    @Override
    public void deleteRetentionTask(ProtectGroup pg) {
        try {
            JobKey jobKey = new JobKey(this.getJobName(pg), this.getJobGroupName());
            JobDetail jobDetail = this.protectionTaskManager.getquartzScheduler().getJobDetail(jobKey);
            if (null != jobDetail) {
                this.protectionTaskManager.getquartzScheduler().deleteJob(jobKey);
            }
            logger.info((Object)"schedule ReplicaRetentionJob success!", 90160758786988L);
        }
        catch (SchedulerException e) {
            logger.error((Object)"schedule ReplicaRetentionJob failed!", (Throwable)e);
        }
    }

    @Override
    public List<ProtectGroupReplica> getToReactivateReplicas(ProtectGroup pg, int protectLocation, Integer differ, Integer type) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (null == handler) {
            logger.error((Object)("replica handler is null,name :" + pg.getName()));
            return null;
        }
        return handler.getToReactivateReplicas(pg, protectLocation, differ, type);
    }

    @Override
    public void deleteReplicas(List<ProtectGroupReplica> toDelete, ProtectGroup pg) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (null == handler) {
            logger.error((Object)("replica handler is null,name :" + pg.getName()));
            return;
        }
        handler.deleteReplicas(toDelete, pg);
    }

    @Override
    public Set<String> getUsedReplicaIds(ProtectGroup pg) {
        IReplicaRetentionStrategyHandler handler = this.getSupportHandler(pg);
        if (null == handler) {
            logger.error((Object)("replica handler is null,name :" + pg.getName()));
            return new HashSet<String>();
        }
        return handler.getUsedReplicaIds(pg);
    }

    private JobDetail buildJobDeatil(ProtectGroup pg) {
        JobDetailImpl jobDetail = new JobDetailImpl();
        jobDetail.setJobClass(ReplicaRetentionJob.class);
        jobDetail.setName(this.getJobName(pg));
        jobDetail.setGroup(this.getJobGroupName());
        jobDetail.setDurability(true);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("pg_id_key", pg.getUuid());
        jobDetail.setJobDataMap(jobDataMap);
        return jobDetail;
    }

    private Trigger buildCronTrigger(ProtectGroup pg) {
        String cronExpression = "0 39 * * * ?";
        CronTriggerImpl quarzTrigger = null;
        try {
            quarzTrigger = new CronTriggerImpl(this.getTriggerName(pg), this.getTriggerGroupName(), cronExpression);
            quarzTrigger.setStartTime(new Date());
        }
        catch (ParseException e) {
            logger.error((Object)"parse crontab expression failed", (Throwable)e, 90160758784001L);
        }
        return quarzTrigger;
    }

    private String getJobName(ProtectGroup pg) {
        return "retention_job_" + pg.getUuid();
    }

    private String getJobGroupName() {
        return "retention_job_group";
    }

    private String getTriggerName(ProtectGroup pg) {
        return "retention_trigger_" + pg.getUuid();
    }

    private String getTriggerGroupName() {
        return "retention_trigger_group";
    }

    public ITaskManager getProtectionTaskManager() {
        return this.protectionTaskManager;
    }

    public void setProtectionTaskManager(ITaskManager protectionTaskManager) {
        this.protectionTaskManager = protectionTaskManager;
    }
}

